/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.container.InteractContainerEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.inventory.util.ContainerUtil;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class OpenInventoryState
extends BasicInventoryPacketState {
    @Override
    public void unwind(InventoryPacketContext context) {
        ServerPlayerEntity player = context.getPacketPlayer();
        ItemStackSnapshot lastCursor = context.getCursor();
        ItemStackSnapshot newCursor = ItemStackUtil.snapshotOf(player.inventory.getItemStack());
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(lastCursor, newCursor);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            InteractContainerEvent.Open event = SpongeEventFactory.createInteractContainerEventOpen(frame.getCurrentCause(), ContainerUtil.fromNative(player.openContainer), cursorTransaction);
            SpongeCommon.postEvent(event);
            if (event.isCancelled()) {
                player.closeScreen();
            } else {
                Transaction<ItemStackSnapshot> transaction = event.getCursorTransaction();
                if (!transaction.isValid()) {
                    PacketPhaseUtil.handleCustomCursor((PlayerEntity)player, transaction.getOriginal());
                } else if (transaction.getCustom().isPresent()) {
                    PacketPhaseUtil.handleCustomCursor((PlayerEntity)player, transaction.getFinal());
                }
            }
        }
    }
}

