/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlaceRecipePacket;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.crafting.CraftingOutput;
import org.spongepowered.api.item.inventory.query.QueryTypes;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.recipe.Recipe;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.inventory.container.TrackedContainerBridge;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.event.inventory.InventoryEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class PlaceRecipePacketState
extends BasicInventoryPacketState {
    @Override
    public void populateContext(ServerPlayerEntity playerMP, IPacket<?> packet, InventoryPacketContext context) {
        ((TrackedInventoryBridge)playerMP.openContainer).bridge$setCaptureInventory(true);
        ((TrackedContainerBridge)playerMP.openContainer).bridge$setFirePreview(false);
    }

    @Override
    public void unwind(InventoryPacketContext context) {
        CPlaceRecipePacket packet = (CPlaceRecipePacket)context.getPacket();
        boolean shift = packet.shouldPlaceAll();
        RecipeManager recipeManager = context.getPacketPlayer().server.getRecipeManager();
        IRecipe recipe = recipeManager.getRecipe(packet.getRecipeId()).orElse(null);
        ServerPlayerEntity player = context.getPacketPlayer();
        ((TrackedContainerBridge)player.openContainer).bridge$detectAndSendChanges(true);
        ((TrackedInventoryBridge)player.openContainer).bridge$setCaptureInventory(false);
        ((TrackedContainerBridge)player.openContainer).bridge$setFirePreview(true);
        Inventory craftInv = ((Inventory)player.openContainer).query(QueryTypes.INVENTORY_TYPE.get().of(CraftingInventory.class));
        if (!(craftInv instanceof CraftingInventory)) {
            SpongeCommon.getLogger().warn("Detected crafting without a InventoryCrafting!? Crafting Event will not fire.");
            return;
        }
        List<SlotTransaction> previewTransactions = ((TrackedContainerBridge)player.openContainer).bridge$getPreviewTransactions();
        if (previewTransactions.isEmpty()) {
            CraftingOutput slot = ((CraftingInventory)craftInv).getResult();
            SlotTransaction st = new SlotTransaction(slot, ItemStackSnapshot.empty(), slot.peek().createSnapshot());
            previewTransactions.add(st);
        }
        InventoryEventFactory.callCraftEventPre((PlayerEntity)player, (CraftingInventory)craftInv, previewTransactions.get(0), (CraftingRecipe)recipe, player.openContainer, previewTransactions);
        previewTransactions.clear();
        Entity spongePlayer = (Entity)player;
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(spongePlayer);
            frame.pushCause(player.openContainer);
            List<SlotTransaction> transactions = ((TrackedInventoryBridge)player.openContainer).bridge$getCapturedSlotTransactions();
            ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(player.inventory.getItemStack());
            Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(cursor, cursor);
            ClickContainerEvent.Recipe event = shift ? SpongeEventFactory.createClickContainerEventRecipeAll(frame.getCurrentCause(), (Container)player.openContainer, cursorTransaction, (Recipe)recipe, Optional.empty(), transactions) : SpongeEventFactory.createClickContainerEventRecipeSingle(frame.getCurrentCause(), (Container)player.openContainer, cursorTransaction, (Recipe)recipe, Optional.empty(), transactions);
            SpongeCommon.postEvent(event);
            if (event.isCancelled() || !event.getCursorTransaction().isValid()) {
                PacketPhaseUtil.handleCustomCursor((PlayerEntity)player, event.getCursorTransaction().getOriginal());
            } else {
                PacketPhaseUtil.handleCustomCursor((PlayerEntity)player, event.getCursorTransaction().getFinal());
            }
            PacketPhaseUtil.handleSlotRestore((PlayerEntity)player, player.openContainer, event.getTransactions(), event.isCancelled());
            event.getTransactions().clear();
        }
    }
}

