/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.accessor.entity.LivingEntityAccessor;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractionPacketContext;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class InteractionPacketState
extends PacketState<InteractionPacketContext> {
    @Override
    public InteractionPacketContext createNewContext(PhaseTracker tracker) {
        return new InteractionPacketContext(this, tracker);
    }

    @Override
    public boolean isInteraction() {
        return true;
    }

    @Override
    public void populateContext(ServerPlayerEntity playerMP, IPacket<?> packet, InteractionPacketContext context) {
        BlockPos target;
        ItemStack itemInUse;
        ItemStack stack = ItemStackUtil.cloneDefensive(playerMP.getHeldItemMainhand());
        if (stack != null) {
            context.itemUsed(stack);
        }
        if ((itemInUse = ItemStackUtil.cloneDefensive(playerMP.getActiveItemStack())) != null) {
            context.activeItem(itemInUse);
        }
        if (!playerMP.world.isBlockLoaded(target = ((CPlayerDiggingPacket)packet).getPosition())) {
            context.targetBlock(BlockSnapshot.empty());
        } else {
            context.targetBlock(((TrackedWorldBridge)playerMP.world).bridge$createSnapshot(target, BlockChangeFlags.NONE));
        }
        context.handUsed(HandTypes.MAIN_HAND.get());
    }

    @Override
    public boolean shouldCaptureEntity() {
        return true;
    }

    @Override
    public boolean doesCaptureNeighborNotifications(InteractionPacketContext context) {
        return true;
    }

    @Override
    public void unwind(InteractionPacketContext phaseContext) {
        ServerPlayerEntity player = phaseContext.getPacketPlayer();
        ItemStack usedStack = phaseContext.getItemUsed();
        HandType usedHand = phaseContext.getHandUsed();
        ItemStackSnapshot usedSnapshot = ItemStackUtil.snapshotOf(usedStack);
        Entity spongePlayer = (Entity)player;
        BlockSnapshot targetBlock = phaseContext.getTargetBlock();
        net.minecraft.item.ItemStack endActiveItem = player.getActiveItemStack();
        ((LivingEntityAccessor)player).accessor$setActiveItemStack(ItemStackUtil.toNative(phaseContext.getActiveItem()));
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            BlockSnapshot firstBlockChange;
            frame.pushCause(spongePlayer);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            frame.addContext(EventContextKeys.USED_ITEM, usedSnapshot);
            frame.addContext(EventContextKeys.USED_HAND, usedHand);
            frame.addContext(EventContextKeys.BLOCK_HIT, targetBlock);
            boolean hasBlocks = !phaseContext.getTransactor().isEmpty();
            List<SpongeBlockSnapshot> capturedBlcoks = phaseContext.getCapturedOriginalBlocksChanged();
            BlockSnapshot blockSnapshot = hasBlocks ? (capturedBlcoks.isEmpty() ? null : (BlockSnapshot)capturedBlcoks.get(0)) : (firstBlockChange = null);
            if (hasBlocks && !TrackingUtil.processBlockCaptures(phaseContext)) {
                return;
            }
            TrackedInventoryBridge trackedInventory = (TrackedInventoryBridge)player.openContainer;
            trackedInventory.bridge$setCaptureInventory(false);
            trackedInventory.bridge$getCapturedSlotTransactions().clear();
        }
        ((LivingEntityAccessor)player).accessor$setActiveItemStack(endActiveItem);
    }
}

