/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.plugin;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.plugin.ListenerPhaseContext;
import org.spongepowered.common.util.PrettyPrinter;

public class WorldTickListenerContext
extends ListenerPhaseContext<WorldTickListenerContext> {
    @Nullable
    private World tickingWorld;

    WorldTickListenerContext(IPhaseState<WorldTickListenerContext> state, PhaseTracker tracker) {
        super(state, tracker);
    }

    public WorldTickListenerContext world(World world) {
        this.tickingWorld = world;
        return this;
    }

    public World getWorld() {
        return (World)Preconditions.checkNotNull((Object)this.tickingWorld, (Object)"Ticking World is null");
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s2 = String.format("%1$" + indent + "s", "");
        super.printCustom(printer, indent);
        if (!((WorldBridge)this.getWorld()).bridge$isFake()) {
            printer.add(s2 + "- %s: %s", "TickingWorld", ((ServerWorld)this.getWorld()).getKey());
        } else {
            printer.add(s2 + "- %s: %s", "Ticking World", "Pseudo Fake World?" + this.tickingWorld);
        }
        return printer;
    }

    @Override
    protected void reset() {
        super.reset();
        this.tickingWorld = null;
    }
}

