/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.util.CombatEntry;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.common.accessor.entity.item.ItemFrameEntityAccessor;
import org.spongepowered.common.accessor.util.CombatEntryAccessor;
import org.spongepowered.common.accessor.util.CombatTrackerAccessor;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.entity.EntityTrackedBridge;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;

class EntityTickPhaseState
extends TickPhaseState<EntityTickContext> {
    private final BiConsumer<CauseStackManager.StackFrame, EntityTickContext> ENTITY_TICK_MODIFIER = super.getFrameModifier().andThen((frame, context) -> {
        org.spongepowered.api.entity.Entity tickingEntity = context.getSource(org.spongepowered.api.entity.Entity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on an Entity!", context));
        if (tickingEntity instanceof FallingBlockEntity) {
            context.getCreator().ifPresent(frame::pushCause);
        }
        frame.pushCause(tickingEntity);
        ((EntityTrackedBridge)((Object)tickingEntity)).populateFrameModifier((CauseStackManager.StackFrame)frame, (EntityTickContext)context);
    });

    EntityTickPhaseState() {
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, EntityTickContext> getFrameModifier() {
        return this.ENTITY_TICK_MODIFIER;
    }

    @Override
    public void unwind(EntityTickContext phaseContext) {
        org.spongepowered.api.entity.Entity tickingEntity = phaseContext.getSource(org.spongepowered.api.entity.Entity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on an Entity!", phaseContext));
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            this.processCaptures(tickingEntity, phaseContext, frame);
        }
    }

    protected void processCaptures(org.spongepowered.api.entity.Entity tickingEntity, EntityTickContext phaseContext, CauseStackManager.StackFrame frame) {
        phaseContext.addCreatorAndNotifierToCauseStack(frame);
        if (phaseContext.allowsBulkBlockCaptures() && !TrackingUtil.processBlockCaptures(phaseContext)) {
            ((EntityBridge)((Object)tickingEntity)).bridge$onCancelledBlockChange(phaseContext);
        }
        if (!phaseContext.allowsBulkEntityCaptures()) {
            return;
        }
    }

    private void appendContextOfPossibleEntityDeath(org.spongepowered.api.entity.Entity tickingEntity, CauseStackManager.StackFrame frame) {
        CombatEntry entry;
        if (EntityUtil.isEntityDead((Entity)tickingEntity) && tickingEntity instanceof LivingEntity && (entry = ((CombatTrackerAccessor)((LivingEntity)tickingEntity).getCombatTracker()).accessor$getBestCombatEntry()) != null && ((CombatEntryAccessor)entry).accessor$getDamageSrc() != null) {
            frame.addContext(EventContextKeys.LAST_DAMAGE_SOURCE, (DamageSource)((CombatEntryAccessor)entry).accessor$getDamageSrc());
        }
    }

    @Override
    protected EntityTickContext createNewContext(PhaseTracker tracker) {
        return (EntityTickContext)new EntityTickContext(this, tracker).addCaptures();
    }

    @Override
    public void postBlockTransactionApplication(BlockChange blockChange, Transaction<? extends BlockSnapshot> transaction, EntityTickContext context) {
        if (blockChange == BlockChange.BREAK) {
            org.spongepowered.api.entity.Entity tickingEntity = context.getSource(org.spongepowered.api.entity.Entity.class).get();
            BlockPos blockPos = VecHelper.toBlockPos(transaction.getOriginal().getPosition());
            List hangingEntities = ((ServerWorld)tickingEntity.getWorld()).getEntitiesWithinAABB(HangingEntity.class, new AxisAlignedBB(blockPos, blockPos).grow(1.1, 1.1, 1.1), entityIn -> {
                if (entityIn == null) {
                    return false;
                }
                BlockPos entityPos = entityIn.getPosition();
                if (entityPos.equals((Object)blockPos.add(0, 1, 0))) {
                    return true;
                }
                Direction entityFacing = entityIn.getHorizontalFacing();
                if (entityFacing == Direction.NORTH) {
                    return entityPos.equals((Object)blockPos.add((Vec3i)Constants.Entity.HANGING_OFFSET_NORTH));
                }
                if (entityFacing == Direction.SOUTH) {
                    return entityIn.getPosition().equals((Object)blockPos.add((Vec3i)Constants.Entity.HANGING_OFFSET_SOUTH));
                }
                if (entityFacing == Direction.WEST) {
                    return entityIn.getPosition().equals((Object)blockPos.add((Vec3i)Constants.Entity.HANGING_OFFSET_WEST));
                }
                if (entityFacing == Direction.EAST) {
                    return entityIn.getPosition().equals((Object)blockPos.add((Vec3i)Constants.Entity.HANGING_OFFSET_EAST));
                }
                return false;
            });
            for (HangingEntity entityHanging : hangingEntities) {
                if (!(entityHanging instanceof ItemFrameEntity)) continue;
                ItemFrameEntity itemFrame = (ItemFrameEntity)entityHanging;
                if (!itemFrame.removed) {
                    ((ItemFrameEntityAccessor)itemFrame).accessor$dropItemOrSelf((Entity)tickingEntity, true);
                }
                itemFrame.remove();
            }
        }
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, EntityTickContext context) {
        if (!context.applyNotifierIfAvailable(explosionContext::creator)) {
            context.applyOwnerIfAvailable(explosionContext::creator);
        }
        explosionContext.source(context.getSource(org.spongepowered.api.entity.Entity.class).orElseThrow(() -> new IllegalStateException("Ticking a non Entity")));
    }

    @Override
    public boolean doesBlockEventTracking(EntityTickContext context) {
        return context.allowsBlockEvents();
    }
}

