/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.hooks;

import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.world.dimension.DimensionTypes;
import org.spongepowered.common.world.dimension.SpongeDimensionType;

public interface DimensionHooks {
    default public boolean doesGenerateSpawnOnLoad(SpongeDimensionType dimensionType) {
        return DimensionTypes.OVERWORLD.get() == dimensionType;
    }

    default public DimensionType getRespawnDimension(ServerPlayerEntity entity, DimensionType dimensionType, boolean conqueredEnd) {
        ServerWorld world = entity.getServer().getWorld(entity.dimension);
        if (world == null) {
            return dimensionType;
        }
        return conqueredEnd || !world.getDimension().canRespawnHere() ? dimensionType : entity.dimension;
    }
}

