/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.custom.CustomInventory;
import org.spongepowered.common.inventory.lens.CompoundSlotLensProvider;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.CompoundLens;
import org.spongepowered.common.inventory.lens.impl.DefaultIndexedLens;
import org.spongepowered.common.inventory.lens.impl.DelegatingLens;
import org.spongepowered.common.inventory.lens.impl.LensRegistrar;
import org.spongepowered.common.inventory.lens.impl.comp.GridInventoryLens;

public class SpongeInventoryBuilder
implements Inventory.Builder,
Inventory.Builder.BuildingStep,
Inventory.Builder.EndStep {
    private List<Lens> lenses = new ArrayList<Lens>();
    private List<Inventory> inventories = new ArrayList<Inventory>();
    private int size = 0;
    private Lens finalLens;
    @Nullable
    private UUID identity;
    @Nullable
    private Carrier carrier;
    private CompoundSlotLensProvider finalProvider;

    @Override
    public Inventory.Builder.BuildingStep slots(int amount) {
        this.size += amount;
        net.minecraft.inventory.Inventory adapter = new net.minecraft.inventory.Inventory(amount);
        this.inventories.add((Inventory)adapter);
        this.lenses.add(new DefaultIndexedLens(0, amount, ((InventoryAdapter)adapter).inventoryAdapter$getSlotLensProvider()));
        return this;
    }

    @Override
    public Inventory.Builder.BuildingStep grid(int sizeX, int sizeY) {
        this.size += sizeX * sizeY;
        net.minecraft.inventory.Inventory adapter = new net.minecraft.inventory.Inventory(sizeX * sizeY);
        this.lenses.add(new GridInventoryLens(0, sizeX, sizeY, ((InventoryAdapter)adapter).inventoryAdapter$getSlotLensProvider()));
        this.inventories.add((Inventory)adapter);
        return this;
    }

    @Override
    public Inventory.Builder.BuildingStep inventory(Inventory inventory) {
        InventoryAdapter adapter = (InventoryAdapter)((Object)inventory);
        this.size += inventory.capacity();
        this.lenses.add(adapter.inventoryAdapter$getRootLens());
        this.inventories.add(inventory);
        return this;
    }

    @Override
    public Inventory.Builder.EndStep completeStructure() {
        CompoundLens.Builder lensBuilder = CompoundLens.builder();
        int size = 0;
        for (Lens lens : this.lenses) {
            size += lens.slotCount();
        }
        LensRegistrar.BasicSlotLensProvider lensProvider = new LensRegistrar.BasicSlotLensProvider(size);
        int offset = 0;
        for (Lens lens : this.lenses) {
            lensBuilder.add(new DelegatingLens(offset, lens, lensProvider));
            offset += lens.slotCount();
        }
        this.finalLens = lensBuilder.build(lensProvider);
        return this;
    }

    @Override
    public Inventory.Builder.EndStep identity(UUID uuid) {
        this.identity = uuid;
        return this;
    }

    @Override
    public Inventory.Builder.EndStep carrier(Carrier carrier) {
        this.carrier = carrier;
        return this;
    }

    @Override
    public Inventory build() {
        return (Inventory)((Object)new CustomInventory(this.size, this.finalLens, this.finalProvider, this.inventories, this.identity, this.carrier));
    }

    @Override
    public Inventory.Builder reset() {
        this.lenses = new ArrayList<Lens>();
        this.inventories = new ArrayList<Inventory>();
        this.size = 0;
        this.finalLens = null;
        this.finalProvider = null;
        this.identity = null;
        this.carrier = null;
        return this;
    }
}

