/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.custom;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.item.inventory.ContainerType;
import org.spongepowered.common.inventory.custom.CustomInventory;

public class CustomContainer
extends Container {
    public CustomInventory inv;

    public CustomContainer(int id, PlayerEntity player, CustomInventory inventory, ContainerType type) {
        super((net.minecraft.inventory.container.ContainerType)type, id);
        this.inv = inventory;
        for (int slot = 0; slot < inventory.getSizeInventory(); ++slot) {
            this.addSlot(new Slot((IInventory)inventory, slot, 0, 0));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((IInventory)player.inventory, (row + 1) * 9 + col, 0, 0));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((IInventory)player.inventory, col, 0, 0));
        }
    }

    public boolean canInteractWith(PlayerEntity playerIn) {
        return true;
    }

    public void onContainerClosed(PlayerEntity playerIn) {
        super.onContainerClosed(playerIn);
        this.inv.closeInventory(playerIn);
    }

    public ItemStack transferStackInSlot(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.inventorySlots.get(index);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if (index < this.inv.getSizeInventory() ? !this.mergeItemStack(itemstack1, this.inv.getSizeInventory(), this.inventorySlots.size(), true) : !this.mergeItemStack(itemstack1, 0, this.inv.getSizeInventory(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.putStack(ItemStack.EMPTY);
            } else {
                slot.onSlotChanged();
            }
        }
        return itemstack;
    }
}

