/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.shapeless;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.spongepowered.common.item.recipe.ingredient.SpongeIngredient;

public class SpongeShapelessRecipe
extends ShapelessRecipe {
    private final boolean onlyVanillaIngredients;
    private final Function<CraftingInventory, ItemStack> resultFunction;
    private final Function<CraftingInventory, NonNullList<ItemStack>> remainingItemsFunction;

    public SpongeShapelessRecipe(ResourceLocation idIn, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn, Function<CraftingInventory, ItemStack> resultFunction, Function<CraftingInventory, NonNullList<ItemStack>> remainingItemsFunction) {
        super(idIn, groupIn, recipeOutputIn, recipeItemsIn);
        this.onlyVanillaIngredients = recipeItemsIn.stream().noneMatch(i -> i instanceof SpongeIngredient);
        this.resultFunction = resultFunction;
        this.remainingItemsFunction = remainingItemsFunction;
    }

    public boolean matches(CraftingInventory inv, World p_77569_2_) {
        if (this.onlyVanillaIngredients) {
            return super.matches(inv, p_77569_2_);
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int j = 0; j < inv.getSizeInventory(); ++j) {
            ItemStack itemstack = inv.getStackInSlot(j);
            if (itemstack.isEmpty()) continue;
            items.add(itemstack);
        }
        return SpongeShapelessRecipe.matches(items, (List<Ingredient>)this.getIngredients());
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        if (this.remainingItemsFunction != null) {
            return this.remainingItemsFunction.apply(inv);
        }
        return super.getRemainingItems((IInventory)inv);
    }

    public ItemStack getCraftingResult(CraftingInventory p_77572_1_) {
        if (this.resultFunction != null) {
            return this.resultFunction.apply(p_77572_1_);
        }
        return super.getCraftingResult(p_77572_1_);
    }

    public ItemStack getRecipeOutput() {
        if (this.resultFunction != null) {
            return ItemStack.EMPTY;
        }
        return super.getRecipeOutput();
    }

    private static boolean matches(List<ItemStack> stacks, List<Ingredient> ingredients) {
        int elements = ingredients.size();
        if (stacks.size() != elements) {
            return false;
        }
        HashMap<Integer, List> matchesMap = new HashMap<Integer, List>();
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = ingredients.get(i);
            boolean noMatch = true;
            for (int j = 0; j < stacks.size(); ++j) {
                if (!ingredient.test(stacks.get(j))) continue;
                matchesMap.computeIfAbsent(j, k -> new ArrayList()).add(i);
                noMatch = false;
            }
            if (!noMatch) continue;
            return false;
        }
        if (matchesMap.isEmpty()) {
            return false;
        }
        ArrayList<Collection<Integer>> stackList = new ArrayList<Collection<Integer>>(matchesMap.values());
        stackList.sort(Comparator.comparingInt(Collection::size));
        return SpongeShapelessRecipe.matchesRecursive(stackList, 0, new HashSet<Integer>());
    }

    private static boolean matchesRecursive(List<Collection<Integer>> stackList, int d, Set<Integer> used) {
        if (d == stackList.size()) {
            return true;
        }
        Collection<Integer> stacks = stackList.get(d);
        for (Integer stack : stacks) {
            if (used.contains(stack)) continue;
            HashSet<Integer> copy = new HashSet<Integer>(used);
            copy.add(stack);
            if (!SpongeShapelessRecipe.matchesRecursive(stackList, d + 1, copy)) continue;
            return true;
        }
        return false;
    }
}

