/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.hooks.SpongeHooks;
import org.spongepowered.common.item.util.ItemStackUtil;

public class ResultUtil {
    private static final Map<String, Function<?, net.minecraft.item.ItemStack>> cachedResultFunctions = new HashMap();
    private static final Map<String, Function<?, NonNullList<net.minecraft.item.ItemStack>>> cachedRemainingItemsFunctions = new HashMap();

    public static net.minecraft.item.ItemStack deserializeItemStack(JsonObject result) {
        if (result == null) {
            return null;
        }
        try {
            DataContainer dataContainer = DataFormats.JSON.get().read(result.toString());
            return ItemStackUtil.toNative(ItemStack.builder().fromContainer(dataContainer).build());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static JsonElement serializeItemStack(net.minecraft.item.ItemStack spongeResult) {
        DataContainer dataContainer = ItemStackUtil.fromNative(spongeResult).toContainer();
        try {
            return JSONUtils.fromJson((String)DataFormats.JSON.get().write(dataContainer));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <C extends IInventory> Function<C, net.minecraft.item.ItemStack> deserializeResultFunction(JsonObject json) {
        if (json.has("sponge:result_function")) {
            String id = JSONUtils.getString((JsonObject)json, (String)"sponge:result_function");
            return cachedResultFunctions.get(id);
        }
        return null;
    }

    public static <C extends IInventory> String cacheResultFunction(ResourceLocation id, Function<C, net.minecraft.item.ItemStack> resultFunction) {
        if (cachedResultFunctions.put(id.toString(), resultFunction) != null) {
            SpongeHooks.logWarning("Duplicate cache result registration! " + id.toString() + " was replaced.", new Object[0]);
        }
        return id.toString();
    }

    public static <C extends IInventory> Function<C, NonNullList<net.minecraft.item.ItemStack>> deserializeRemainingItemsFunction(JsonObject json) {
        if (json.has("sponge:remaining_items")) {
            String id = JSONUtils.getString((JsonObject)json, (String)"sponge:remaining_items");
            return cachedRemainingItemsFunctions.get(id);
        }
        return null;
    }

    public static <C extends IInventory> String cacheRemainingItemsFunction(ResourceLocation id, Function<C, NonNullList<net.minecraft.item.ItemStack>> resultFunction) {
        if (cachedRemainingItemsFunctions.put(id.toString(), resultFunction) != null) {
            SpongeHooks.logWarning("Duplicate cache result registration! " + id.toString() + " was replaced.", new Object[0]);
        }
        return id.toString();
    }

    public static void clearCache() {
        cachedResultFunctions.clear();
        cachedRemainingItemsFunctions.clear();
    }
}

