/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.block;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.fluid.IFluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.block.BlockStateSerializerDeserializer;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.mixin.api.mcp.state.StateHolderMixin_API;
import org.spongepowered.common.util.Constants;

@Mixin(value={net.minecraft.block.BlockState.class})
public abstract class BlockStateMixin_API
extends StateHolderMixin_API<BlockState, net.minecraft.block.BlockState>
implements BlockState {
    private String impl$serializedState;

    @Shadow
    public abstract Block shadow$getBlock();

    @Shadow
    public abstract IFluidState shadow$getFluidState();

    @Shadow
    public abstract net.minecraft.block.BlockState shadow$rotate(Rotation var1);

    @Shadow
    public abstract net.minecraft.block.BlockState shadow$mirror(Mirror var1);

    @Override
    public BlockType getType() {
        return (BlockType)this.shadow$getBlock();
    }

    @Override
    public FluidState getFluidState() {
        return (FluidState)this.shadow$getFluidState();
    }

    @Override
    public int getContentVersion() {
        return 2;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, this.getContentVersion()).set(Constants.Block.BLOCK_STATE, this.impl$getSerializedString());
    }

    @Override
    public BlockSnapshot snapshotFor(ServerLocation location) {
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled().blockState((net.minecraft.block.BlockState)this).position(location.getBlockPosition()).world((ServerWorld)location.getWorld());
        if (this.shadow$getBlock().hasTileEntity() && location.getBlock().getType().equals(this.shadow$getBlock())) {
            BlockEntity tileEntity = location.getBlockEntity().orElseThrow(() -> new IllegalStateException("Unable to retrieve a TileEntity for location: " + location));
            builder.add(((CustomDataHolderBridge)((Object)tileEntity)).bridge$getManipulator());
            CompoundNBT compound = new CompoundNBT();
            ((TileEntity)tileEntity).write(compound);
            builder.addUnsafeCompound(compound);
        }
        return builder.build();
    }

    @Override
    public boolean validateRawData(DataView container) {
        return container.contains(Constants.Block.BLOCK_STATE);
    }

    @Override
    public <E> Optional<E> get(Direction direction, Key<? extends Value<E>> key) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public BlockState withRawData(DataView container) throws InvalidDataException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public BlockState copy() {
        return this;
    }

    public String impl$getSerializedString() {
        if (this.impl$serializedState == null) {
            this.impl$serializedState = BlockStateSerializerDeserializer.serialize(this);
        }
        return this.impl$serializedState;
    }

    @Override
    public BlockState rotate(org.spongepowered.api.util.rotation.Rotation rotation) {
        return (BlockState)this.shadow$rotate((Rotation)Objects.requireNonNull(rotation, "Rotation cannot be null!"));
    }

    @Override
    public BlockState mirror(org.spongepowered.api.util.mirror.Mirror mirror) {
        return (BlockState)this.shadow$mirror((Mirror)Objects.requireNonNull(mirror, "Mirror cannot be null!"));
    }
}

