/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.enchantment;

import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.hooks.SpongeImplHooks;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={Enchantment.class})
@Implements(value={@Interface(iface=EnchantmentType.class, prefix="enchantment$")})
public abstract class EnchantmentMixin_API
implements EnchantmentType {
    @Shadow
    protected String name;
    @Shadow
    @Final
    private Enchantment.Rarity rarity;
    @Nullable
    private ResourceLocation api$id;

    @Shadow
    public abstract int shadow$getMinLevel();

    @Shadow
    public abstract int shadow$getMaxLevel();

    @Shadow
    public abstract int shadow$getMinEnchantability(int var1);

    @Shadow
    public abstract int shadow$getMaxEnchantability(int var1);

    @Shadow
    protected abstract boolean shadow$canApplyTogether(Enchantment var1);

    @Shadow
    public abstract String shadow$getName();

    @Shadow
    public abstract boolean shadow$isTreasureEnchantment();

    @Shadow
    public abstract boolean shadow$isCurse();

    @Override
    public ResourceKey getKey() {
        ResourceLocation id;
        if (this.api$id == null && (id = Registry.ENCHANTMENT.getKey((Object)((Enchantment)this))) != null) {
            this.api$id = id;
        }
        return (ResourceKey)this.api$id;
    }

    @Override
    public int getWeight() {
        return this.rarity.getWeight();
    }

    @Override
    public int getMinimumLevel() {
        return this.shadow$getMinLevel();
    }

    @Override
    public int getMaximumLevel() {
        return this.shadow$getMaxLevel();
    }

    @Override
    public int getMinimumEnchantabilityForLevel(int level) {
        return this.shadow$getMinEnchantability(level);
    }

    @Override
    public int getMaximumEnchantabilityForLevel(int level) {
        return this.shadow$getMaxEnchantability(level);
    }

    @Override
    public boolean canBeAppliedByTable(ItemStack stack) {
        return this.canBeAppliedToStack(stack);
    }

    @Override
    public boolean canBeAppliedToStack(ItemStack stack) {
        return SpongeImplHooks.canEnchantmentBeAppliedToItem((Enchantment)this, ItemStackUtil.toNative(stack));
    }

    @Override
    public boolean isCompatibleWith(EnchantmentType ench) {
        return this.shadow$canApplyTogether((Enchantment)ench);
    }

    public Component asComponent() {
        return Component.translatable((String)this.shadow$getName(), (TextColor)(this.shadow$isCurse() ? NamedTextColor.RED : NamedTextColor.GRAY));
    }

    @Override
    public boolean isTreasure() {
        return this.shadow$isTreasureEnchantment();
    }

    @Intrinsic
    public boolean enchantment$isCurse() {
        return this.shadow$isCurse();
    }
}

