/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.entity.player;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.title.Title;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.network.play.server.SPlaySoundPacket;
import net.minecraft.network.play.server.SSendResourcePackPacket;
import net.minecraft.network.play.server.SStopSoundPacket;
import net.minecraft.network.play.server.STitlePacket;
import net.minecraft.network.play.server.SWorldBorderPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.server.ServerBossInfo;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Server;
import org.spongepowered.api.advancement.AdvancementProgress;
import org.spongepowered.api.advancement.AdvancementTree;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.type.SkinPart;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.entity.living.player.CooldownTracker;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.PlayerChatRouter;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.message.PlayerChatEvent;
import org.spongepowered.api.network.ServerPlayerConnection;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.world.WorldBorder;
import org.spongepowered.api.world.dimension.DimensionType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.network.play.server.SChangeBlockPacketAccessor;
import org.spongepowered.common.accessor.world.border.WorldBorderAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.advancements.PlayerAdvancementsBridge;
import org.spongepowered.common.bridge.entity.player.ServerPlayerEntityBridge;
import org.spongepowered.common.bridge.network.play.server.SSendResourcePackPacketBridge;
import org.spongepowered.common.bridge.scoreboard.ServerScoreboardBridge;
import org.spongepowered.common.effect.particle.SpongeParticleHelper;
import org.spongepowered.common.effect.record.SpongeRecordType;
import org.spongepowered.common.entity.player.tab.SpongeTabList;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.api.mcp.entity.player.PlayerEntityMixin_API;
import org.spongepowered.common.util.BookUtil;
import org.spongepowered.common.util.LocaleCache;
import org.spongepowered.common.util.NetworkUtil;
import org.spongepowered.common.world.dimension.SpongeDimensionType;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={ServerPlayerEntity.class})
@Implements(value={@Interface(iface=Player.class, prefix="player$")})
public abstract class ServerPlayerEntityMixin_API
extends PlayerEntityMixin_API
implements ServerPlayer {
    @Shadow
    @Final
    public MinecraftServer server;
    @Shadow
    @Final
    private PlayerAdvancements advancements;
    @Shadow
    private ChatVisibility chatVisibility;
    @Shadow
    private String language;
    @Shadow
    public ServerPlayNetHandler connection;
    @Shadow
    private boolean chatColours;
    private PlayerChatRouter api$chatRouter;
    private final TabList api$tabList = new SpongeTabList((ServerPlayerEntity)this);
    @Nullable
    private WorldBorder api$worldBorder;

    @Override
    public void spawnParticles(ParticleEffect particleEffect, Vector3d position, int radius) {
        if (this.impl$isFake) {
            return;
        }
        Preconditions.checkNotNull((Object)particleEffect, (Object)"The particle effect cannot be null!");
        Preconditions.checkNotNull((Object)position, (Object)"The position cannot be null");
        Preconditions.checkArgument((radius > 0 ? 1 : 0) != 0, (Object)"The radius has to be greater then zero!");
        List<IPacket<?>> packets = SpongeParticleHelper.toPackets(particleEffect, position);
        if (!packets.isEmpty() && position.sub(this.shadow$getPosX(), this.shadow$getPosY(), this.shadow$getPosZ()).lengthSquared() < (double)((long)radius * (long)radius)) {
            for (IPacket<?> packet : packets) {
                this.connection.sendPacket(packet);
            }
        }
    }

    @Override
    public User getUser() {
        return ((ServerPlayerEntityBridge)((Object)this)).bridge$getUser();
    }

    @Override
    public boolean isOnline() {
        return this.server.getPlayerList().getPlayerByUUID(this.entityUniqueID) == (ServerPlayerEntity)this;
    }

    @Override
    public GameProfile getProfile() {
        return ((ServerPlayerEntityBridge)((Object)this)).bridge$getUser().getProfile();
    }

    @Override
    public Locale getLocale() {
        return LocaleCache.getLocale(this.language);
    }

    @Override
    public int getViewDistance() {
        return ((ServerPlayerEntityBridge)((Object)this)).bridge$getViewDistance();
    }

    @Override
    public org.spongepowered.api.entity.living.player.chat.ChatVisibility getChatVisibility() {
        return (org.spongepowered.api.entity.living.player.chat.ChatVisibility)this.chatVisibility;
    }

    @Override
    public boolean isChatColorsEnabled() {
        return this.chatColours;
    }

    @Override
    public Set<SkinPart> getDisplayedSkinParts() {
        return ((ServerPlayerEntityBridge)((Object)this)).bridge$getSkinParts();
    }

    @Override
    public void sendEnvironment(DimensionType dimensionType) {
        ((ServerPlayerEntityBridge)((Object)this)).bridge$sendViewerEnvironment((SpongeDimensionType)dimensionType);
    }

    @Override
    public void spawnParticles(ParticleEffect particleEffect, Vector3d position) {
        if (this.impl$isFake) {
            return;
        }
        this.spawnParticles(particleEffect, position, Integer.MAX_VALUE);
    }

    @Override
    public ServerPlayerConnection getConnection() {
        return (ServerPlayerConnection)this.connection;
    }

    @Overwrite
    public String getPlayerIP() {
        return NetworkUtil.getHostString(this.connection.netManager.getRemoteAddress());
    }

    @Override
    public String getIdentifier() {
        return ((ServerPlayerEntityBridge)((Object)this)).bridge$getUser().getIdentifier();
    }

    @Override
    public void setScoreboard(Scoreboard scoreboard) {
        ((ServerScoreboardBridge)((Object)((ServerPlayerEntityBridge)((Object)this)).bridge$getScoreboard())).bridge$removePlayer((ServerPlayerEntity)this, true);
        ((ServerPlayerEntityBridge)((Object)this)).bridge$replaceScoreboard(scoreboard);
        ((ServerScoreboardBridge)((Object)((ServerPlayerEntityBridge)((Object)this)).bridge$getScoreboard())).bridge$addPlayer((ServerPlayerEntity)this, true);
    }

    @Override
    public Component getTeamRepresentation() {
        return SpongeAdventure.asAdventure(this.shadow$getName());
    }

    @Override
    public Scoreboard getScoreboard() {
        return ((ServerPlayerEntityBridge)((Object)this)).bridge$getScoreboard();
    }

    @Override
    public boolean kick() {
        return this.kick((Component)Component.translatable((String)"disconnect.disconnected"));
    }

    @Override
    public boolean kick(Component message) {
        return ((ServerPlayerEntityBridge)((Object)this)).bridge$kick(message);
    }

    @Override
    public void playMusicDisc(Vector3i position, MusicDisc recordType) {
        this.playRecord0(position, (MusicDisc)Preconditions.checkNotNull((Object)recordType, (Object)"recordType"));
    }

    @Override
    public void stopMusicDisc(Vector3i position) {
        this.playRecord0(position, null);
    }

    private void playRecord0(Vector3i position, @Nullable MusicDisc recordType) {
        this.connection.sendPacket((IPacket)SpongeRecordType.createPacket(position, recordType));
    }

    @Override
    public void sendResourcePack(ResourcePack pack) {
        SSendResourcePackPacket packet = new SSendResourcePackPacket();
        ((SSendResourcePackPacketBridge)packet).bridge$setSpongePack(pack);
        this.connection.sendPacket((IPacket)packet);
    }

    @Override
    public TabList getTabList() {
        return this.api$tabList;
    }

    @Override
    public boolean hasPlayedBefore() {
        Instant instant = ((SpongeServer)this.shadow$getServer()).getPlayerDataManager().getFirstJoined(this.getUniqueId()).get();
        Instant toTheMinute = instant.truncatedTo(ChronoUnit.MINUTES);
        Instant now = Instant.now().truncatedTo(ChronoUnit.MINUTES);
        Duration timeSinceFirstJoined = Duration.of(now.minusMillis(toTheMinute.toEpochMilli()).toEpochMilli(), ChronoUnit.MINUTES);
        return timeSinceFirstJoined.getSeconds() > 0L;
    }

    public void sendBlockChange(BlockPos pos, net.minecraft.block.BlockState state) {
        SChangeBlockPacket packet = new SChangeBlockPacket();
        SChangeBlockPacketAccessor accessor = (SChangeBlockPacketAccessor)packet;
        accessor.accessor$setPos(pos);
        accessor.accessor$setState(state);
        this.connection.sendPacket((IPacket)packet);
    }

    @Override
    public void sendBlockChange(int x, int y, int z, BlockState state) {
        Preconditions.checkNotNull((Object)state, (Object)"state");
        this.sendBlockChange(new BlockPos(x, y, z), (net.minecraft.block.BlockState)state);
    }

    @Override
    public void resetBlockChange(int x, int y, int z) {
        SChangeBlockPacket packet = new SChangeBlockPacket((IBlockReader)this.shadow$getEntityWorld(), new BlockPos(x, y, z));
        this.connection.sendPacket((IPacket)packet);
    }

    @Override
    public boolean respawn() {
        if (this.shadow$getHealth() > 0.0f) {
            return false;
        }
        this.connection.player = this.server.getPlayerList().recreatePlayerEntity((ServerPlayerEntity)this, this.dimension, false);
        return true;
    }

    @Override
    public PlayerChatRouter getChatRouter() {
        if (this.api$chatRouter == null) {
            this.api$chatRouter = (player, message) -> ((Server)this.server).sendMessage(player, (Component)Component.translatable((String)"chat.type.text", (ComponentLike[])new ComponentLike[]{SpongeAdventure.asAdventure(this.shadow$getDisplayName()), message}));
        }
        return this.api$chatRouter;
    }

    @Override
    public void setChatRouter(PlayerChatRouter router) {
        this.api$chatRouter = Objects.requireNonNull(router, "router");
    }

    @Override
    public PlayerChatEvent simulateChat(Component message, Cause cause) {
        Preconditions.checkNotNull((Object)message, (Object)"message");
        PlayerChatRouter originalRouter = this.getChatRouter();
        PlayerChatEvent event = SpongeEventFactory.createPlayerChatEvent(cause, originalRouter, Optional.of(originalRouter), message, message);
        if (!SpongeCommon.postEvent(event)) {
            event.getChatRouter().ifPresent(channel -> channel.chat(this, event.getMessage()));
        }
        return event;
    }

    @Override
    public Optional<WorldBorder> getWorldBorder() {
        return Optional.ofNullable(this.api$worldBorder);
    }

    @Override
    public CooldownTracker getCooldownTracker() {
        return (CooldownTracker)this.shadow$getCooldownTracker();
    }

    @Override
    public AdvancementProgress getProgress(org.spongepowered.api.advancement.Advancement advancement) {
        Preconditions.checkNotNull((Object)advancement, (Object)"advancement");
        return (AdvancementProgress)this.advancements.getProgress((Advancement)advancement);
    }

    @Override
    public Collection<AdvancementTree> getUnlockedAdvancementTrees() {
        return ((PlayerAdvancementsBridge)this.advancements).bridge$getAdvancementTrees();
    }

    @Override
    public void setWorldBorder(@Nullable WorldBorder border) {
        if (this.api$worldBorder == border) {
            return;
        }
        if (!SpongeCommon.postEvent(SpongeEventFactory.createChangeWorldBorderEventTargetPlayer(PhaseTracker.getCauseStackManager().getCurrentCause(), Optional.ofNullable(this.api$worldBorder), this, Optional.ofNullable(border)))) {
            if (this.api$worldBorder != null) {
                ((WorldBorderAccessor)((Object)this.api$worldBorder)).accessor$getListeners().remove(((ServerPlayerEntityBridge)((Object)this)).bridge$getWorldBorderListener());
            }
            this.api$worldBorder = border;
            if (this.api$worldBorder != null) {
                ((net.minecraft.world.border.WorldBorder)this.api$worldBorder).addListener((IBorderListener)((ServerPlayerEntityBridge)((Object)this)).bridge$getWorldBorderListener());
                this.connection.sendPacket((IPacket)new SWorldBorderPacket((net.minecraft.world.border.WorldBorder)this.api$worldBorder, SWorldBorderPacket.Action.INITIALIZE));
            } else {
                this.connection.sendPacket((IPacket)new SWorldBorderPacket(this.shadow$getEntityWorld().getWorldBorder(), SWorldBorderPacket.Action.INITIALIZE));
            }
        }
    }

    @Override
    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        Set<Value.Immutable<?>> values = super.api$getVanillaValues();
        values.add(this.foodLevel().asImmutable());
        values.add(this.exhaustion().asImmutable());
        values.add(this.saturation().asImmutable());
        values.add(this.gameMode().asImmutable());
        values.add(this.firstJoined().asImmutable());
        values.add(this.lastPlayed().asImmutable());
        values.add(this.sleepingIgnored().asImmutable());
        values.add(this.hasViewedCredits().asImmutable());
        this.spectatorTarget().map(Value::asImmutable).ifPresent(values::add);
        return values;
    }

    public void sendMessage(Identity identity, Component message, MessageType type) {
        if (this.impl$isFake) {
            return;
        }
        Objects.requireNonNull(message, "message");
        Objects.requireNonNull(type, "type");
        this.connection.sendPacket((IPacket)new SChatPacket(SpongeAdventure.asVanilla(message), SpongeAdventure.asVanilla(type)));
    }

    public void sendActionBar(Component message) {
        if (this.impl$isFake) {
            return;
        }
        Objects.requireNonNull(message, "message");
        this.connection.sendPacket((IPacket)new STitlePacket(STitlePacket.Type.ACTIONBAR, SpongeAdventure.asVanilla(message)));
    }

    public void showTitle(Title title) {
        if (this.impl$isFake) {
            return;
        }
        Objects.requireNonNull(title, "title");
        Title.Times times = title.times();
        if (times != null) {
            this.connection.sendPacket((IPacket)new STitlePacket(ServerPlayerEntityMixin_API.ticks(times.fadeIn()), ServerPlayerEntityMixin_API.ticks(times.stay()), ServerPlayerEntityMixin_API.ticks(times.fadeOut())));
        }
        this.connection.sendPacket((IPacket)new STitlePacket(STitlePacket.Type.SUBTITLE, SpongeAdventure.asVanilla(title.subtitle())));
        this.connection.sendPacket((IPacket)new STitlePacket(STitlePacket.Type.TITLE, SpongeAdventure.asVanilla(title.title())));
    }

    private static int ticks(Duration duration) {
        if (duration == null) {
            return -1;
        }
        return (int)(duration.toMillis() / 50L);
    }

    public void clearTitle() {
        if (this.impl$isFake) {
            return;
        }
        this.connection.sendPacket((IPacket)new STitlePacket(STitlePacket.Type.CLEAR, null));
    }

    public void resetTitle() {
        if (this.impl$isFake) {
            return;
        }
        this.connection.sendPacket((IPacket)new STitlePacket(STitlePacket.Type.RESET, null));
    }

    public void showBossBar(BossBar bar) {
        if (this.impl$isFake) {
            return;
        }
        Objects.requireNonNull(bar, "bar");
        ServerBossInfo vanilla = SpongeAdventure.asVanillaServer(bar);
        vanilla.addPlayer((ServerPlayerEntity)this);
    }

    public void hideBossBar(BossBar bar) {
        if (this.impl$isFake) {
            return;
        }
        Objects.requireNonNull(bar, "bar");
        ServerBossInfo vanilla = SpongeAdventure.asVanillaServer(bar);
        vanilla.removePlayer((ServerPlayerEntity)this);
    }

    public void playSound(Sound sound) {
        this.playSound(sound, this.shadow$getPosX(), this.shadow$getPosY(), this.shadow$getPosZ());
    }

    public void playSound(Sound sound, double x, double y, double z) {
        if (this.impl$isFake) {
            return;
        }
        Objects.requireNonNull(sound, "sound");
        Optional event = Registry.SOUND_EVENT.getValue(SpongeAdventure.asVanilla(sound.name()));
        if (event.isPresent()) {
            this.connection.sendPacket((IPacket)new SPlaySoundEffectPacket((SoundEvent)event.get(), SpongeAdventure.asVanilla(sound.source()), x, y, z, sound.volume(), sound.pitch()));
        } else {
            this.connection.sendPacket((IPacket)new SPlaySoundPacket(SpongeAdventure.asVanilla(sound.name()), SpongeAdventure.asVanilla(sound.source()), new Vec3d(x, y, z), sound.volume(), sound.pitch()));
        }
    }

    public void stopSound(SoundStop stop) {
        if (this.impl$isFake) {
            return;
        }
        Objects.requireNonNull(stop, "stop");
        this.connection.sendPacket((IPacket)new SStopSoundPacket(SpongeAdventure.asVanillaNullable(stop.sound()), SpongeAdventure.asVanillaNullable(stop.source())));
    }

    public void openBook(@NonNull Book book) {
        if (this.impl$isFake) {
            return;
        }
        Objects.requireNonNull(book, "book");
        BookUtil.fakeBookView(book, Collections.singletonList(this));
    }
}

