/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.SerializableDataHolder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.entity.attribute.type.AttributeType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.hooks.SpongeImplHooks;
import org.spongepowered.common.item.SpongeItemStackSnapshot;
import org.spongepowered.common.util.Constants;

@Mixin(value={net.minecraft.item.ItemStack.class})
@Implements(value={@Interface(iface=ItemStack.class, prefix="itemStack$")})
public abstract class ItemStackMixin_API
implements SerializableDataHolder.Mutable {
    @Shadow
    public abstract int shadow$getCount();

    @Shadow
    public abstract void shadow$setCount(int var1);

    @Shadow
    public abstract void shadow$setDamage(int var1);

    @Shadow
    public abstract void shadow$setTag(@Nullable CompoundNBT var1);

    @Shadow
    public abstract int shadow$getDamage();

    @Shadow
    public abstract int shadow$getMaxStackSize();

    @Shadow
    public abstract boolean shadow$hasTag();

    @Shadow
    public abstract boolean shadow$isEmpty();

    @Shadow
    public abstract CompoundNBT shadow$getTag();

    @Shadow
    public abstract net.minecraft.item.ItemStack shadow$copy();

    @Shadow
    public abstract Item shadow$getItem();

    @Shadow
    public abstract Multimap<String, AttributeModifier> shadow$getAttributeModifiers(EquipmentSlotType var1);

    @Shadow
    public abstract void shadow$addAttributeModifier(String var1, AttributeModifier var2, @Nullable EquipmentSlotType var3);

    public int itemStack$getQuantity() {
        return this.shadow$getCount();
    }

    public ItemType itemStack$getType() {
        return (ItemType)this.shadow$getItem();
    }

    public void itemStack$setQuantity(int quantity) throws IllegalArgumentException {
        this.shadow$setCount(quantity);
    }

    public int itemStack$getMaxStackQuantity() {
        return this.shadow$getMaxStackSize();
    }

    @Override
    public boolean validateRawData(DataView container) {
        Preconditions.checkNotNull((Object)container);
        return false;
    }

    @Override
    public void setRawData(DataView container) throws InvalidDataException {
        Preconditions.checkNotNull((Object)container);
        if (this.shadow$isEmpty()) {
            throw new IllegalArgumentException("Cannot set data on empty item stacks!");
        }
        if (!container.contains(Constants.Sponge.UNSAFE_NBT)) {
            throw new InvalidDataException("There's no NBT Data set in the provided container");
        }
        DataView nbtData = container.getView(Constants.Sponge.UNSAFE_NBT).get();
        try {
            int integer = container.getInt(Constants.ItemStack.DAMAGE_VALUE).orElse(this.shadow$getDamage());
            this.shadow$setDamage(integer);
            CompoundNBT stackCompound = NbtTranslator.getInstance().translate(nbtData);
            this.shadow$setTag(stackCompound);
        }
        catch (Exception e) {
            throw new InvalidDataException("Unable to set raw data or translate raw data for ItemStack setting", e);
        }
    }

    @Override
    public SerializableDataHolder.Mutable copy() {
        return this.itemStack$copy();
    }

    public ItemStack itemStack$copy() {
        return (ItemStack)this.shadow$copy();
    }

    public Collection<org.spongepowered.api.entity.attribute.AttributeModifier> itemStack$getAttributeModifiers(AttributeType attributeType, EquipmentType equipmentType) {
        Preconditions.checkNotNull((Object)attributeType, (Object)"Attribute type cannot be null");
        Preconditions.checkNotNull((Object)equipmentType, (Object)"Equipment type cannot be null");
        ImmutableList.Builder builder = ImmutableList.builder();
        return builder.build();
    }

    public void itemStack$addAttributeModifier(AttributeType attributeType, org.spongepowered.api.entity.attribute.AttributeModifier modifier, EquipmentType equipmentType) {
        Preconditions.checkNotNull((Object)attributeType, (Object)"Attribute type cannot be null");
        Preconditions.checkNotNull((Object)modifier, (Object)"Attribute modifier cannot be null");
        Preconditions.checkNotNull((Object)equipmentType, (Object)"Equipment type cannot be null");
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.getContentVersion()).set(Constants.ItemStack.TYPE, this.itemStack$getType().getKey().toString()).set(Constants.ItemStack.COUNT, this.itemStack$getQuantity()).set(Constants.ItemStack.DAMAGE_VALUE, this.shadow$getDamage());
        if (this.shadow$hasTag()) {
            CompoundNBT spongeCompound;
            CompoundNBT compound = this.shadow$getTag().copy();
            if (compound.contains("SpongeData") && (spongeCompound = compound.getCompound("SpongeData")).contains("CustomManipulators")) {
                spongeCompound.remove("CustomManipulators");
            }
            Constants.NBT.filterSpongeCustomData(compound);
            if (!compound.isEmpty()) {
                DataContainer unsafeNbt = NbtTranslator.getInstance().translateFrom(compound);
                container.set(Constants.Sponge.UNSAFE_NBT, unsafeNbt);
            }
        }
        try {
            SpongeImplHooks.writeItemStackCapabilitiesToDataView(container, (net.minecraft.item.ItemStack)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return container;
    }

    public ItemStackSnapshot itemStack$createSnapshot() {
        return new SpongeItemStackSnapshot((ItemStack)((Object)this));
    }

    public boolean itemStack$equalTo(ItemStack that) {
        return net.minecraft.item.ItemStack.areItemStacksEqual((net.minecraft.item.ItemStack)((net.minecraft.item.ItemStack)this), (net.minecraft.item.ItemStack)((net.minecraft.item.ItemStack)that));
    }

    @Intrinsic
    public boolean itemStack$isEmpty() {
        return this.shadow$isEmpty();
    }
}

