/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.tileentity;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.BlockEntityType;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.SpongeLocatableBlockBuilder;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={TileEntity.class})
public abstract class TileEntityMixin_API
implements BlockEntity {
    @Shadow
    @Final
    private TileEntityType<?> type;
    @Shadow
    protected World world;
    @Shadow
    protected boolean removed;
    @Nullable
    private LocatableBlock api$LocatableBlock;

    @Shadow
    public abstract BlockPos shadow$getPos();

    @Shadow
    public abstract void shadow$markDirty();

    @Shadow
    public abstract CompoundNBT shadow$write(CompoundNBT var1);

    public ServerLocation getLocation() {
        return ServerLocation.of((ServerWorld)this.world, VecHelper.toVector3i(this.shadow$getPos()));
    }

    @Override
    public ServerLocation getServerLocation() {
        if (this.world == null) {
            throw new RuntimeException("The TileEntity has not been spawned in a world yet!");
        }
        if (this.world.isRemote) {
            throw new RuntimeException("You should not attempt to make a server-side location on the client!");
        }
        return ServerLocation.of((ServerWorld)this.world, VecHelper.toVector3d(this.shadow$getPos()));
    }

    @Override
    public org.spongepowered.api.world.World<?> getWorld() {
        return (org.spongepowered.api.world.World)this.world;
    }

    @Override
    public Vector3i getBlockPosition() {
        return VecHelper.toVector3i(this.shadow$getPos());
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.getContentVersion()).set(Queries.WORLD_KEY, ((ServerWorld)this.world).getKey()).set(Queries.POSITION_X, this.shadow$getPos().getX()).set(Queries.POSITION_Y, this.shadow$getPos().getY()).set(Queries.POSITION_Z, this.shadow$getPos().getZ()).set(Constants.TileEntity.TILE_TYPE, ((BlockEntityType)this.type).getKey());
        CompoundNBT compound = new CompoundNBT();
        this.shadow$write(compound);
        Constants.NBT.filterSpongeCustomData(compound);
        container.set(Constants.Sponge.UNSAFE_NBT, NbtTranslator.getInstance().translateFrom(compound));
        return container;
    }

    @Override
    public boolean validateRawData(DataView container) {
        return container.contains(Queries.WORLD_KEY) && container.contains(Queries.POSITION_X) && container.contains(Queries.POSITION_Y) && container.contains(Queries.POSITION_Z) && container.contains(Constants.TileEntity.TILE_TYPE) && container.contains(Constants.Sponge.UNSAFE_NBT);
    }

    @Override
    public boolean isValid() {
        return !this.removed;
    }

    @Override
    public void setValid(boolean valid) {
        this.removed = valid;
    }

    @Override
    public final BlockEntityType getType() {
        return (BlockEntityType)this.type;
    }

    @Override
    public BlockState getBlock() {
        return (BlockState)this.world.getBlockState(this.shadow$getPos());
    }

    @Override
    public LocatableBlock getLocatableBlock() {
        if (this.api$LocatableBlock == null) {
            BlockState blockState = this.getBlock();
            this.api$LocatableBlock = new SpongeLocatableBlockBuilder().world((ServerWorld)this.world).position(this.shadow$getPos().getX(), this.shadow$getPos().getY(), this.shadow$getPos().getZ()).state(blockState).build();
        }
        return this.api$LocatableBlock;
    }

    @Override
    public Set<Value.Immutable<?>> getValues() {
        return this.api$getVanillaValues();
    }

    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        return new HashSet();
    }
}

