/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.kyori.adventure.sound.Sound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SPlaySoundPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.HeightTypes;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.network.play.server.SChangeBlockPacketAccessor;
import org.spongepowered.common.accessor.world.server.ChunkManagerAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.effect.particle.SpongeParticleHelper;
import org.spongepowered.common.effect.record.SpongeRecordType;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={net.minecraft.world.World.class})
public abstract class WorldMixin_API<W extends World<W>>
implements World<W>,
AutoCloseable {
    @Shadow
    @Final
    public Random rand;
    @Shadow
    @Final
    protected WorldInfo worldInfo;
    @Shadow
    @Final
    public List<TileEntity> loadedTileEntityList;
    private Context impl$context;

    @Shadow
    public abstract @Nullable MinecraftServer shadow$getServer();

    @Shadow
    public abstract net.minecraft.world.chunk.Chunk shadow$getChunkAt(BlockPos var1);

    @Shadow
    public abstract IChunk shadow$getChunk(int var1, int var2, ChunkStatus var3, boolean var4);

    @Shadow
    public abstract boolean shadow$setBlockState(BlockPos var1, net.minecraft.block.BlockState var2, int var3);

    @Shadow
    public abstract boolean shadow$removeBlock(BlockPos var1, boolean var2);

    @Shadow
    public abstract int shadow$getHeight(Heightmap.Type var1, int var2, int var3);

    @Shadow
    public abstract net.minecraft.block.BlockState shadow$getBlockState(BlockPos var1);

    @Shadow
    public abstract void shadow$playSound(@javax.annotation.Nullable PlayerEntity var1, double var2, double var4, double var6, SoundEvent var8, SoundCategory var9, float var10, float var11);

    @Shadow
    public abstract @Nullable TileEntity shadow$getTileEntity(BlockPos var1);

    @Shadow
    public abstract List<Entity> shadow$getEntitiesInAABBexcluding(@Nullable Entity var1, AxisAlignedBB var2, @Nullable Predicate<? super Entity> var3);

    @Shadow
    public abstract <T extends Entity> List<T> shadow$getEntitiesWithinAABB(Class<? extends T> var1, AxisAlignedBB var2, @Nullable Predicate<? super T> var3);

    @Shadow
    public abstract int shadow$getSeaLevel();

    @Shadow
    public abstract long shadow$getSeed();

    @Shadow
    public abstract AbstractChunkProvider shadow$getChunkProvider();

    @Shadow
    public abstract WorldInfo shadow$getWorldInfo();

    @Shadow
    public abstract boolean shadow$isThundering();

    @Shadow
    public abstract boolean shadow$isRaining();

    @Shadow
    public abstract DifficultyInstance shadow$getDifficultyForLocation(BlockPos var1);

    @Shadow
    public abstract int shadow$getSkylightSubtracted();

    @Shadow
    public abstract WorldBorder shadow$getWorldBorder();

    @Shadow
    public abstract Dimension shadow$getDimension();

    @Shadow
    public abstract Random shadow$getRandom();

    @Shadow
    public abstract boolean shadow$hasBlockState(BlockPos var1, Predicate<net.minecraft.block.BlockState> var2);

    @Shadow
    public abstract void shadow$setTileEntity(BlockPos var1, @javax.annotation.Nullable TileEntity var2);

    @Shadow
    public abstract void removeTileEntity(BlockPos var1);

    @Override
    public Optional<? extends Player> getClosestPlayer(int x, int y, int z, double distance, Predicate<? super Player> predicate) {
        PlayerEntity player = ((net.minecraft.world.World)this).getClosestPlayer((double)x, (double)y, (double)z, distance, predicate);
        return Optional.ofNullable((Player)player);
    }

    @Override
    public BlockSnapshot createSnapshot(int x, int y, int z) {
        if (!this.containsBlock(x, y, z)) {
            return BlockSnapshot.empty();
        }
        if (!this.isChunkLoaded(x, y, z, false)) {
            return BlockSnapshot.empty();
        }
        BlockPos pos = new BlockPos(x, y, z);
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled();
        builder.world((ServerWorld)this).position(new Vector3i(x, y, z));
        net.minecraft.world.chunk.Chunk chunk = this.shadow$getChunkAt(pos);
        net.minecraft.block.BlockState state = chunk.getBlockState(pos);
        builder.blockState(state);
        TileEntity tile = chunk.getTileEntity(pos, Chunk.CreateEntityType.CHECK);
        if (tile != null) {
            TrackingUtil.addTileEntityToBuilder(tile, builder);
        }
        ((ChunkBridge)chunk).bridge$getBlockCreatorUUID(pos).ifPresent(builder::creator);
        ((ChunkBridge)chunk).bridge$getBlockNotifierUUID(pos).ifPresent(builder::notifier);
        builder.flag(BlockChangeFlags.NONE);
        return builder.build();
    }

    @Override
    public boolean restoreSnapshot(BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        return snapshot.restore(force, flag);
    }

    @Override
    public boolean restoreSnapshot(int x, int y, int z, BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        return ((BlockSnapshot)snapshot.withLocation(this.getLocation(x, y, z))).restore(force, flag);
    }

    @Override
    public Chunk getChunk(int cx, int cy, int cz) {
        return (Chunk)((net.minecraft.world.World)this).getChunk(cx >> 4, cz >> 4, ChunkStatus.EMPTY, true);
    }

    @Override
    public Optional<Chunk> loadChunk(int cx, int cy, int cz, boolean shouldGenerate) {
        if (!SpongeChunkLayout.instance.isValidChunk(cx, cy, cz)) {
            return Optional.empty();
        }
        AbstractChunkProvider chunkProvider = this.shadow$getChunkProvider();
        if (!shouldGenerate) {
            return Optional.ofNullable((Chunk)chunkProvider.getChunk(cx, cz, ChunkStatus.EMPTY, true));
        }
        return Optional.ofNullable((Chunk)chunkProvider.getChunk(cx, cz, ChunkStatus.FULL, true));
    }

    @Override
    public Iterable<Chunk> getLoadedChunks() {
        AbstractChunkProvider chunkProvider = this.shadow$getChunkProvider();
        if (chunkProvider instanceof ServerChunkProvider) {
            ChunkManagerAccessor chunkManager = (ChunkManagerAccessor)((ServerChunkProvider)chunkProvider).chunkManager;
            ArrayList<Chunk> chunks = new ArrayList<Chunk>();
            chunkManager.accessor$getLoadedChunksIterable().forEach(holder -> chunks.add((Chunk)holder.getChunkIfComplete()));
            return chunks;
        }
        return Collections.emptyList();
    }

    @Override
    public int getHighestYAt(int x, int z) {
        return this.getHeight(HeightTypes.WORLD_SURFACE.get(), x, z);
    }

    @Override
    public Vector3i getBlockMin() {
        return Constants.World.BLOCK_MIN;
    }

    @Override
    public Vector3i getBlockMax() {
        return Constants.World.BIOME_MAX;
    }

    @Override
    public Vector3i getBlockSize() {
        return Constants.World.BLOCK_SIZE;
    }

    @Override
    public Context getContext() {
        if (this.impl$context == null) {
            WorldInfo worldInfo = this.shadow$getWorldInfo();
            if (worldInfo == null) {
                worldInfo = new WorldInfo(new WorldSettings(0L, GameType.NOT_SET, false, false, WorldType.DEFAULT), "sponge$dummy_World");
            }
            this.impl$context = new Context("world", worldInfo.getWorldName());
        }
        return this.impl$context;
    }

    @Override
    public void spawnParticles(ParticleEffect particleEffect, Vector3d position, int radius) {
        Preconditions.checkNotNull((Object)particleEffect, (Object)"The particle effect cannot be null!");
        Preconditions.checkNotNull((Object)position, (Object)"The position cannot be null");
        Preconditions.checkArgument((radius > 0 ? 1 : 0) != 0, (Object)"The radius has to be greater then zero!");
        SpongeParticleHelper.sendPackets(particleEffect, position, radius, this.shadow$getDimension().getType(), this.shadow$getServer().getPlayerList());
    }

    private void api$playRecord(Vector3i position, @javax.annotation.Nullable MusicDisc recordType) {
        this.shadow$getServer().getPlayerList().sendPacketToAllPlayersInDimension((IPacket)SpongeRecordType.createPacket(position, recordType), this.shadow$getDimension().getType());
    }

    @Override
    public void playMusicDisc(Vector3i position, MusicDisc musicDiscType) {
        this.api$playRecord(position, (MusicDisc)Preconditions.checkNotNull((Object)musicDiscType, (Object)"recordType"));
    }

    @Override
    public void playMusicDisc(Vector3i position, Supplier<? extends MusicDisc> musicDiscType) {
        this.playMusicDisc(position, musicDiscType.get());
    }

    @Override
    public void stopMusicDisc(Vector3i position) {
        this.api$playRecord(position, null);
    }

    @Override
    public void sendBlockChange(int x, int y, int z, BlockState state) {
        Preconditions.checkNotNull((Object)state, (Object)"state");
        SChangeBlockPacket packet = new SChangeBlockPacket();
        ((SChangeBlockPacketAccessor)packet).accessor$setPos(new BlockPos(x, y, z));
        ((SChangeBlockPacketAccessor)packet).accessor$setState((net.minecraft.block.BlockState)state);
        ((net.minecraft.world.World)this).getPlayers().stream().filter(ServerPlayerEntity.class::isInstance).map(ServerPlayerEntity.class::cast).forEach(p -> p.connection.sendPacket((IPacket)packet));
    }

    @Override
    public void resetBlockChange(int x, int y, int z) {
        SChangeBlockPacket packet = new SChangeBlockPacket((IBlockReader)((IWorldReader)this), new BlockPos(x, y, z));
        ((net.minecraft.world.World)this).getPlayers().stream().filter(ServerPlayerEntity.class::isInstance).map(ServerPlayerEntity.class::cast).forEach(p -> p.connection.sendPacket((IPacket)packet));
    }

    public void playSound(Sound sound, double x, double y, double z) {
        ResourceLocation soundKey = SpongeAdventure.asVanilla(sound.name());
        Optional event = Registry.SOUND_EVENT.getValue(soundKey);
        SoundCategory soundCategory = SpongeAdventure.asVanilla(sound.source());
        if (event.isPresent()) {
            this.shadow$playSound(null, x, y, z, (SoundEvent)event.get(), soundCategory, sound.volume(), sound.pitch());
        } else {
            float volume = sound.volume();
            double radius = volume > 1.0f ? (double)(16.0f * volume) : 16.0;
            SPlaySoundPacket packet = new SPlaySoundPacket(soundKey, soundCategory, new Vec3d(x, y, z), volume, sound.pitch());
            this.shadow$getServer().getPlayerList().sendToAllNearExcept(null, x, y, z, radius, this.shadow$getDimension().getType(), (IPacket)packet);
        }
    }

    @Override
    public Collection<? extends BlockEntity> getBlockEntities() {
        return this.loadedTileEntityList;
    }

    @Override
    public boolean allowsPlayerRespawns() {
        return this.shadow$getDimension().canRespawnHere();
    }

    @Override
    public boolean doesWaterEvaporate() {
        return this.shadow$getDimension().doesWaterVaporize();
    }

    @Override
    public boolean hasSkylight() {
        return this.shadow$getDimension().hasSkyLight();
    }

    @Override
    public boolean isCaveWorld() {
        return this.shadow$getDimension().isNether();
    }

    @Override
    public boolean isSurfaceWorld() {
        return this.shadow$getDimension().isSurfaceWorld();
    }

    @Override
    public void addBlockEntity(int x, int y, int z, BlockEntity blockEntity) {
        Objects.requireNonNull(blockEntity, "BlockEntity cannot be null!");
        TileEntity tileEntity = (TileEntity)blockEntity;
        this.shadow$setTileEntity(new BlockPos(x, y, z), tileEntity);
    }
}

