/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.FallingBlock;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={net.minecraft.block.FallingBlock.class})
public abstract class FallingBlockMixin {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Redirect(method={"tick(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/BlockPos;getY()I"))
    public int impl$checkFallable(BlockPos pos, BlockState state, net.minecraft.world.server.ServerWorld world, BlockPos samePos, Random random, CallbackInfo ci) {
        if (pos.getY() < 0) {
            return pos.getY();
        }
        EntityType<FallingBlock> fallingBlock = EntityTypes.FALLING_BLOCK.get();
        @NonNull World spongeWorld = (World)world;
        BlockSnapshot snapshot = spongeWorld.createSnapshot(pos.getX(), pos.getY(), pos.getZ());
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(snapshot);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.FALLING_BLOCK);
            ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(frame.getCurrentCause(), ServerLocation.of((ServerWorld)world, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5), new Vector3d(0.0f, 0.0f, 0.0f), fallingBlock);
            if (SpongeCommon.postEvent(event)) {
                int n = -1;
                return n;
            }
            int n = pos.getY();
            return n;
        }
    }
}

