/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.client;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.net.Proxy;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.client.GameConfiguration;
import net.minecraft.client.Minecraft;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.listener.ChainedChunkStatusListener;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.chunk.listener.TrackingChunkStatusListener;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.MinecraftServerAccessor;
import org.spongepowered.common.bridge.client.MinecraftBridge;
import org.spongepowered.common.client.SpongeClient;
import org.spongepowered.common.entity.player.ClientType;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin
implements MinecraftBridge,
SpongeClient {
    @Shadow
    private Thread thread;
    @Shadow
    @Nullable
    private IntegratedServer integratedServer;
    @Shadow
    @Final
    private AtomicReference<TrackingChunkStatusListener> refChunkStatusListener;
    @Shadow
    @Final
    private Queue<Runnable> queueChunkTracking;
    private IntegratedServer impl$temporaryIntegratedServer;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void impl$setClientOnGame(GameConfiguration gameConfig, CallbackInfo ci) {
        SpongeCommon.getGame().setClient(this);
    }

    @Inject(method={"run"}, at={@At(value="HEAD")})
    private void impl$setThreadOnClientPhaseTracker(CallbackInfo ci) {
        try {
            PhaseTracker.CLIENT.setThread(this.thread);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not initialize the client PhaseTracker!");
        }
    }

    @Inject(method={"runGameLoop"}, at={@At(value="TAIL")})
    private void impl$tickClientScheduler(boolean renderWorldIn, CallbackInfo ci) {
        this.getScheduler().tick();
    }

    @Redirect(method={"launchIntegratedServer"}, at=@At(value="NEW", target="com/mojang/authlib/yggdrasil/YggdrasilAuthenticationService", remap=false))
    private YggdrasilAuthenticationService impl$createServerBeforeCache(Proxy proxy, String clientToken, String folderName, String worldName, WorldSettings worldSettingsIn) {
        YggdrasilAuthenticationService service = new YggdrasilAuthenticationService(proxy, clientToken);
        this.integratedServer = new IntegratedServer((Minecraft)this, folderName, worldName, worldSettingsIn, service, service.createMinecraftSessionService(), service.createProfileRepository(), null, p_213246_1_ -> {
            TrackingChunkStatusListener trackingchunkstatuslistener = new TrackingChunkStatusListener(p_213246_1_ + 0);
            trackingchunkstatuslistener.startTracking();
            this.refChunkStatusListener.set(trackingchunkstatuslistener);
            return new ChainedChunkStatusListener((IChunkStatusListener)trackingchunkstatuslistener, this.queueChunkTracking::add);
        });
        return service;
    }

    @Redirect(method={"launchIntegratedServer"}, at=@At(value="INVOKE", target="Lcom/mojang/authlib/yggdrasil/YggdrasilAuthenticationService;createMinecraftSessionService()Lcom/mojang/authlib/minecraft/MinecraftSessionService;", remap=false))
    private MinecraftSessionService impl$useServerMinecraftSessionService(YggdrasilAuthenticationService yggdrasilAuthenticationService) {
        return ((MinecraftServerAccessor)this.integratedServer).accessor$getSessionService();
    }

    @Redirect(method={"launchIntegratedServer"}, at=@At(value="INVOKE", target="Lcom/mojang/authlib/yggdrasil/YggdrasilAuthenticationService;createProfileRepository()Lcom/mojang/authlib/GameProfileRepository;", remap=false))
    private GameProfileRepository impl$useServerGameProfileRepository(YggdrasilAuthenticationService yggdrasilAuthenticationService) {
        return ((MinecraftServerAccessor)this.integratedServer).accessor$getProfileRepo();
    }

    @Redirect(method={"launchIntegratedServer"}, at=@At(value="NEW", target="net/minecraft/server/integrated/IntegratedServer"))
    private IntegratedServer impl$setCacheOnServer(Minecraft mcIn, String worldName, String p_i50895_3_, WorldSettings worldSettingsIn, YggdrasilAuthenticationService p_i50895_5_, MinecraftSessionService p_i50895_6_, GameProfileRepository p_i50895_7_, PlayerProfileCache p_i50895_8_, IChunkStatusListenerFactory p_i50895_9_) {
        ((MinecraftServerAccessor)this.integratedServer).accessor$setProfileCache(p_i50895_8_);
        return this.integratedServer;
    }

    @Override
    public IntegratedServer bridge$getTemporaryIntegratedServer() {
        return this.impl$temporaryIntegratedServer;
    }

    @Override
    public void bridge$setTemporaryIntegratedServer(IntegratedServer server) {
        this.impl$temporaryIntegratedServer = server;
    }

    @Override
    public ClientType bridge$getClientType() {
        return ClientType.SPONGE_VANILLA;
    }
}

