/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.command;

import com.mojang.brigadier.ResultConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKey;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.accessor.entity.EntityAccessor;
import org.spongepowered.common.bridge.command.CommandSourceBridge;
import org.spongepowered.common.bridge.command.CommandSourceProviderBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.service.server.permission.SpongePermissions;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={CommandSource.class})
public abstract class CommandSourceMixin
implements CommandSourceBridge {
    private static final String PROTECTED_CTOR = "(Lnet/minecraft/command/ICommandSource;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec2f;Lnet/minecraft/world/server/ServerWorld;ILjava/lang/String;Lnet/minecraft/util/text/ITextComponent;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/entity/Entity;ZLcom/mojang/brigadier/ResultConsumer;Lnet/minecraft/command/arguments/EntityAnchorArgument$Type;)";
    private static final String PROTECTED_CTOR_METHOD = "<init>(Lnet/minecraft/command/ICommandSource;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec2f;Lnet/minecraft/world/server/ServerWorld;ILjava/lang/String;Lnet/minecraft/util/text/ITextComponent;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/entity/Entity;ZLcom/mojang/brigadier/ResultConsumer;Lnet/minecraft/command/arguments/EntityAnchorArgument$Type;)V";
    @Shadow
    @Final
    private ICommandSource source;
    @Shadow
    @Final
    @Mutable
    private Vec3d pos;
    @Shadow
    @Final
    @Mutable
    private Vec2f rotation;
    @Shadow
    @Final
    @Mutable
    private net.minecraft.world.server.ServerWorld world;
    @Shadow
    @Final
    @Mutable
    private int permissionLevel;
    private Cause impl$cause;
    @Nullable
    private Supplier<String> impl$potentialPermissionNode = null;

    @Inject(method={"<init>(Lnet/minecraft/command/ICommandSource;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec2f;Lnet/minecraft/world/server/ServerWorld;ILjava/lang/String;Lnet/minecraft/util/text/ITextComponent;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/entity/Entity;ZLcom/mojang/brigadier/ResultConsumer;Lnet/minecraft/command/arguments/EntityAnchorArgument$Type;)V"}, at={@At(value="RETURN")})
    private void impl$setCauseOnConstruction(ICommandSource p_i49553_1_, Vec3d p_i49553_2_, Vec2f p_i49553_3_, net.minecraft.world.server.ServerWorld p_i49553_4_, int p_i49553_5_, String p_i49553_6_, ITextComponent p_i49553_7_, MinecraftServer p_i49553_8_, @Nullable Entity p_i49553_9_, boolean p_i49553_10_, ResultConsumer<CommandSource> p_i49553_11_, EntityAnchorArgument.Type p_i49553_12_, CallbackInfo ci) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(p_i49553_1_);
            if (p_i49553_1_ instanceof CommandSourceProviderBridge) {
                ((CommandSourceProviderBridge)p_i49553_1_).bridge$addToCauseStack(frame);
            }
            this.impl$cause = frame.getCurrentCause();
            EventContext context = this.impl$cause.getContext();
            context.get(EventContextKeys.LOCATION).ifPresent(x -> {
                this.pos = VecHelper.toVec3d(x.getPosition());
                this.world = (net.minecraft.world.server.ServerWorld)x.getWorld();
            });
            context.get(EventContextKeys.ROTATION).ifPresent(x -> {
                this.rotation = new Vec2f((float)x.getX(), (float)x.getY());
            });
            context.get(EventContextKeys.SUBJECT).ifPresent(x -> {
                if (x instanceof EntityAccessor) {
                    this.permissionLevel = ((EntityAccessor)((Object)x)).accessor$getPermissionLevel();
                } else if (x instanceof MinecraftServer && !((MinecraftServer)x).isSinglePlayer()) {
                    this.permissionLevel = 4;
                }
            });
        }
    }

    @Inject(method={"withEntity", "withPos", "withRotation(Lnet/minecraft/util/math/Vec2f;)Lnet/minecraft/command/CommandSource;", "withResultConsumer(Lcom/mojang/brigadier/ResultConsumer;)Lnet/minecraft/command/CommandSource;", "withFeedbackDisabled", "withPermissionLevel", "withMinPermissionLevel", "withEntityAnchorType", "withWorld"}, at={@At(value="RETURN")})
    private void impl$copyPermissionOnCopy(CallbackInfoReturnable<CommandSource> cir) {
        if (cir.getReturnValue() != this) {
            CommandSourceBridge commandSourceBridge = (CommandSourceBridge)cir.getReturnValue();
            commandSourceBridge.bridge$setPotentialPermissionNode(this.impl$potentialPermissionNode);
            commandSourceBridge.bridge$setCause(this.impl$cause);
        }
    }

    @Inject(method={"withWorld"}, at={@At(value="RETURN")})
    private void impl$updateCauseOnWithWorld(net.minecraft.world.server.ServerWorld serverWorld, CallbackInfoReturnable<CommandSource> cir) {
        if (cir.getReturnValue() != this) {
            ServerLocation location = this.impl$cause.getContext().get(EventContextKeys.LOCATION).map(x -> ServerLocation.of((ServerWorld)serverWorld, x.getPosition())).orElseGet(() -> ServerLocation.of((ServerWorld)serverWorld, VecHelper.toVector3d(((CommandSource)cir.getReturnValue()).getPos())));
            ((CommandSourceBridge)cir.getReturnValue()).bridge$setCause(this.impl$applyToCause(EventContextKeys.LOCATION.get(), location));
        }
    }

    @Inject(method={"withPos"}, at={@At(value="RETURN")})
    private void impl$updateCauseOnWithPosition(Vec3d pos, CallbackInfoReturnable<CommandSource> cir) {
        if (cir.getReturnValue() != this) {
            Vector3d position = VecHelper.toVector3d(pos);
            ServerLocation location = this.impl$cause.getContext().get(EventContextKeys.LOCATION).map(x -> ServerLocation.of((ServerWorld)x.getWorld(), position)).orElseGet(() -> ServerLocation.of((ServerWorld)((CommandSource)cir.getReturnValue()).getWorld(), position));
            ((CommandSourceBridge)cir.getReturnValue()).bridge$setCause(this.impl$applyToCause(EventContextKeys.LOCATION.get(), location));
        }
    }

    @Inject(method={"withRotation(Lnet/minecraft/util/math/Vec2f;)Lnet/minecraft/command/CommandSource;"}, at={@At(value="RETURN")})
    private void impl$updateCauseOnWithRotation(Vec2f rotation, CallbackInfoReturnable<CommandSource> cir) {
        if (cir.getReturnValue() != this) {
            Vector3d rot = new Vector3d(rotation.x, rotation.y, 0.0f);
            ((CommandSourceBridge)cir.getReturnValue()).bridge$setCause(this.impl$applyToCause(EventContextKeys.ROTATION.get(), rot));
        }
    }

    @Inject(method={"hasPermissionLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$checkPermission(int opLevel, CallbackInfoReturnable<Boolean> cir) {
        if (this.impl$potentialPermissionNode != null) {
            String perm = this.impl$potentialPermissionNode.get();
            SpongePermissions.registerPermission(perm, opLevel);
            cir.setReturnValue((Object)((CommandCause)((Object)this)).hasPermission(perm));
        }
    }

    @Override
    public void bridge$setPotentialPermissionNode(@Nullable @org.checkerframework.checker.nullness.qual.Nullable Supplier<String> permission) {
        this.impl$potentialPermissionNode = permission;
    }

    @Override
    public void bridge$setCause(Cause cause) {
        this.impl$cause = cause;
    }

    @Override
    public Cause bridge$getCause() {
        return this.impl$cause;
    }

    @Override
    public ICommandSource bridge$getICommandSource() {
        return this.source;
    }

    @Override
    public CommandCause bridge$asCommandCause() {
        return (CommandCause)((Object)this);
    }

    private <T> Cause impl$applyToCause(EventContextKey<T> key, T value) {
        EventContext.Builder builder = EventContext.builder().from(this.impl$cause.getContext());
        builder.add(key, value);
        return Cause.builder().from(this.impl$cause).build(builder.build());
    }
}

