/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.ai.goal.GoalExecutorTypes;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.event.entity.UnleashEntityEvent;
import org.spongepowered.api.event.entity.ai.SetAITargetEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.entity.GrieferBridge;
import org.spongepowered.common.bridge.entity.ai.GoalSelectorBridge;
import org.spongepowered.common.bridge.entity.player.PlayerEntityBridge;
import org.spongepowered.common.bridge.world.storage.WorldInfoBridge;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.cause.entity.damage.DamageEventHandler;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.entity.LivingEntityMixin;

@Mixin(value={MobEntity.class})
public abstract class MobEntityMixin
extends LivingEntityMixin {
    @Shadow
    @Final
    protected GoalSelector goalSelector;
    @Shadow
    @Final
    protected GoalSelector targetSelector;
    @Shadow
    @Nullable
    private LivingEntity attackTarget;

    @Shadow
    @Nullable
    public abstract net.minecraft.entity.Entity shadow$getLeashHolder();

    @Shadow
    protected abstract void shadow$registerGoals();

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/MobEntity;registerGoals()V"))
    private void impl$registerGoals(MobEntity this$0) {
        this.initSpongeAI();
        this.shadow$registerGoals();
    }

    private void initSpongeAI() {
        if (!((GoalSelectorBridge)this.goalSelector).bridge$initialized()) {
            ((GoalSelectorBridge)this.goalSelector).bridge$setOwner((MobEntity)this);
            ((GoalSelectorBridge)this.goalSelector).bridge$setType(GoalExecutorTypes.NORMAL.get());
            ((GoalSelectorBridge)this.goalSelector).bridge$setInitialized(true);
        }
        if (!((GoalSelectorBridge)this.targetSelector).bridge$initialized()) {
            ((GoalSelectorBridge)this.targetSelector).bridge$setOwner((MobEntity)this);
            ((GoalSelectorBridge)this.targetSelector).bridge$setType(GoalExecutorTypes.TARGET.get());
            ((GoalSelectorBridge)this.targetSelector).bridge$setInitialized(true);
        }
    }

    @Inject(method={"clearLeashed"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/MobEntity;leashHolder:Lnet/minecraft/entity/Entity;", opcode=181)}, cancellable=true)
    private void impl$ThrowUnleashEvent(boolean sendPacket, boolean dropLead, CallbackInfo ci) {
        net.minecraft.entity.Entity entity = this.shadow$getLeashHolder();
        if (!this.world.isRemote) {
            CauseStackManager csm = PhaseTracker.getCauseStackManager();
            if (entity == null) {
                csm.pushCause(this);
            } else {
                csm.pushCause(entity);
            }
            UnleashEntityEvent event = SpongeEventFactory.createUnleashEntityEvent(csm.getCurrentCause(), (Living)((Object)this));
            SpongeCommon.postEvent(event);
            csm.popCause();
            if (event.isCancelled()) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"setAttackTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetAttackTarget(@Nullable LivingEntity entitylivingbaseIn, CallbackInfo ci) {
        if (this.world.isRemote || entitylivingbaseIn == null) {
            return;
        }
        if (EntityUtil.isUntargetable((net.minecraft.entity.Entity)this, (net.minecraft.entity.Entity)entitylivingbaseIn)) {
            this.attackTarget = null;
            ci.cancel();
            return;
        }
        if (ShouldFire.SET_A_I_TARGET_EVENT) {
            SetAITargetEvent event = SpongeCommonEventFactory.callSetAttackTargetEvent((Entity)entitylivingbaseIn, (Agent)((Object)this));
            if (event.isCancelled()) {
                ci.cancel();
            } else {
                this.attackTarget = event.getTarget().orElse(null);
            }
        }
    }

    @Nullable
    @Overwrite
    public LivingEntity getAttackTarget() {
        if (this.attackTarget != null && EntityUtil.isUntargetable((net.minecraft.entity.Entity)this, (net.minecraft.entity.Entity)this.attackTarget)) {
            this.attackTarget = null;
        }
        return this.attackTarget;
    }

    @Redirect(method={"livingTick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/MobEntity;canPickUpLoot()Z"))
    private boolean impl$onCanGrief(MobEntity thisEntity) {
        return thisEntity.canPickUpLoot() && ((GrieferBridge)((Object)this)).bridge$canGrief();
    }

    @Overwrite
    public boolean attackEntityAsMob(net.minecraft.entity.Entity targetEntity) {
        double originalBaseDamage = this.shadow$getAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).getValue();
        ArrayList<DamageFunction> originalFunctions = new ArrayList<DamageFunction>();
        float knockbackModifier = (float)this.shadow$getAttribute(SharedMonsterAttributes.ATTACK_KNOCKBACK).getValue();
        if (targetEntity instanceof LivingEntity) {
            originalFunctions.addAll(DamageEventHandler.createAttackEnchantmentFunction(this.shadow$getHeldItemMainhand(), ((LivingEntity)targetEntity).getCreatureAttribute(), 1.0f));
            knockbackModifier += (float)EnchantmentHelper.getKnockbackModifier((LivingEntity)((MobEntity)this));
        }
        DamageSource damageSource = DamageSource.causeMobDamage((LivingEntity)((MobEntity)this));
        PhaseTracker.getCauseStackManager().pushCause(damageSource);
        AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), (Entity)targetEntity, originalFunctions, knockbackModifier, originalBaseDamage);
        SpongeCommon.postEvent(event);
        PhaseTracker.getCauseStackManager().popCause();
        if (event.isCancelled()) {
            return false;
        }
        knockbackModifier = event.getKnockbackModifier();
        boolean attackSucceeded = targetEntity.attackEntityFrom(damageSource, (float)event.getFinalOutputDamage());
        if (attackSucceeded) {
            int j;
            if (knockbackModifier > 0.0f && targetEntity instanceof LivingEntity) {
                ((LivingEntity)targetEntity).knockBack((net.minecraft.entity.Entity)((MobEntity)this), knockbackModifier * 0.5f, (double)MathHelper.sin((float)(this.rotationYaw * ((float)Math.PI / 180))), (double)(-MathHelper.cos((float)(this.rotationYaw * ((float)Math.PI / 180)))));
                this.shadow$setMotion(this.shadow$getMotion().mul(0.6, 1.0, 0.6));
            }
            if ((j = EnchantmentHelper.getFireAspectModifier((LivingEntity)((MobEntity)this))) > 0) {
                targetEntity.setFire(j * 4);
            }
            if (targetEntity instanceof PlayerEntity) {
                ItemStack itemstack1;
                PlayerEntity playerentity = (PlayerEntity)targetEntity;
                ItemStack itemstack = this.shadow$getHeldItemMainhand();
                ItemStack itemStack = itemstack1 = playerentity.isHandActive() ? playerentity.getActiveItemStack() : ItemStack.EMPTY;
                if (!itemstack.isEmpty() && !itemstack1.isEmpty() && itemstack.getItem() instanceof AxeItem && itemstack1.getItem() == Items.SHIELD) {
                    float f2 = 0.25f + (float)EnchantmentHelper.getEfficiencyModifier((LivingEntity)((MobEntity)this)) * 0.05f;
                    if (this.rand.nextFloat() < f2) {
                        playerentity.getCooldownTracker().setCooldown(Items.SHIELD, 100);
                        this.world.setEntityState((net.minecraft.entity.Entity)playerentity, (byte)30);
                    }
                }
            }
            this.shadow$applyEnchantments((LivingEntity)((MobEntity)this), targetEntity);
            this.shadow$setLastAttackedEntity(targetEntity);
        }
        return attackSucceeded;
    }

    @ModifyConstant(method={"checkDespawn"}, constant={@Constant(doubleValue=16384.0)})
    private double getHardDespawnRange(double value) {
        if (!this.world.isRemote) {
            return Math.pow(((WorldConfig)((WorldInfoBridge)this.world.getWorldInfo()).bridge$getConfigAdapter().get()).getEntity().getHardDespawnRange(), 2.0);
        }
        return value;
    }

    @ModifyConstant(method={"checkDespawn"}, constant={@Constant(doubleValue=1024.0)}, expect=2)
    private double getSoftDespawnRange(double value) {
        if (!this.world.isRemote) {
            return Math.pow(((WorldConfig)((WorldInfoBridge)this.world.getWorldInfo()).bridge$getConfigAdapter().get()).getEntity().getSoftDespawnRange(), 2.0);
        }
        return value;
    }

    @ModifyConstant(method={"checkDespawn"}, constant={@Constant(intValue=600)})
    private int getMinimumLifetime(int value) {
        if (!this.world.isRemote) {
            return ((WorldConfig)((WorldInfoBridge)this.world.getWorldInfo()).bridge$getConfigAdapter().get()).getEntity().getMinimumLife() * 20;
        }
        return value;
    }

    @Nullable
    @Redirect(method={"checkDespawn()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getClosestPlayer(Lnet/minecraft/entity/Entity;D)Lnet/minecraft/entity/player/PlayerEntity;"))
    private PlayerEntity impl$getClosestPlayerForSpawning(World world, net.minecraft.entity.Entity entityIn, double distance) {
        double bestDistance = -1.0;
        PlayerEntity result = null;
        for (PlayerEntity player : world.getPlayers()) {
            if (player == null || player.removed || !((PlayerEntityBridge)player).bridge$affectsSpawning()) continue;
            double playerDistance = player.getDistanceSq(entityIn.getPosX(), entityIn.getPosY(), entityIn.getPosZ());
            if (!(distance < 0.0) && !(playerDistance < distance * distance) || bestDistance != -1.0 && !(playerDistance < bestDistance)) continue;
            bestDistance = playerDistance;
            result = player;
        }
        return result;
    }
}

