/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.ai.goal;

import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import org.spongepowered.api.entity.living.animal.horse.HorseEntity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.DismountTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.entity.ai.goal.GoalMixin;

@Mixin(value={RunAroundLikeCrazyGoal.class})
public abstract class RunAroundLikeCrazyGoalMixin
extends GoalMixin {
    @Shadow
    @Final
    @Mutable
    private AbstractHorseEntity horseHost;

    @Overwrite
    public void tick() {
        if (!this.horseHost.isTame() && this.horseHost.getRNG().nextInt(50) == 0) {
            Entity entity = (Entity)this.horseHost.getPassengers().get(0);
            if (entity == null) {
                return;
            }
            if (entity instanceof PlayerEntity) {
                int i = this.horseHost.getTemper();
                int j = this.horseHost.getMaxTemper();
                if (j > 0 && this.horseHost.getRNG().nextInt(j) < i) {
                    try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                        frame.pushCause(entity);
                        if (SpongeCommon.postEvent(SpongeEventFactory.createTameEntityEvent(frame.getCurrentCause(), (HorseEntity)this.horseHost))) {
                            return;
                        }
                    }
                    this.horseHost.setTamedBy((PlayerEntity)entity);
                    return;
                }
                this.horseHost.increaseTemper(5);
            }
            if (((EntityBridge)this.horseHost).bridge$removePassengers(DismountTypes.DERAIL.get())) {
                this.horseHost.makeMad();
                this.horseHost.world.setEntityState((Entity)this.horseHost, (byte)6);
            }
        }
    }
}

