/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.EndGatewayTileEntity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.dimension.DimensionType;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.entity.projectile.ThrowableEntityMixin;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={EnderPearlEntity.class})
public abstract class EnderPearlEntityMixin
extends ThrowableEntityMixin {
    @Shadow
    private LivingEntity perlThrower;
    private double impl$damageAmount;

    @ModifyArg(method={"onImpact"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    private float impl$onAttackEntityFromWithDamage(float damage) {
        return (float)this.impl$damageAmount;
    }

    @Override
    public void impl$readFromSpongeCompound(CompoundNBT compound) {
        super.impl$readFromSpongeCompound(compound);
        if (compound.contains("damageAmount")) {
            this.impl$damageAmount = compound.getDouble("damageAmount");
        }
    }

    @Override
    public void impl$writeToSpongeCompound(CompoundNBT compound) {
        super.impl$writeToSpongeCompound(compound);
        compound.putDouble("damageAmount", this.impl$damageAmount);
    }

    @Redirect(method={"onImpact"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/EndGatewayTileEntity;teleportEntity(Lnet/minecraft/entity/Entity;)V"))
    private void impl$createCauseFrameForGatewayTeleport(EndGatewayTileEntity endGatewayTileEntity, Entity entityIn) {
        if (this.shadow$getEntityWorld().isRemote) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(entityIn);
            frame.pushCause(this);
            endGatewayTileEntity.teleportEntity(entityIn);
        }
    }

    @Inject(method={"onImpact"}, at={@At(value="RETURN", ordinal=2, shift=At.Shift.BY, by=2)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void impl$callMoveEntityEventForThrower(RayTraceResult result, CallbackInfo ci, LivingEntity entity) {
        if (this.shadow$getEntityWorld().isRemote) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this.perlThrower);
            frame.pushCause(this);
            frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.ENDER_PEARL);
            MoveEntityEvent event = SpongeEventFactory.createMoveEntityEvent(frame.getCurrentCause(), (org.spongepowered.api.entity.Entity)entity, VecHelper.toVector3d(entity.getPositionVector()), VecHelper.toVector3d(this.shadow$getPositionVector()), VecHelper.toVector3d(this.shadow$getPositionVector()));
            if (SpongeCommon.postEvent(event)) {
                this.shadow$remove();
                return;
            }
            Vector3d destinationPosition = event.getDestinationPosition();
            this.shadow$setPosition(destinationPosition.getX(), destinationPosition.getY(), destinationPosition.getZ());
        }
    }

    @Override
    @Nullable
    public Entity changeDimension(DimensionType dimensionIn) {
        Entity entity = super.changeDimension(dimensionIn);
        if (entity instanceof EnderPearlEntity) {
            this.perlThrower = null;
            this.owner = null;
        }
        return entity;
    }
}

