/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import java.util.ArrayList;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.entity.EntityMixin;

@Mixin(value={HangingEntity.class})
public abstract class HangingEntityMixin
extends EntityMixin {
    @Shadow
    private Direction facingDirection;
    private boolean impl$ignorePhysics = false;

    @Shadow
    public abstract boolean shadow$onValidSurface();

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/item/HangingEntity;onValidSurface()Z"))
    private boolean impl$checkIfOnValidSurfaceAndIgnoresPhysics(HangingEntity entityHanging) {
        return this.shadow$onValidSurface() && !this.impl$ignorePhysics;
    }

    @Override
    public void impl$writeToSpongeCompound(CompoundNBT compound) {
        super.impl$writeToSpongeCompound(compound);
        compound.putBoolean("ignorePhysics", this.impl$ignorePhysics);
    }

    @Override
    public void impl$readFromSpongeCompound(CompoundNBT compound) {
        super.impl$readFromSpongeCompound(compound);
        if (compound.contains("ignorePhysics")) {
            this.impl$ignorePhysics = compound.getBoolean("ignorePhysics");
        }
    }

    @Inject(method={"attackEntityFrom"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/HangingEntity;remove()V")}, cancellable=true)
    private void impl$postEventOnAttackEntityFrom(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(source);
            AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(frame.getCurrentCause(), (Entity)((Object)this), new ArrayList(), 0.0f, amount);
            SpongeCommon.postEvent(event);
            if (event.isCancelled()) {
                cir.setReturnValue((Object)true);
            }
        }
    }
}

