/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ExpireEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.entity.item.ItemEntityBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.storage.WorldInfoBridge;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.entity.EntityMixin;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends EntityMixin
implements ItemEntityBridge {
    private static final int MAGIC_PREVIOUS = -1;
    @Shadow
    private int pickupDelay;
    @Shadow
    private int age;
    private double impl$cachedRadius = -1.0;
    private int impl$previousPickupDelay = -1;
    private boolean impl$infinitePickupDelay;
    private int impl$previousDespawnDelay = -1;
    private boolean impl$infiniteDespawnDelay;

    @Shadow
    public abstract ItemStack shadow$getItem();

    @Override
    public boolean bridge$infinitePickupDelay() {
        return this.impl$infinitePickupDelay;
    }

    @ModifyConstant(method={"searchForOtherItemsNearby"}, constant={@Constant(doubleValue=0.5)})
    private double impl$changeSearchRadiusFromConfig(double originalRadius) {
        if (this.world.isRemote || ((WorldBridge)this.world).bridge$isFake()) {
            return originalRadius;
        }
        if (this.impl$cachedRadius == -1.0) {
            double configRadius = ((WorldConfig)((WorldInfoBridge)this.world.getWorldInfo()).bridge$getConfigAdapter().get()).getWorld().getItemMergeRadius();
            this.impl$cachedRadius = configRadius < 0.0 ? 0.0 : configRadius;
        }
        return this.impl$cachedRadius;
    }

    @Override
    public int bridge$getPickupDelay() {
        return this.impl$infinitePickupDelay ? this.impl$previousPickupDelay : this.pickupDelay;
    }

    @Override
    public void bridge$setPickupDelay(int delay, boolean infinite) {
        this.pickupDelay = delay;
        boolean previous = this.impl$infinitePickupDelay;
        this.impl$infinitePickupDelay = infinite;
        if (infinite && !previous) {
            this.impl$previousPickupDelay = this.pickupDelay;
            this.pickupDelay = Short.MAX_VALUE;
        } else if (!infinite) {
            this.impl$previousPickupDelay = -1;
        }
    }

    @Override
    public boolean bridge$infiniteDespawnDelay() {
        return this.impl$infiniteDespawnDelay;
    }

    @Override
    public int bridge$getDespawnDelay() {
        return 6000 - (this.impl$infiniteDespawnDelay ? this.impl$previousDespawnDelay : this.age);
    }

    @Override
    public void bridge$setDespawnDelay(int delay, boolean infinite) {
        this.age = 6000 - delay;
        boolean previous = this.impl$infiniteDespawnDelay;
        this.impl$infiniteDespawnDelay = infinite;
        if (infinite && !previous) {
            this.impl$previousDespawnDelay = this.age;
            this.age = Short.MIN_VALUE;
        } else if (!infinite) {
            this.impl$previousDespawnDelay = -1;
        }
    }

    @Override
    public void impl$readFromSpongeCompound(CompoundNBT compound) {
        super.impl$readFromSpongeCompound(compound);
        this.impl$infinitePickupDelay = compound.getBoolean("InfinitePickupDelay");
        this.impl$previousPickupDelay = compound.contains("PreviousPickupDelay", 99) ? compound.getInt("PreviousPickupDelay") : -1;
        this.impl$infiniteDespawnDelay = compound.getBoolean("InfiniteDespawnDelay");
        this.impl$previousDespawnDelay = compound.contains("PreviousDespawnDelay", 99) ? compound.getInt("PreviousDespawnDelay") : -1;
        if (this.impl$infinitePickupDelay) {
            if (this.impl$previousPickupDelay != this.pickupDelay) {
                this.impl$previousPickupDelay = this.pickupDelay;
            }
            this.pickupDelay = Short.MAX_VALUE;
        } else if (this.pickupDelay == Short.MAX_VALUE && this.impl$previousPickupDelay != -1) {
            this.pickupDelay = this.impl$previousPickupDelay;
            this.impl$previousPickupDelay = -1;
        }
        if (this.impl$infiniteDespawnDelay) {
            if (this.impl$previousDespawnDelay != this.age) {
                this.impl$previousDespawnDelay = this.age;
            }
            this.age = Short.MIN_VALUE;
        } else if (this.age == Short.MIN_VALUE && this.impl$previousDespawnDelay != -1) {
            this.age = this.impl$previousDespawnDelay;
            this.impl$previousDespawnDelay = -1;
        }
    }

    @Override
    public void impl$writeToSpongeCompound(CompoundNBT compound) {
        super.impl$writeToSpongeCompound(compound);
        compound.putBoolean("InfinitePickupDelay", this.impl$infinitePickupDelay);
        compound.putShort("PreviousPickupDelay", (short)this.impl$previousPickupDelay);
        compound.putBoolean("InfiniteDespawnDelay", this.impl$infiniteDespawnDelay);
        compound.putShort("PreviousDespawnDelay", (short)this.impl$previousDespawnDelay);
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/ItemEntity;remove()V")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/item/ItemEntity;handleWaterMovement()Z"), to=@At(value="TAIL"))})
    private void impl$fireExpireEntityEventTargetItem(CallbackInfo ci) {
        if (!PhaseTracker.SERVER.onSidedThread() || this.shadow$getItem().isEmpty()) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            ExpireEntityEvent event = SpongeEventFactory.createExpireEntityEvent(frame.getCurrentCause(), (Item)((Object)this));
            SpongeCommon.postEvent(event);
        }
    }
}

