/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.explosive.fused.PrimedTNT;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.entity.item.EntityTNTPrimedBridge;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.entity.EntityMixin;

@Mixin(value={TNTEntity.class})
public abstract class TNTEntityMixin
extends EntityMixin
implements EntityTNTPrimedBridge,
FusedExplosiveBridge,
ExplosiveBridge {
    @Shadow
    private int fuse;
    @Nullable
    private LivingEntity impl$detonator;
    private int bridge$explosionRadius = 4;
    private int bridge$fuseDuration = 80;

    @Override
    public void bridge$setDetonator(LivingEntity detonator) {
        this.impl$detonator = detonator;
    }

    @Override
    public boolean bridge$isExploding() {
        return this.removed && this.fuse <= 0;
    }

    @Override
    public Optional<Integer> bridge$getExplosionRadius() {
        return Optional.of(this.bridge$explosionRadius);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Integer radius) {
        this.bridge$explosionRadius = radius == null ? 4 : radius;
    }

    @Override
    public int bridge$getFuseDuration() {
        return this.bridge$fuseDuration;
    }

    @Override
    public void bridge$setFuseDuration(int fuseTicks) {
        this.bridge$fuseDuration = fuseTicks;
    }

    @Override
    public int bridge$getFuseTicksRemaining() {
        return this.fuse;
    }

    @Override
    public void bridge$setFuseTicksRemaining(int fuseTicks) {
        this.fuse = fuseTicks;
    }

    @Nullable
    @Redirect(method={"explode"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;createExplosion(Lnet/minecraft/entity/Entity;DDDFLnet/minecraft/world/Explosion$Mode;)Lnet/minecraft/world/Explosion;"))
    private net.minecraft.world.Explosion impl$useSpongeExplosion(World world, Entity entityIn, double xIn, double yIn, double zIn, float explosionRadius, Explosion.Mode modeIn) {
        return SpongeCommonEventFactory.detonateExplosive(this, Explosion.builder().location(ServerLocation.of((ServerWorld)world, xIn, yIn, zIn)).sourceExplosive((PrimedTNT)((Object)this)).radius(this.bridge$explosionRadius).shouldPlaySmoke(modeIn.ordinal() > Explosion.Mode.NONE.ordinal()).shouldBreakBlocks(modeIn.ordinal() > Explosion.Mode.NONE.ordinal())).orElseGet(() -> {
            ((PrimedTNT)((Object)this)).offer(Keys.IS_PRIMED, false);
            return null;
        });
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void impl$updateTNTPushPrime(CallbackInfo ci) {
        if (this.fuse == this.bridge$fuseDuration - 1 && !this.world.isRemote) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                if (this.impl$detonator != null) {
                    frame.pushCause(this.impl$detonator);
                }
                frame.pushCause(this);
                this.bridge$postPrime();
            }
        }
    }
}

