/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item.minecart;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.TNTMinecartEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.vehicle.minecart.TNTMinecart;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.entity.item.minecart.AbstractMinecartEntityMixin;

@Mixin(value={TNTMinecartEntity.class})
public abstract class TNTMinecartEntityMixin
extends AbstractMinecartEntityMixin
implements FusedExplosiveBridge,
ExplosiveBridge {
    @Shadow
    private int minecartTNTFuse;
    @Nullable
    private Integer impl$explosionRadius = null;
    private int impl$fuseDuration = 80;
    private boolean impl$detonationCancelled;
    @Nullable
    private Object impl$primeCause;

    @Override
    public Optional<Integer> bridge$getExplosionRadius() {
        return Optional.ofNullable(this.impl$explosionRadius);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Integer radius) {
        this.impl$explosionRadius = radius;
    }

    @Override
    public int bridge$getFuseDuration() {
        return this.impl$fuseDuration;
    }

    @Override
    public void bridge$setFuseDuration(int fuseTicks) {
        this.impl$fuseDuration = fuseTicks;
    }

    @Override
    public int bridge$getFuseTicksRemaining() {
        return this.minecartTNTFuse;
    }

    @Override
    public void bridge$setFuseTicksRemaining(int fuseTicks) {
        this.minecartTNTFuse = fuseTicks;
    }

    @Inject(method={"attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"}, at={@At(value="INVOKE")})
    private void impl$onAttackSetPrimeCause(DamageSource damageSource, float amount, CallbackInfoReturnable<Boolean> ci) {
        this.impl$primeCause = damageSource;
    }

    @Inject(method={"onActivatorRailPass(IIIZ)V"}, at={@At(value="INVOKE")})
    private void impl$onActivateSetPrimeCauseNotifier(int x, int y, int z, boolean receivingPower, CallbackInfo ci) {
        if (((WorldBridge)this.world).bridge$isFake()) {
            return;
        }
        if (receivingPower) {
            ((ServerWorld)this.world).get(x, y, z, Keys.NOTIFIER).ifPresent(notifier -> {
                this.impl$primeCause = notifier;
            });
        }
    }

    @Inject(method={"ignite"}, at={@At(value="INVOKE")}, cancellable=true)
    private void impl$preIgnite(CallbackInfo ci) {
        if (!this.bridge$shouldPrime()) {
            this.bridge$setFuseTicksRemaining(-1);
            ci.cancel();
        }
    }

    @Inject(method={"ignite"}, at={@At(value="RETURN")})
    private void impl$postSpongeIgnite(CallbackInfo ci) {
        this.bridge$setFuseTicksRemaining(this.impl$fuseDuration);
        if (this.impl$primeCause != null) {
            PhaseTracker.getCauseStackManager().pushCause(this.impl$primeCause);
        }
        this.bridge$postPrime();
        if (this.impl$primeCause != null) {
            PhaseTracker.getCauseStackManager().popCause();
        }
    }

    @Redirect(method={"explodeCart"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;createExplosion(Lnet/minecraft/entity/Entity;DDDFLnet/minecraft/world/Explosion$Mode;)Lnet/minecraft/world/Explosion;"))
    @Nullable
    private net.minecraft.world.Explosion impl$useSpongeExplosion(World world, Entity entityIn, double xIn, double yIn, double zIn, float explosionRadius, Explosion.Mode modeIn) {
        return SpongeCommonEventFactory.detonateExplosive(this, Explosion.builder().location(ServerLocation.of((ServerWorld)world, xIn, yIn, zIn)).sourceExplosive((TNTMinecart)((Object)this)).radius(this.impl$explosionRadius != null ? (float)this.impl$explosionRadius.intValue() : explosionRadius).shouldPlaySmoke(modeIn.ordinal() > Explosion.Mode.NONE.ordinal()).shouldBreakBlocks(modeIn.ordinal() > Explosion.Mode.NONE.ordinal())).orElseGet(() -> {
            this.impl$detonationCancelled = true;
            return null;
        });
    }

    @Inject(method={"explodeCart"}, at={@At(value="RETURN")})
    private void impL$postExplode(CallbackInfo ci) {
        if (this.impl$detonationCancelled) {
            this.removed = false;
            this.impl$detonationCancelled = false;
        }
    }

    @Inject(method={"attackEntityFrom"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/minecart/TNTMinecartEntity;explodeCart(D)V")})
    private void impl$postOnAttackEntityFrom(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(source);
            AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(frame.getCurrentCause(), (TNTMinecart)((Object)this), new ArrayList(), 0.0f, amount);
            SpongeCommon.postEvent(event);
            if (event.isCancelled()) {
                cir.setReturnValue((Object)true);
            }
        }
    }
}

