/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.player;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerAbilities;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.FoodStats;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Humanoid;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierTypes;
import org.spongepowered.api.event.cause.entity.damage.DamageTypes;
import org.spongepowered.api.event.cause.entity.damage.ModifierFunction;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.LocationTargetingBridge;
import org.spongepowered.common.bridge.authlib.GameProfileHolderBridge;
import org.spongepowered.common.bridge.entity.player.PlayerEntityBridge;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.cause.entity.damage.DamageEventHandler;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.SpongeImplHooks;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.entity.LivingEntityMixin;
import org.spongepowered.common.text.serializer.LegacyTexts;
import org.spongepowered.common.util.ExperienceHolderUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={PlayerEntity.class})
public abstract class PlayerEntityMixin
extends LivingEntityMixin
implements PlayerEntityBridge,
LocationTargetingBridge,
GameProfileHolderBridge {
    @Shadow
    public int experienceLevel;
    @Shadow
    public int experienceTotal;
    @Shadow
    public float experience;
    @Shadow
    @Final
    public PlayerAbilities abilities;
    @Shadow
    @Final
    public PlayerInventory inventory;
    @Shadow
    public Container openContainer;
    @Shadow
    @Final
    public PlayerContainer container;
    @Shadow
    @Final
    private GameProfile gameProfile;
    @Shadow
    public float prevCameraYaw;
    @Shadow
    private BlockPos spawnPos;
    private boolean impl$affectsSpawning = true;
    private boolean impl$shouldRestoreInventory = false;
    protected final boolean impl$isFake = SpongeImplHooks.isFakePlayer((net.minecraft.entity.Entity)((PlayerEntity)this));
    protected Vector3d impl$targetedPosition;

    @Shadow
    public abstract boolean shadow$isSpectator();

    @Shadow
    public abstract int shadow$xpBarCap();

    @Shadow
    @Nullable
    public abstract ItemEntity shadow$dropItem(ItemStack var1, boolean var2, boolean var3);

    @Shadow
    public abstract FoodStats shadow$getFoodStats();

    @Shadow
    public abstract GameProfile shadow$getGameProfile();

    @Shadow
    public abstract Scoreboard shadow$getWorldScoreboard();

    @Shadow
    public abstract boolean shadow$isCreative();

    @Shadow
    public boolean shadow$canAttackPlayer(PlayerEntity other) {
        return false;
    }

    @Shadow
    public abstract String shadow$getScoreboardName();

    @Shadow
    public abstract float shadow$getAIMoveSpeed();

    @Shadow
    public abstract void shadow$resetCooldown();

    @Shadow
    public abstract float shadow$getCooledAttackStrength(float var1);

    @Shadow
    public abstract void shadow$spawnSweepParticles();

    @Shadow
    public abstract void shadow$onCriticalHit(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract void shadow$onEnchantmentCritical(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract void shadow$addStat(Stat<?> var1);

    @Shadow
    public abstract void shadow$addStat(ResourceLocation var1, int var2);

    @Shadow
    public abstract void shadow$addExhaustion(float var1);

    @Shadow
    public abstract ITextComponent shadow$getDisplayName();

    @Shadow
    protected abstract void shadow$spawnShoulderEntities();

    @Shadow
    public abstract void shadow$addStat(ResourceLocation var1);

    @Override
    public boolean bridge$affectsSpawning() {
        return this.impl$affectsSpawning && !this.shadow$isSpectator() && !this.bridge$isUntargetable();
    }

    @Override
    public void bridge$setAffectsSpawning(boolean affectsSpawning) {
        this.impl$affectsSpawning = affectsSpawning;
    }

    @Override
    public void bridge$shouldRestoreInventory(boolean restore) {
        this.impl$shouldRestoreInventory = restore;
    }

    @Override
    public boolean bridge$shouldRestoreInventory() {
        return this.impl$shouldRestoreInventory;
    }

    @Override
    public GameProfile bridge$getGameProfile() {
        return this.gameProfile;
    }

    @Override
    public int bridge$getExperienceSinceLevel() {
        return this.experienceTotal - ExperienceHolderUtil.xpAtLevel(this.experienceLevel);
    }

    @Override
    public void bridge$setExperienceSinceLevel(int experience) {
        this.experienceTotal = ExperienceHolderUtil.xpAtLevel(this.experienceLevel) + experience;
        this.experience = (float)experience / (float)this.shadow$xpBarCap();
    }

    @Override
    public Vector3d bridge$getTargetedPosition() {
        if (this.impl$targetedPosition == null) {
            if (this.spawnPos == null) {
                return new Vector3d(0.0f, 0.0f, 0.0f);
            }
            return new Vector3d((float)this.spawnPos.getX(), (float)this.spawnPos.getY(), (float)this.spawnPos.getZ());
        }
        return this.impl$targetedPosition;
    }

    @Override
    public void bridge$setTargetedPosition(@org.checkerframework.checker.nullness.qual.Nullable Vector3d position) {
        this.impl$targetedPosition = position;
        this.spawnPos = position != null ? VecHelper.toBlockPos(position) : null;
    }

    @Inject(method={"getDisplayName"}, at={@At(value="RETURN")}, cancellable=true)
    private void impl$getDisplayNameWithParsing(CallbackInfoReturnable<ITextComponent> ci) {
        ci.setReturnValue((Object)LegacyTexts.parseComponent((StringTextComponent)ci.getReturnValue(), '\u00a7'));
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;isSleeping()Z"))
    private boolean impl$postSleepingEvent(PlayerEntity self) {
        if (self.isSleeping()) {
            if (!((WorldBridge)this.world).bridge$isFake()) {
                CauseStackManager csm = PhaseTracker.getCauseStackManager();
                csm.pushCause(this);
                BlockPos bedLocation = this.shadow$getBedPosition().get();
                BlockSnapshot snapshot = ((ServerWorld)this.world).createSnapshot(bedLocation.getX(), bedLocation.getY(), bedLocation.getZ());
                SpongeCommon.postEvent(SpongeEventFactory.createSleepingEventTick(csm.getCurrentCause(), snapshot, (Humanoid)((Object)this)));
                csm.popCause();
            }
            return true;
        }
        return false;
    }

    @Redirect(method={"getDisplayName"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getName()Lnet/minecraft/util/text/ITextComponent;"))
    private ITextComponent impl$useCustomNameIfSet(PlayerEntity playerEntity) {
        if (playerEntity instanceof ServerPlayerEntity) {
            if (playerEntity.hasCustomName()) {
                return playerEntity.getCustomName();
            }
            return playerEntity.getName();
        }
        return playerEntity.getName();
    }

    @Redirect(method={"playSound(Lnet/minecraft/util/SoundEvent;FF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;playSound(Lnet/minecraft/entity/player/PlayerEntity;DDDLnet/minecraft/util/SoundEvent;Lnet/minecraft/util/SoundCategory;FF)V"))
    private void impl$playNoSoundToOthersIfVanished(World world, PlayerEntity player, double x, double y, double z, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        if (!this.bridge$isVanished()) {
            this.world.playSound(player, x, y, z, sound, category, volume, pitch);
        }
    }

    @Redirect(method={"canUseCommandBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getPermissionLevel()I"))
    private int impl$checkPermissionForCommandBlock(PlayerEntity playerEntity) {
        return ((Subject)((Object)this)).hasPermission("minecraft.commandblock") ? 2 : 0;
    }

    @Redirect(method={"canPlayerEdit"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;canPlaceOn(Lnet/minecraft/tags/NetworkTagManager;Lnet/minecraft/util/CachedBlockInfo;)Z"))
    private boolean impl$callChangeBlockPre(ItemStack stack, NetworkTagManager tagManager, CachedBlockInfo cachedBlockInfo, BlockPos pos, Direction facing, ItemStack sameStack) {
        if (!stack.canPlaceOn(tagManager, cachedBlockInfo)) {
            return false;
        }
        if (this.world instanceof WorldBridge && !((WorldBridge)this.world).bridge$isFake() && ShouldFire.CHANGE_BLOCK_EVENT_PRE) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(stack));
                boolean bl = !SpongeCommonEventFactory.callChangeBlockEventPre((ServerWorldBridge)this.world, pos, (Object)this).isCancelled();
                return bl;
            }
        }
        return true;
    }

    @Overwrite
    @Nullable
    public ItemEntity dropItem(ItemStack itemStackIn, boolean unused) {
        return this.shadow$dropItem(itemStackIn, false, false);
    }

    @Inject(method={"getFireImmuneTicks"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$useCustomFireImmuneTicks(CallbackInfoReturnable<Integer> ci) {
        if (this.impl$hasCustomFireImmuneTicks) {
            ci.setReturnValue((Object)this.impl$fireImmuneTicks);
        }
    }

    @Inject(method={"interactOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void impl$onRightClickEntity(net.minecraft.entity.Entity entityToInteractOn, Hand hand, CallbackInfoReturnable<ActionResultType> cir) {
        if (!((PlayerEntity)this instanceof ServerPlayerEntity)) {
            return;
        }
        InteractEntityEvent.Secondary event = SpongeCommonEventFactory.callInteractEntityEventSecondary((ServerPlayerEntity)this, this.shadow$getHeldItem(hand), entityToInteractOn, hand, null);
        if (event.isCancelled()) {
            cir.setReturnValue((Object)ActionResultType.FAIL);
        }
    }

    @Overwrite
    public void attackTargetEntityWithCurrentItem(net.minecraft.entity.Entity targetEntity) {
        if (!SpongeImplHooks.checkAttackEntity((PlayerEntity)this, targetEntity)) {
            return;
        }
        if (targetEntity.canBeAttackedWithItem() && !targetEntity.hitByEntity((net.minecraft.entity.Entity)((PlayerEntity)this))) {
            double originalBaseDamage = this.shadow$getAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).getValue();
            float damage = (float)originalBaseDamage;
            float enchantmentDamage = 0.0f;
            float attackStrength = this.shadow$getCooledAttackStrength(0.5f);
            ArrayList<DamageFunction> originalFunctions = new ArrayList<DamageFunction>();
            CreatureAttribute creatureAttribute = targetEntity instanceof LivingEntity ? ((LivingEntity)targetEntity).getCreatureAttribute() : CreatureAttribute.UNDEFINED;
            List<DamageFunction> enchantmentModifierFunctions = DamageEventHandler.createAttackEnchantmentFunction(this.shadow$getHeldItemMainhand(), creatureAttribute, attackStrength);
            List enchantmentModifiers = enchantmentModifierFunctions.stream().map(ModifierFunction::getModifier).collect(Collectors.toList());
            enchantmentDamage = (float)enchantmentModifierFunctions.stream().map(ModifierFunction::getFunction).mapToDouble(function -> function.applyAsDouble(originalBaseDamage)).sum();
            originalFunctions.addAll(enchantmentModifierFunctions);
            originalFunctions.add(DamageEventHandler.provideCooldownAttackStrengthFunction((PlayerEntity)this, attackStrength));
            enchantmentDamage *= attackStrength;
            this.shadow$resetCooldown();
            if ((damage *= 0.2f + attackStrength * attackStrength * 0.8f) > 0.0f || enchantmentDamage > 0.0f) {
                boolean isMainthread;
                ItemStack itemstack;
                boolean isStrongAttack = attackStrength > 0.9f;
                boolean isSprintingAttack = false;
                boolean isCriticalAttack = false;
                boolean isSweapingAttack = false;
                int knockbackModifier = 0;
                knockbackModifier += EnchantmentHelper.getKnockbackModifier((LivingEntity)((PlayerEntity)this));
                if (this.shadow$isSprinting() && isStrongAttack) {
                    ++knockbackModifier;
                    isSprintingAttack = true;
                }
                isCriticalAttack = isStrongAttack && this.fallDistance > 0.0f && !this.onGround && !this.shadow$isOnLadder() && !this.shadow$isInWater() && !this.shadow$isPotionActive(Effects.BLINDNESS) && !this.shadow$isPassenger() && targetEntity instanceof LivingEntity;
                boolean bl = isCriticalAttack = isCriticalAttack && !this.shadow$isSprinting();
                if (isCriticalAttack) {
                    originalFunctions.add(DamageEventHandler.provideCriticalAttackTuple((PlayerEntity)this));
                }
                double distanceWalkedDelta = this.distanceWalkedModified - this.prevDistanceWalkedModified;
                ItemStack heldItem = this.shadow$getHeldItemMainhand();
                if (isStrongAttack && !isCriticalAttack && !isSprintingAttack && this.onGround && distanceWalkedDelta < (double)this.shadow$getAIMoveSpeed() && (itemstack = heldItem).getItem() instanceof SwordItem) {
                    isSweapingAttack = true;
                }
                DamageSource damageSource = DamageSource.causePlayerDamage((PlayerEntity)((PlayerEntity)this));
                boolean bl2 = isMainthread = !this.world.isRemote;
                if (isMainthread) {
                    PhaseTracker.getInstance().pushCause(damageSource);
                }
                Cause currentCause = isMainthread ? PhaseTracker.getInstance().getCurrentCause() : Cause.of(EventContext.empty(), damageSource);
                AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(currentCause, (Entity)targetEntity, originalFunctions, knockbackModifier, originalBaseDamage);
                SpongeCommon.postEvent(event);
                if (isMainthread) {
                    PhaseTracker.getInstance().popCause();
                }
                if (event.isCancelled()) {
                    return;
                }
                damage = (float)event.getFinalOutputDamage();
                double attackDamage = damage;
                knockbackModifier = (int)event.getKnockbackModifier();
                enchantmentDamage = (float)enchantmentModifiers.stream().mapToDouble(event::getOutputDamage).sum();
                float targetOriginalHealth = 0.0f;
                boolean litEntityOnFire = false;
                int fireAspectModifier = EnchantmentHelper.getFireAspectModifier((LivingEntity)((PlayerEntity)this));
                if (targetEntity instanceof LivingEntity) {
                    targetOriginalHealth = ((LivingEntity)targetEntity).getHealth();
                    if (fireAspectModifier > 0 && !targetEntity.isBurning()) {
                        litEntityOnFire = true;
                        targetEntity.setFire(1);
                    }
                }
                Vec3d targetMotion = targetEntity.getMotion();
                boolean attackSucceeded = targetEntity.attackEntityFrom(DamageSource.causePlayerDamage((PlayerEntity)((PlayerEntity)this)), damage);
                if (attackSucceeded) {
                    if (knockbackModifier > 0) {
                        if (targetEntity instanceof LivingEntity) {
                            ((LivingEntity)targetEntity).knockBack((net.minecraft.entity.Entity)((PlayerEntity)this), (float)knockbackModifier * 0.5f, (double)MathHelper.sin((float)(this.rotationYaw * ((float)Math.PI / 180))), (double)(-MathHelper.cos((float)(this.rotationYaw * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * ((float)Math.PI / 180))) * (float)knockbackModifier * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * ((float)Math.PI / 180))) * (float)knockbackModifier * 0.5f));
                        }
                        this.shadow$setMotion(this.shadow$getMotion().mul(0.6, 1.0, 0.6));
                        this.shadow$setSprinting(false);
                    }
                    if (isSweapingAttack) {
                        for (LivingEntity livingEntity : this.world.getEntitiesWithinAABB(LivingEntity.class, targetEntity.getBoundingBox().grow(1.0, 0.25, 1.0))) {
                            if (livingEntity == (PlayerEntity)this || livingEntity == targetEntity || this.shadow$isOnSameTeam((net.minecraft.entity.Entity)livingEntity) || livingEntity instanceof ArmorStandEntity && ((ArmorStandEntity)livingEntity).hasMarker() || !(this.shadow$getDistanceSq((net.minecraft.entity.Entity)livingEntity) < 9.0)) continue;
                            EntityDamageSource sweepingAttackSource = (EntityDamageSource)((EntityDamageSource.Builder)((EntityDamageSource.Builder)EntityDamageSource.builder().entity((Player)((Object)this))).type(DamageTypes.SWEEPING_ATTACK)).build();
                            CauseStackManager.StackFrame frame = isMainthread ? PhaseTracker.getInstance().pushCauseFrame() : null;
                            Throwable throwable = null;
                            try {
                                if (isMainthread) {
                                    frame.pushCause(sweepingAttackSource);
                                }
                                ItemStackSnapshot heldSnapshot = ItemStackUtil.snapshotOf(heldItem);
                                if (isMainthread) {
                                    frame.addContext(EventContextKeys.WEAPON, heldSnapshot);
                                }
                                DamageFunction sweapingFunction = DamageFunction.of(DamageModifier.builder().cause(Cause.of(EventContext.empty(), heldSnapshot)).item(heldSnapshot).type(DamageModifierTypes.SWEEPING).build(), incoming -> (double)EnchantmentHelper.getSweepingDamageRatio((LivingEntity)((PlayerEntity)this)) * attackDamage);
                                ArrayList<DamageFunction> sweapingFunctions = new ArrayList<DamageFunction>();
                                sweapingFunctions.add(sweapingFunction);
                                AttackEntityEvent sweepingAttackEvent = SpongeEventFactory.createAttackEntityEvent(currentCause, (Entity)livingEntity, sweapingFunctions, 1.0f, 1.0);
                                SpongeCommon.postEvent(sweepingAttackEvent);
                                if (sweepingAttackEvent.isCancelled()) continue;
                                livingEntity.knockBack((net.minecraft.entity.Entity)((PlayerEntity)this), sweepingAttackEvent.getKnockbackModifier() * 0.4f, (double)MathHelper.sin((float)(this.rotationYaw * ((float)Math.PI / 180))), (double)(-MathHelper.cos((float)(this.rotationYaw * ((float)Math.PI / 180)))));
                                livingEntity.attackEntityFrom(DamageSource.causePlayerDamage((PlayerEntity)((PlayerEntity)this)), (float)sweepingAttackEvent.getFinalOutputDamage());
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (frame == null) continue;
                                if (throwable != null) {
                                    try {
                                        frame.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                frame.close();
                            }
                        }
                        this.world.playSound(null, this.shadow$getPosX(), this.shadow$getPosY(), this.shadow$getPosZ(), SoundEvents.ENTITY_PLAYER_ATTACK_SWEEP, this.shadow$getSoundCategory(), 1.0f, 1.0f);
                        this.shadow$spawnSweepParticles();
                    }
                    if (targetEntity instanceof ServerPlayerEntity && targetEntity.velocityChanged) {
                        ((ServerPlayerEntity)targetEntity).connection.sendPacket((IPacket)new SEntityVelocityPacket(targetEntity));
                        targetEntity.velocityChanged = false;
                        targetEntity.setMotion(targetMotion);
                    }
                    if (isCriticalAttack) {
                        this.world.playSound(null, this.shadow$getPosX(), this.shadow$getPosY(), this.shadow$getPosZ(), SoundEvents.ENTITY_PLAYER_ATTACK_CRIT, this.shadow$getSoundCategory(), 1.0f, 1.0f);
                        this.shadow$onCriticalHit(targetEntity);
                    }
                    if (!isCriticalAttack && !isSweapingAttack) {
                        if (isStrongAttack) {
                            this.world.playSound(null, this.shadow$getPosX(), this.shadow$getPosY(), this.shadow$getPosZ(), SoundEvents.ENTITY_PLAYER_ATTACK_STRONG, this.shadow$getSoundCategory(), 1.0f, 1.0f);
                        } else {
                            this.world.playSound(null, this.shadow$getPosX(), this.shadow$getPosY(), this.shadow$getPosZ(), SoundEvents.ENTITY_PLAYER_ATTACK_WEAK, this.shadow$getSoundCategory(), 1.0f, 1.0f);
                        }
                    }
                    if (enchantmentDamage > 0.0f) {
                        this.shadow$onEnchantmentCritical(targetEntity);
                    }
                    this.shadow$setLastAttackedEntity(targetEntity);
                    if (targetEntity instanceof LivingEntity) {
                        EnchantmentHelper.applyThornEnchantments((LivingEntity)((LivingEntity)targetEntity), (net.minecraft.entity.Entity)((PlayerEntity)this));
                    }
                    EnchantmentHelper.applyArthropodEnchantments((LivingEntity)((PlayerEntity)this), (net.minecraft.entity.Entity)targetEntity);
                    ItemStack itemstack1 = this.shadow$getHeldItemMainhand();
                    net.minecraft.entity.Entity entity = targetEntity;
                    if (targetEntity instanceof EnderDragonPartEntity) {
                        entity = ((EnderDragonPartEntity)targetEntity).dragon;
                    }
                    if (!this.world.isRemote && !itemstack1.isEmpty() && entity instanceof LivingEntity) {
                        itemstack1.hitEntity((LivingEntity)entity, (PlayerEntity)this);
                        if (itemstack1.isEmpty()) {
                            this.shadow$setHeldItem(Hand.MAIN_HAND, ItemStack.EMPTY);
                        }
                    }
                    if (targetEntity instanceof LivingEntity) {
                        float f5 = targetOriginalHealth - ((LivingEntity)targetEntity).getHealth();
                        this.shadow$addStat(Stats.DAMAGE_DEALT, Math.round(f5 * 10.0f));
                        if (fireAspectModifier > 0) {
                            targetEntity.setFire(fireAspectModifier * 4);
                        }
                        if (this.world instanceof ServerWorld && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((net.minecraft.world.server.ServerWorld)this.world).spawnParticle((IParticleData)ParticleTypes.DAMAGE_INDICATOR, targetEntity.getPosX(), targetEntity.getPosY() + (double)(targetEntity.getHeight() * 0.5f), targetEntity.getPosZ(), k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.shadow$addExhaustion(0.1f);
                } else {
                    this.world.playSound(null, this.shadow$getPosX(), this.shadow$getPosY(), this.shadow$getPosZ(), SoundEvents.ENTITY_PLAYER_ATTACK_NODAMAGE, this.shadow$getSoundCategory(), 1.0f, 1.0f);
                    if (litEntityOnFire) {
                        targetEntity.extinguish();
                    }
                }
            }
        }
    }

    @Override
    public boolean impl$canCallIgniteEntityEvent() {
        return !this.shadow$isSpectator() && !this.shadow$isCreative();
    }
}

