/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.projectile;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.projectile.arrow.Arrow;
import org.spongepowered.api.entity.projectile.arrow.ArrowEntity;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.entity.projectile.ProjectileSourceSerializer;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.mixin.core.entity.EntityMixin;

@Mixin(value={AbstractArrowEntity.class})
public abstract class AbstractArrowEntityMixin
extends EntityMixin {
    @Shadow
    public UUID shootingEntity;
    @Shadow
    private int ticksInAir;
    @Shadow
    private double damage;
    @Shadow
    protected boolean inGround;
    @Shadow
    public int arrowShake;
    @Shadow
    public AbstractArrowEntity.PickupStatus pickupStatus;
    @Shadow
    @Nullable
    private BlockState inBlockState;
    @Nullable
    public ProjectileSource projectileSource;

    @Shadow
    public abstract void shadow$setIsCritical(boolean var1);

    @Shadow
    public abstract void shadow$setPierceLevel(byte var1);

    @Shadow
    public abstract void shadow$setShotFromCrossbow(boolean var1);

    @Shadow
    protected abstract void shadow$func_213870_w();

    @Shadow
    protected abstract ItemStack shadow$getArrowStack();

    @Override
    public void impl$readFromSpongeCompound(CompoundNBT compound) {
        super.impl$readFromSpongeCompound(compound);
        ProjectileSourceSerializer.readSourceFromNbt(compound, (Arrow)((Object)this));
    }

    @Override
    public void impl$writeToSpongeCompound(CompoundNBT compound) {
        super.impl$writeToSpongeCompound(compound);
        ProjectileSourceSerializer.writeSourceToNbt(compound, (ProjectileSource)((Arrow)((Object)this)).shooter().get(), this.shootingEntity);
    }

    @Inject(method={"onHit"}, at={@At(value="HEAD")}, cancellable=true)
    private void onProjectileHit(RayTraceResult hitResult, CallbackInfo ci) {
        if (!((WorldBridge)this.world).bridge$isFake() && hitResult.getType() != RayTraceResult.Type.MISS && SpongeCommonEventFactory.handleCollideImpactEvent((Entity)((AbstractArrowEntity)this), ((ArrowEntity)((Object)this)).get(Keys.SHOOTER).orElse(null), hitResult)) {
            this.shadow$playSound(SoundEvents.ENTITY_ARROW_HIT, 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
            if (hitResult.getType() == RayTraceResult.Type.BLOCK) {
                BlockState blockstate;
                BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)hitResult;
                this.inBlockState = blockstate = this.world.getBlockState(blockraytraceresult.getPos());
                Vec3d vec3d = blockraytraceresult.getHitVec().subtract(this.shadow$getPosX(), this.shadow$getPosY(), this.shadow$getPosZ());
                this.shadow$setMotion(vec3d);
                Vec3d vec3d1 = vec3d.normalize().scale((double)0.05f);
                this.shadow$setPosition(this.shadow$getPosX() - vec3d1.x, this.shadow$getPosY() - vec3d1.y, this.shadow$getPosZ() - vec3d1.z);
                this.inGround = true;
                this.arrowShake = 7;
                this.shadow$setIsCritical(false);
                this.shadow$setPierceLevel((byte)0);
                this.shadow$setShotFromCrossbow(false);
                this.shadow$func_213870_w();
            } else {
                this.shadow$setMotion(this.shadow$getMotion().scale(-0.1));
                this.rotationYaw += 180.0f;
                this.prevRotationYaw += 180.0f;
                this.ticksInAir = 0;
                if (!this.world.isRemote && this.shadow$getMotion().lengthSquared() < 1.0E-7) {
                    if (this.pickupStatus == AbstractArrowEntity.PickupStatus.ALLOWED) {
                        this.shadow$entityDropItem(this.shadow$getArrowStack(), 0.1f);
                    }
                    this.shadow$remove();
                }
            }
            ci.cancel();
        }
    }
}

