/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.scoreboard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SDisplayObjectivePacket;
import net.minecraft.network.play.server.SScoreboardObjectivePacket;
import net.minecraft.network.play.server.STeamsPacket;
import net.minecraft.network.play.server.SUpdateScorePacket;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.criteria.Criterion;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayMode;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.scoreboard.ScorePlayerTeamAccessor;
import org.spongepowered.common.accessor.scoreboard.ScoreboardAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.scoreboard.ScoreBridge;
import org.spongepowered.common.bridge.scoreboard.ScoreObjectiveBridge;
import org.spongepowered.common.bridge.scoreboard.ServerScoreboardBridge;
import org.spongepowered.common.registry.MappedRegistry;
import org.spongepowered.common.scoreboard.SpongeDisplaySlot;
import org.spongepowered.common.scoreboard.SpongeObjective;
import org.spongepowered.common.scoreboard.SpongeScore;

@Mixin(value={ServerScoreboard.class})
public abstract class ServerScoreboardMixin
extends net.minecraft.scoreboard.Scoreboard
implements ServerScoreboardBridge {
    private final List<ServerPlayerEntity> impl$players = new ArrayList<ServerPlayerEntity>();

    @Shadow
    protected abstract void shadow$markSaveDataDirty();

    @Override
    public void bridge$updateDisplaySlot(@Nullable Objective objective, DisplaySlot displaySlot) throws IllegalStateException {
        if (objective != null && !objective.getScoreboards().contains(this)) {
            throw new IllegalStateException("Attempting to set an objective's display slot that does not exist on this scoreboard!");
        }
        int index = ((SpongeDisplaySlot)displaySlot).getIndex();
        ((ScoreboardAccessor)((Object)this)).accessor$getObjectiveDisplaySlots()[index] = objective == null ? null : ((SpongeObjective)objective).getObjectiveFor(this);
        this.bridge$sendToPlayers((IPacket<?>)new SDisplayObjectivePacket(index, ((ScoreboardAccessor)((Object)this)).accessor$getObjectiveDisplaySlots()[index]));
    }

    @Override
    public void bridge$addObjective(Objective objective) {
        ScoreObjective nmsObjective = this.getObjective(objective.getName());
        if (nmsObjective != null) {
            throw new IllegalArgumentException(String.format("An objective with the name '%s' already exists!", objective.getName()));
        }
        ScoreObjective scoreObjective = ((SpongeObjective)objective).getObjectiveFor(this);
        List<ScoreObjective> objectives = ((ScoreboardAccessor)((Object)this)).accessor$getScoreObjectiveCriterias().get(objective.getCriterion());
        if (objectives == null) {
            objectives = new ArrayList<ScoreObjective>();
            ((ScoreboardAccessor)((Object)this)).accessor$getScoreObjectiveCriterias().put((ScoreCriteria)objective.getCriterion(), objectives);
        }
        objectives.add(scoreObjective);
        ((ScoreboardAccessor)((Object)this)).accessor$getScoreObjectives().put(objective.getName(), scoreObjective);
        this.onObjectiveAdded(scoreObjective);
        ((SpongeObjective)objective).updateScores(this);
    }

    @Override
    public Optional<Objective> bridge$getObjective(String name) {
        ScoreObjective objective = this.getObjective(name);
        return Optional.ofNullable(objective == null ? null : ((ScoreObjectiveBridge)objective).bridge$getSpongeObjective());
    }

    @Override
    public Optional<Objective> bridge$getObjective(DisplaySlot slot) {
        ScoreObjective objective = ((ScoreboardAccessor)((Object)this)).accessor$getObjectiveDisplaySlots()[((SpongeDisplaySlot)slot).getIndex()];
        if (objective != null) {
            return Optional.of(((ScoreObjectiveBridge)objective).bridge$getSpongeObjective());
        }
        return Optional.empty();
    }

    @Override
    public Set<Objective> bridge$getObjectivesByCriterion(Criterion criterion) {
        if (((ScoreboardAccessor)((Object)this)).accessor$getScoreObjectiveCriterias().containsKey(criterion)) {
            return ((ScoreboardAccessor)((Object)this)).accessor$getScoreObjectiveCriterias().get(criterion).stream().map(objective -> ((ScoreObjectiveBridge)objective).bridge$getSpongeObjective()).collect(Collectors.toSet());
        }
        return new HashSet<Objective>();
    }

    @Override
    public void bridge$removeObjective(Objective objective) {
        ScoreObjective scoreObjective = ((SpongeObjective)objective).getObjectiveFor(this);
        ((ScoreboardAccessor)((Object)this)).accessor$getScoreObjectives().remove(scoreObjective.getName());
        for (int i = 0; i < 19; ++i) {
            if (this.getObjectiveInDisplaySlot(i) != scoreObjective) continue;
            this.setObjectiveInDisplaySlot(i, null);
        }
        this.bridge$sendToPlayers((IPacket<?>)new SScoreboardObjectivePacket(scoreObjective, 1));
        List<ScoreObjective> list = ((ScoreboardAccessor)((Object)this)).accessor$getScoreObjectiveCriterias().get(scoreObjective.getCriteria());
        if (list != null) {
            list.remove(scoreObjective);
        }
        for (Map<ScoreObjective, Score> scoreMap : ((ScoreboardAccessor)((Object)this)).accessor$getEntitiesScoreObjectives().values()) {
            Score score = scoreMap.remove(scoreObjective);
            if (score == null) continue;
            ((ScoreBridge)score).bridge$getSpongeScore().removeScoreFor(scoreObjective);
        }
        this.shadow$markSaveDataDirty();
        ((SpongeObjective)objective).removeObjectiveFor(this);
    }

    @Override
    public void bridge$registerTeam(Team spongeTeam) {
        ScorePlayerTeam team = (ScorePlayerTeam)spongeTeam;
        if (this.getTeam(spongeTeam.getName()) != null) {
            throw new IllegalArgumentException(String.format("A team with the name '%s' already exists!", spongeTeam.getName()));
        }
        if (((ScorePlayerTeamAccessor)team).accessor$getScoreboard() != null) {
            throw new IllegalArgumentException("The passed in team is already registered to a scoreboard!");
        }
        ((ScorePlayerTeamAccessor)team).accessor$setScoreboard(this);
        ((ScoreboardAccessor)((Object)this)).accessor$getTeams().put(team.getName(), team);
        for (String entry : team.getMembershipCollection()) {
            this.addPlayerToTeam(entry, team);
        }
        this.onTeamAdded(team);
    }

    @Override
    public void bridge$sendToPlayers(IPacket<?> packet) {
        for (ServerPlayerEntity player : this.impl$players) {
            player.connection.sendPacket(packet);
        }
    }

    @Override
    public void bridge$addPlayer(ServerPlayerEntity player, boolean sendPackets) {
        this.impl$players.add(player);
        if (sendPackets) {
            for (ScorePlayerTeam team : this.getTeams()) {
                player.connection.sendPacket((IPacket)new STeamsPacket(team, 0));
            }
            for (ScoreObjective objective : this.getScoreObjectives()) {
                player.connection.sendPacket((IPacket)new SScoreboardObjectivePacket(objective, 0));
                for (int i = 0; i < 19; ++i) {
                    if (this.getObjectiveInDisplaySlot(i) != objective) continue;
                    player.connection.sendPacket((IPacket)new SDisplayObjectivePacket(i, objective));
                }
                for (Score score : this.getSortedScores(objective)) {
                    SUpdateScorePacket packetIn = new SUpdateScorePacket(ServerScoreboard.Action.CHANGE, score.getObjective().getName(), score.getPlayerName(), score.getScorePoints());
                    player.connection.sendPacket((IPacket)packetIn);
                }
            }
        }
    }

    @Override
    public void bridge$removePlayer(ServerPlayerEntity player, boolean sendPackets) {
        this.impl$players.remove(player);
        if (sendPackets) {
            this.impl$removeScoreboard(player);
        }
    }

    public ScoreObjective addObjective(String name, ScoreCriteria criteria, ITextComponent text, ScoreCriteria.RenderType type) {
        SpongeObjective objective = new SpongeObjective(name, (Criterion)criteria);
        objective.setDisplayMode((ObjectiveDisplayMode)type);
        objective.setDisplayName(SpongeAdventure.asAdventure(text));
        ((Scoreboard)((Object)this)).addObjective(objective);
        return objective.getObjectiveFor(this);
    }

    public void removeObjective(ScoreObjective objective) {
        this.bridge$removeObjective(((ScoreObjectiveBridge)objective).bridge$getSpongeObjective());
    }

    public void removeTeam(ScorePlayerTeam team) {
        super.removeTeam(team);
        ((ScorePlayerTeamAccessor)team).accessor$setScoreboard(null);
    }

    public Score getOrCreateScore(String name, ScoreObjective objective) {
        return ((SpongeScore)((ScoreObjectiveBridge)objective).bridge$getSpongeObjective().getOrCreateScore(SpongeAdventure.legacySection(name))).getScoreFor(objective);
    }

    public void removeObjectiveFromEntity(String name, ScoreObjective objective) {
        if (objective != null) {
            SpongeObjective spongeObjective = ((ScoreObjectiveBridge)objective).bridge$getSpongeObjective();
            Optional<org.spongepowered.api.scoreboard.Score> score = spongeObjective.getScore(SpongeAdventure.legacySection(name));
            if (score.isPresent()) {
                spongeObjective.removeScore(score.get());
            } else {
                SpongeCommon.getLogger().warn("Objective {} did have have the score", (Object)name);
            }
        } else {
            Component textName = SpongeAdventure.legacySection(name);
            for (ScoreObjective scoreObjective : this.getScoreObjectives()) {
                ((ScoreObjectiveBridge)scoreObjective).bridge$getSpongeObjective().removeScore(textName);
            }
        }
    }

    @Redirect(method={"onScoreChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/IPacket;)V"))
    private void onUpdateScoreValue(PlayerList manager, IPacket<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onScoreChanged"}, at=@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z", remap=false))
    private boolean onUpdateScoreValue(Set<?> set, Object object) {
        return true;
    }

    @Redirect(method={"onPlayerRemoved"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/IPacket;)V"))
    private void impl$updatePlayersOnRemoval(PlayerList manager, IPacket<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onPlayerScoreRemoved"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/IPacket;)V"))
    private void impl$updatePlayersOnRemovalOfObjective(PlayerList manager, IPacket<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Inject(method={"onObjectiveAdded"}, at={@At(value="RETURN")})
    private void impl$UpdatePlayersScoreObjective(ScoreObjective objective, CallbackInfo ci) {
        this.bridge$sendToPlayers((IPacket<?>)new SScoreboardObjectivePacket(objective, 0));
    }

    @Overwrite
    public void setObjectiveInDisplaySlot(int slot, @Nullable ScoreObjective objective) {
        SpongeObjective apiObjective = objective == null ? null : ((ScoreObjectiveBridge)objective).bridge$getSpongeObjective();
        MappedRegistry registry = (MappedRegistry)((Object)SpongeCommon.getRegistry().getCatalogRegistry().getRegistry(DisplaySlot.class));
        DisplaySlot displaySlot = (DisplaySlot)registry.getReverseMapping(slot);
        this.bridge$updateDisplaySlot(apiObjective, displaySlot);
    }

    @Redirect(method={"addPlayerToTeam"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/IPacket;)V"))
    private void impl$updatePlayersOnPlayerAdd(PlayerList manager, IPacket<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"removePlayerFromTeam"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/IPacket;)V"))
    private void impl$updatePlayersOnPlayerRemoval(PlayerList manager, IPacket<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onObjectiveChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/IPacket;)V"))
    private void impl$updatePlayersOnObjectiveDisplay(PlayerList manager, IPacket<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onObjectiveChanged"}, at=@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z", remap=false))
    private boolean impl$alwaysReturnTrueForObjectivesDisplayName(Set<ScoreObjective> set, Object object) {
        return true;
    }

    @Redirect(method={"onObjectiveRemoved"}, at=@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z", remap=false))
    private boolean impl$alwaysReturnTrueForObjectiveRemoval(Set<ScoreObjective> set, Object object) {
        return true;
    }

    @Redirect(method={"onTeamAdded"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/IPacket;)V"))
    private void impl$updateAllPlayersOnTeamCreation(PlayerList manager, IPacket<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onTeamChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/IPacket;)V"))
    private void impl$updateAllPlayersOnTeamInfo(PlayerList manager, IPacket<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onTeamRemoved"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/IPacket;)V"))
    private void impl$updateAllPlayersOnTeamRemoval(PlayerList manager, IPacket<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"addObjective"}, at=@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;", ordinal=0, remap=false))
    private Iterator impl$useOurScoreboardForPlayers(List list) {
        return this.impl$players.iterator();
    }

    @Redirect(method={"sendDisplaySlotRemovalPackets"}, at=@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;", ordinal=0, remap=false))
    private Iterator impl$useOurScoreboardForPlayersOnRemoval(List list) {
        return this.impl$players.iterator();
    }

    private void impl$removeScoreboard(ServerPlayerEntity player) {
        this.impl$removeTeams(player);
        this.impl$removeObjectives(player);
    }

    private void impl$removeTeams(ServerPlayerEntity player) {
        for (ScorePlayerTeam team : this.getTeams()) {
            player.connection.sendPacket((IPacket)new STeamsPacket(team, 1));
        }
    }

    private void impl$removeObjectives(ServerPlayerEntity player) {
        for (ScoreObjective objective : this.getScoreObjectives()) {
            player.connection.sendPacket((IPacket)new SScoreboardObjectivePacket(objective, 1));
        }
    }
}

