/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server;

import com.google.inject.Injector;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.concurrent.RecursiveEventLoop;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.storage.SessionLockException;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectProxy;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.advancement.SpongeAdvancementProvider;
import org.spongepowered.common.adventure.NativeComponentRenderer;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.command.CommandSourceProviderBridge;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.bridge.server.management.PlayerProfileCacheBridge;
import org.spongepowered.common.bridge.world.storage.WorldInfoBridge;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.recipe.SpongeRecipeProvider;
import org.spongepowered.common.item.recipe.ingredient.ResultUtil;
import org.spongepowered.common.item.recipe.ingredient.SpongeIngredient;
import org.spongepowered.common.registry.SpongeCatalogRegistry;
import org.spongepowered.common.relocate.co.aikar.timings.TimingsManager;
import org.spongepowered.common.resourcepack.SpongeResourcePack;
import org.spongepowered.common.service.server.SpongeServerScopedServiceProvider;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin
extends RecursiveEventLoop<TickDelayedTask>
implements SpongeServer,
MinecraftServerBridge,
CommandSourceProviderBridge,
SubjectProxy {
    @Shadow
    @Final
    protected Thread serverThread;
    @Shadow
    @Final
    private PlayerProfileCache profileCache;
    @Shadow
    @Final
    private static Logger LOGGER;
    @Shadow
    private int tickCounter;
    @Nullable
    private SpongeServerScopedServiceProvider impl$serviceProvider;
    @Nullable
    private ResourcePack impl$resourcePack;

    @Shadow
    public abstract CommandSource shadow$getCommandSource();

    @Shadow
    public abstract Iterable<net.minecraft.world.server.ServerWorld> shadow$getWorlds();

    @Shadow
    public abstract boolean shadow$isDedicatedServer();

    @Shadow
    public abstract boolean shadow$isServerRunning();

    @Shadow
    public abstract PlayerList shadow$getPlayerList();

    public MinecraftServerMixin(String name) {
        super(name);
    }

    @Override
    public Subject getSubject() {
        return SpongeCommon.getGame().getSystemSubject();
    }

    @Inject(method={"startServerThread"}, at={@At(value="HEAD")})
    private void impl$setThreadOnServerPhaseTracker(CallbackInfo ci) {
        try {
            PhaseTracker.SERVER.setThread(this.serverThread);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not initialize the server PhaseTracker!");
        }
    }

    @Inject(method={"setResourcePack(Ljava/lang/String;Ljava/lang/String;)V"}, at={@At(value="HEAD")})
    private void impl$createSpongeResourcePackWrapper(String url, String hash, CallbackInfo ci) {
        if (url.length() == 0) {
            this.impl$resourcePack = null;
        } else {
            try {
                this.impl$resourcePack = SpongeResourcePack.create(url, hash);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ResourcePack bridge$getResourcePack() {
        return this.impl$resourcePack;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void impl$onServerTickStart(CallbackInfo ci) {
        TimingsManager.FULL_SERVER_TICK.startTiming();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void impl$tickServerScheduler(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        this.getScheduler().tick();
    }

    @Override
    public CommandSource bridge$getCommandSource(Cause cause) {
        return this.shadow$getCommandSource();
    }

    @Override
    public void bridge$addToCauseStack(CauseStackManager.StackFrame frame) {
        frame.pushCause(Sponge.getSystemSubject());
    }

    @Inject(method={"save"}, at={@At(value="RETURN")})
    private void impl$saveUsernameCacheOnSave(boolean suppressLog, boolean flush, boolean forced, CallbackInfoReturnable<Boolean> cir) {
        ((PlayerProfileCacheBridge)this.profileCache).bridge$setCanSave(true);
        this.profileCache.save();
        ((PlayerProfileCacheBridge)this.profileCache).bridge$setCanSave(false);
    }

    @Overwrite
    public String getServerModName() {
        return "sponge";
    }

    @ModifyConstant(method={"tick"}, constant={@Constant(intValue=6000, ordinal=0)})
    private int getSaveTickInterval(int tickInterval) throws SessionLockException {
        if (!this.shadow$isDedicatedServer()) {
            return tickInterval;
        }
        if (!this.shadow$isServerRunning()) {
            return this.tickCounter + 1;
        }
        int autoPlayerSaveInterval = SpongeConfigs.getCommon().get().getWorld().getAutoPlayerSaveInterval();
        if (autoPlayerSaveInterval > 0 && this.tickCounter % autoPlayerSaveInterval == 0) {
            this.shadow$getPlayerList().saveAllPlayerData();
        }
        this.save(true, false, false);
        return this.tickCounter + 1;
    }

    @Overwrite
    public boolean save(boolean suppressLog, boolean flush, boolean isForced) throws SessionLockException {
        for (net.minecraft.world.server.ServerWorld world : this.shadow$getWorlds()) {
            boolean log;
            SerializationBehavior serializationBehavior = ((WorldInfoBridge)world.getWorldInfo()).bridge$getSerializationBehavior();
            boolean bl = log = !suppressLog;
            if (!isForced) {
                boolean canSaveAtAll;
                InheritableConfigHandle<WorldConfig> adapter = ((WorldInfoBridge)world.getWorldInfo()).bridge$getConfigAdapter();
                int autoSaveInterval = ((WorldConfig)adapter.get()).getWorld().getAutoSaveInterval();
                if (log && this.bridge$performAutosaveChecks()) {
                    log = ((WorldConfig)adapter.get()).getLogging().logWorldAutomaticSaving();
                }
                if (!this.shadow$isServerRunning() || this.tickCounter % 6000 == 0) {
                    ((WorldInfoBridge)world.getWorldInfo()).bridge$getConfigAdapter().save();
                }
                if (!(canSaveAtAll = serializationBehavior != SerializationBehavior.NONE) || this.bridge$performAutosaveChecks() && (autoSaveInterval <= 0 || serializationBehavior != SerializationBehavior.AUTOMATIC || this.tickCounter % autoSaveInterval != 0)) continue;
                world.save(null, false, world.disableLevelSaving);
                if (!log) continue;
                if (this.bridge$performAutosaveChecks()) {
                    LOGGER.info("Auto-saving data for world '{}'", (Object)((ServerWorld)world).getKey());
                    continue;
                }
                LOGGER.info("Saving data for world '{}'", (Object)((ServerWorld)world).getKey());
                continue;
            }
            if (log) {
                LOGGER.info("Manually saving data for world '{}'", (Object)((ServerWorld)world).getKey());
            }
            ((WorldInfoBridge)world.getWorldInfo()).bridge$getConfigAdapter().save();
            world.save(null, false, world.disableLevelSaving);
        }
        return true;
    }

    @Overwrite
    public void setDifficultyForAllWorlds(Difficulty difficulty, boolean forceDifficulty) {
        for (net.minecraft.world.server.ServerWorld world : this.shadow$getWorlds()) {
            ((SpongeServer)SpongeCommon.getServer()).getWorldManager().adjustWorldForDifficulty(world, difficulty, forceDifficulty);
        }
    }

    @Override
    public void bridge$initServices(Game game, Injector injector) {
        if (this.impl$serviceProvider == null) {
            this.impl$serviceProvider = new SpongeServerScopedServiceProvider(this, game, injector);
            this.impl$serviceProvider.init();
        }
    }

    @ModifyVariable(method={"sendMessage"}, at=@At(value="HEAD"), argsOnly=true)
    private ITextComponent impl$applyTranslation(ITextComponent input) {
        return NativeComponentRenderer.get().render(input.deepCopy(), Locale.getDefault());
    }

    @Override
    public SpongeServerScopedServiceProvider bridge$getServiceProvider() {
        return this.impl$serviceProvider;
    }

    @Inject(method={"reload"}, at={@At(value="INVOKE", target="Lnet/minecraft/resources/ResourcePackList;reloadPacksFromFinders()V")})
    public void impl$reloadPluginRecipes(CallbackInfo ci) {
        SpongeCatalogRegistry catalogRegistry = SpongeCommon.getRegistry().getCatalogRegistry();
        catalogRegistry.registerDatapackCatalogues();
        SpongeIngredient.clearCache();
        ResultUtil.clearCache();
        catalogRegistry.callDataPackRegisterCatalogEvents(Sponge.getServer().getCauseStackManager().getCurrentCause(), Sponge.getGame());
        SpongeRecipeProvider.registerRecipes(catalogRegistry.getRegistry(RecipeRegistration.class));
        SpongeAdvancementProvider.registerAdvancements(catalogRegistry.getRegistry(Advancement.class));
    }
}

