/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.management;

import com.mojang.authlib.GameProfile;
import java.net.SocketAddress;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.server.SDisconnectPacket;
import net.minecraft.network.play.server.SJoinGamePacket;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.CustomServerBossInfoManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.SaveHandler;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.adventure.Audiences;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.living.player.RespawnPlayerEvent;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.ServerPlayerConnection;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.network.play.server.SRespawnPacketAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.LocationTargetingBridge;
import org.spongepowered.common.bridge.entity.player.ServerPlayerEntityBridge;
import org.spongepowered.common.bridge.scoreboard.ServerScoreboardBridge;
import org.spongepowered.common.bridge.server.management.PlayerListBridge;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.server.PerWorldBorderListener;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={PlayerList.class})
public abstract class PlayerListMixin
implements PlayerListBridge {
    @Shadow
    @Final
    private static Logger LOGGER;
    @Shadow
    @Final
    private MinecraftServer server;
    private boolean impl$isBedSpawn = false;
    private DimensionType impl$originalDestination = null;

    @Shadow
    public abstract ITextComponent shadow$canPlayerLogin(SocketAddress var1, GameProfile var2);

    @Shadow
    public abstract MinecraftServer shadow$getServer();

    @Shadow
    @Nullable
    public abstract CompoundNBT shadow$readPlayerDataFromFile(ServerPlayerEntity var1);

    @Override
    public void bridge$setOriginalDestinationDimensionForRespawn(DimensionType dimensionType) {
        this.impl$originalDestination = dimensionType;
    }

    @Redirect(method={"initializeConnectionToPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;readPlayerDataFromFile(Lnet/minecraft/entity/player/ServerPlayerEntity;)Lnet/minecraft/nbt/CompoundNBT;"))
    private CompoundNBT impl$setPlayerDataForNewPlayers(PlayerList playerList, ServerPlayerEntity playerIn) {
        CompoundNBT compound = this.shadow$readPlayerDataFromFile(playerIn);
        if (compound == null) {
            ((SpongeServer)SpongeCommon.getServer()).getPlayerDataManager().setPlayerInfo(playerIn.getUniqueID(), Instant.now(), Instant.now());
        }
        return compound;
    }

    @Redirect(method={"initializeConnectionToPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getWorld(Lnet/minecraft/world/dimension/DimensionType;)Lnet/minecraft/world/server/ServerWorld;"))
    private net.minecraft.world.server.ServerWorld impl$onInitPlayer_getWorld(MinecraftServer server, DimensionType type, NetworkManager networkManager, ServerPlayerEntity mcPlayer) {
        ITextComponent kickReason = this.shadow$canPlayerLogin(networkManager.getRemoteAddress(), mcPlayer.getGameProfile());
        Object disconnectMessage = kickReason != null ? SpongeAdventure.asAdventure(kickReason) : Component.text((String)"You are not allowed to log in to this server.");
        net.minecraft.world.server.ServerWorld mcWorld = server.getWorld(mcPlayer.dimension);
        if (mcWorld == null) {
            SpongeCommon.getLogger().warn("The player '{}' was located in a world that isn't loaded or doesn't exist. This is not safe so the player will be moved to the spawn of the default world.", (Object)mcPlayer.getGameProfile().getName());
            mcPlayer.dimension = DimensionType.OVERWORLD;
            mcWorld = server.getWorld(mcPlayer.dimension);
            BlockPos spawnPoint = mcWorld.getSpawnPoint();
            mcPlayer.setPosition((double)spawnPoint.getX() + 0.5, (double)spawnPoint.getY() + 0.5, (double)spawnPoint.getZ() + 0.5);
        }
        mcPlayer.setWorld((World)mcWorld);
        ServerPlayer player = (ServerPlayer)mcPlayer;
        ServerLocation location = player.getServerLocation();
        Vector3d rotation = player.getRotation();
        ServerSideConnection connection = (ServerSideConnection)networkManager.getNetHandler();
        User user = player.getUser();
        Cause cause = Cause.of(EventContext.empty(), connection, user);
        ServerSideConnectionEvent.Login event = SpongeEventFactory.createServerSideConnectionEventLogin(cause, disconnectMessage, disconnectMessage, location, location, rotation, rotation, connection, user);
        if (kickReason != null) {
            event.setCancelled(true);
        }
        if (SpongeCommon.postEvent(event)) {
            this.impl$disconnectClient(networkManager, event.getMessage(), player.getProfile());
            return null;
        }
        ServerLocation toLocation = event.getToLocation();
        Vector3d toRotation = event.getToRotation();
        mcPlayer.setPositionAndRotation(toLocation.getX(), toLocation.getY(), toLocation.getZ(), (float)toRotation.getY(), (float)toRotation.getX());
        return (net.minecraft.world.server.ServerWorld)toLocation.getWorld();
    }

    @Inject(method={"initializeConnectionToPlayer"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;setWorld(Lnet/minecraft/world/World;)V", shift=At.Shift.AFTER)})
    private void impl$onInitPlayer_BeforeSetWorld(NetworkManager networkManager, ServerPlayerEntity mcPlayer, CallbackInfo ci) {
        if (mcPlayer.world == null) {
            ci.cancel();
        }
    }

    @Redirect(method={"initializeConnectionToPlayer"}, at=@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;info(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", remap=false))
    private void impl$onInitPlayer_printPlayerWorldInJoinFeedback(Logger logger, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, NetworkManager manager, ServerPlayerEntity entity) {
        logger.info("{}[{}] logged in to world '{}' with entity id {} at ({}, {}, {})", p0, p1, (Object)((ServerWorld)entity.getServerWorld()).getKey(), p2, p3, p4, p5);
    }

    @Redirect(method={"initializeConnectionToPlayer"}, at=@At(value="NEW", target="net/minecraft/network/play/server/SJoinGamePacket"))
    private SJoinGamePacket impl$onInitPlayer_sendFakeDimensionTypeForVanillaClient(int entityId, GameType gameType, long seed, boolean hardcoreMode, DimensionType dimensionType, int maxPlayers, WorldType worldType, int viewDistance, boolean reducedDebugInfo, boolean enableRespawnScreen, NetworkManager manager, ServerPlayerEntity entity) {
        ((ServerPlayerEntityBridge)entity).bridge$sendDimensionData(manager, dimensionType);
        return PlatformHooks.getInstance().getPacketHooks().createSJoinGamePacket(entity, gameType, seed, hardcoreMode, dimensionType, maxPlayers, worldType, viewDistance, reducedDebugInfo, enableRespawnScreen);
    }

    @Redirect(method={"initializeConnectionToPlayer"}, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;refreshStatusNextTick()V"), to=@At(value="FIELD", opcode=178, target="Lnet/minecraft/util/text/TextFormatting;YELLOW:Lnet/minecraft/util/text/TextFormatting;")), at=@At(value="INVOKE", target="Ljava/lang/String;equalsIgnoreCase(Ljava/lang/String;)Z"))
    private boolean impl$onInitPlayer_dontClassSpongeNameAsModified(String currentName, String originalName) {
        if (originalName.equals("[sponge]")) {
            return true;
        }
        return currentName.equalsIgnoreCase(originalName);
    }

    @Redirect(method={"initializeConnectionToPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendMessage(Lnet/minecraft/util/text/ITextComponent;)V"))
    private void impl$onInitPlayer_delaySendMessage(PlayerList playerList, ITextComponent message, NetworkManager netManager, ServerPlayerEntity playerIn) {
        ((ServerPlayerEntityBridge)playerIn).bridge$setConnectionMessageToSend(message);
    }

    @Inject(method={"initializeConnectionToPlayer"}, at={@At(value="RETURN")})
    private void impl$onInitPlayer_join(NetworkManager networkManager, ServerPlayerEntity mcPlayer, CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)mcPlayer;
        ServerPlayerConnection connection = player.getConnection();
        Cause cause = Cause.of(EventContext.empty(), connection, player);
        Audience audience = Audiences.onlinePlayers();
        Component joinComponent = SpongeAdventure.asAdventure(((ServerPlayerEntityBridge)mcPlayer).bridge$getConnectionMessageToSend());
        ServerSideConnectionEvent.Join event = SpongeEventFactory.createServerSideConnectionEventJoin(cause, audience, Optional.of(audience), joinComponent, joinComponent, connection, player, false);
        SpongeCommon.postEvent(event);
        if (!event.isMessageCancelled()) {
            event.getAudience().ifPresent(audience1 -> audience1.sendMessage(Identity.nil(), event.getMessage()));
        }
        ((ServerPlayerEntityBridge)mcPlayer).bridge$setConnectionMessageToSend(null);
    }

    @Redirect(method={"initializeConnectionToPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getCustomBossEvents()Lnet/minecraft/server/CustomServerBossInfoManager;"))
    private CustomServerBossInfoManager impl$getPerWorldBossBarManager(MinecraftServer minecraftServer, NetworkManager netManager, ServerPlayerEntity playerIn) {
        return ((ServerWorldBridge)playerIn.getServerWorld()).bridge$getBossBarManager();
    }

    @Redirect(method={"playerLoggedOut"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getCustomBossEvents()Lnet/minecraft/server/CustomServerBossInfoManager;"))
    private CustomServerBossInfoManager impl$getPerWorldBossBarManager(MinecraftServer minecraftServer, ServerPlayerEntity playerIn) {
        return ((ServerWorldBridge)playerIn.getServerWorld()).bridge$getBossBarManager();
    }

    @Redirect(method={"initializeConnectionToPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendScoreboard(Lnet/minecraft/scoreboard/ServerScoreboard;Lnet/minecraft/entity/player/ServerPlayerEntity;)V"))
    private void impl$sendScoreboard(PlayerList playerList, ServerScoreboard scoreboardIn, ServerPlayerEntity playerIn) {
        ((ServerPlayerEntityBridge)playerIn).bridge$initScoreboard();
    }

    @Inject(method={"playerLoggedOut"}, at={@At(value="HEAD")})
    private void impl$RemovePlayerReferenceFromScoreboard(ServerPlayerEntity player, CallbackInfo ci) {
        ((ServerScoreboardBridge)((Object)((ServerPlayer)player).getScoreboard())).bridge$removePlayer(player, false);
    }

    @Redirect(method={"func_212504_a"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;getSaveHandler()Lnet/minecraft/world/storage/SaveHandler;"))
    private SaveHandler impl$onlyUseOverworldForPlayerData(net.minecraft.world.server.ServerWorld serverWorld) {
        if (serverWorld.dimension.getType() == DimensionType.OVERWORLD) {
            return serverWorld.getSaveHandler();
        }
        return SpongeCommon.getServer().getWorld(DimensionType.OVERWORLD).getSaveHandler();
    }

    @Redirect(method={"func_212504_a"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/border/WorldBorder;addListener(Lnet/minecraft/world/border/IBorderListener;)V"))
    private void impl$usePerWorldBorderListener(WorldBorder worldBorder, IBorderListener listener, net.minecraft.world.server.ServerWorld serverWorld) {
        worldBorder.addListener((IBorderListener)new PerWorldBorderListener(serverWorld));
    }

    @Redirect(method={"readPlayerDataFromFile"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;read(Lnet/minecraft/nbt/CompoundNBT;)V"))
    private void impl$setSpongePlayerDataForSinglePlayer(ServerPlayerEntity entity, CompoundNBT compound) {
        entity.read(compound);
        ((SpongeServer)this.shadow$getServer()).getPlayerDataManager().readPlayerData(compound, entity.getUniqueID(), null);
    }

    @Redirect(method={"recreatePlayerEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;setRespawnPosition(Lnet/minecraft/util/math/BlockPos;ZZ)V"))
    private void impl$flagIfRespawnLocationIsBed(ServerPlayerEntity serverPlayerEntity, BlockPos p_226560_1_, boolean p_226560_2_, boolean p_226560_3_) {
        this.impl$isBedSpawn = true;
        serverPlayerEntity.setRespawnPosition(p_226560_1_, p_226560_2_, p_226560_3_);
    }

    @Redirect(method={"recreatePlayerEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/play/ServerPlayNetHandler;sendPacket(Lnet/minecraft/network/IPacket;)V", ordinal=1))
    private void impl$callRespawnPlayerRecreateEvent(ServerPlayNetHandler serverPlayNetHandler, IPacket<?> packetIn, ServerPlayerEntity originalPlayer, DimensionType dimension, boolean conqueredEnd) {
        ServerPlayerEntity recreatedPlayer = serverPlayNetHandler.player;
        Vector3d originalPosition = VecHelper.toVector3d(originalPlayer.getPosition());
        Vector3d destinationPosition = VecHelper.toVector3d(recreatedPlayer.getPositionVec());
        ServerWorld originalWorld = (ServerWorld)originalPlayer.world;
        ServerWorld originalDestinationWorld = (ServerWorld)this.server.getWorld(this.impl$originalDestination == null ? DimensionType.OVERWORLD : this.impl$originalDestination);
        ServerWorld destinationWorld = (ServerWorld)recreatedPlayer.world;
        RespawnPlayerEvent.Recreate event = SpongeEventFactory.createRespawnPlayerEventRecreate(PhaseTracker.getCauseStackManager().getCurrentCause(), destinationPosition, originalWorld, originalPosition, destinationWorld, originalDestinationWorld, destinationPosition, (ServerPlayer)originalPlayer, (ServerPlayer)recreatedPlayer, this.impl$isBedSpawn, !conqueredEnd);
        SpongeCommon.postEvent(event);
        recreatedPlayer.setPosition(event.getDestinationPosition().getX(), event.getDestinationPosition().getY(), event.getDestinationPosition().getZ());
        this.impl$isBedSpawn = false;
        this.impl$originalDestination = null;
        ((ServerPlayerEntityBridge)recreatedPlayer).bridge$sendDimensionData(serverPlayNetHandler.netManager, dimension);
        ((ServerPlayerEntityBridge)recreatedPlayer).bridge$sendChangeDimension(((SRespawnPacketAccessor)packetIn).accessor$getDimensionType(), ((SRespawnPacketAccessor)packetIn).accessor$getHashedSeed(), ((SRespawnPacketAccessor)packetIn).accessor$getWorldType(), recreatedPlayer.interactionManager.getGameType());
    }

    @Redirect(method={"sendWorldInfo"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getWorld(Lnet/minecraft/world/dimension/DimensionType;)Lnet/minecraft/world/server/ServerWorld;"))
    private net.minecraft.world.server.ServerWorld impl$usePerWorldWorldBorder(MinecraftServer minecraftServer, DimensionType dimension, ServerPlayerEntity playerIn, net.minecraft.world.server.ServerWorld worldIn) {
        return worldIn;
    }

    @Redirect(method={"sendWorldInfo"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;getSpawnPoint()Lnet/minecraft/util/math/BlockPos;"))
    private BlockPos impl$resetTargetedLocationData(net.minecraft.world.server.ServerWorld serverWorld, ServerPlayerEntity playerIn) {
        ((LocationTargetingBridge)playerIn).bridge$setTargetedPosition(null);
        return serverWorld.getSpawnPoint();
    }

    private void impl$disconnectClient(NetworkManager netManager, Component disconnectMessage, @Nullable org.spongepowered.api.profile.GameProfile profile) {
        ITextComponent reason = SpongeAdventure.asVanilla(disconnectMessage);
        try {
            LOGGER.info("Disconnecting " + (profile != null ? profile.toString() + " (" + netManager.getRemoteAddress().toString() + ")" : netManager.getRemoteAddress() + ": " + reason.getUnformattedComponentText()));
            netManager.sendPacket((IPacket)new SDisconnectPacket(reason));
            netManager.closeChannel(reason);
        }
        catch (Exception exception) {
            LOGGER.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }
}

