/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.tileentity;

import java.util.Collections;
import java.util.Optional;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import org.spongepowered.api.block.entity.carrier.furnace.FurnaceBlockEntity;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.entity.SmeltEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.cooking.CookingRecipe;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.tileentity.LockableTileEntityMixin;

@Mixin(value={AbstractFurnaceTileEntity.class})
public abstract class AbstractFurnaceTileEntityMixin
extends LockableTileEntityMixin {
    @Shadow
    protected NonNullList<ItemStack> items;
    @Shadow
    private int cookTime;
    @Shadow
    private int burnTime;
    @Shadow
    @Final
    protected IRecipeType<? extends AbstractCookingRecipe> recipeType;

    @Shadow
    protected abstract boolean shadow$canSmelt(IRecipe<?> var1);

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;shrink(I)V"))
    private void impl$throwFuelEventIfOrShrink(ItemStack itemStack, int quantity) {
        Cause cause = PhaseTracker.getCauseStackManager().getCurrentCause();
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf(itemStack);
        ItemStackSnapshot shrinkedFuel = ItemStackUtil.snapshotOf(ItemStackUtil.cloneDefensive(itemStack, itemStack.getCount() - 1));
        Transaction<ItemStackSnapshot> transaction = new Transaction<ItemStackSnapshot>(fuel, shrinkedFuel);
        AbstractCookingRecipe recipe = this.impl$getCurrentRecipe();
        SmeltEvent.ConsumeFuel event = SpongeEventFactory.createSmeltEventConsumeFuel(cause, fuel, (FurnaceBlockEntity)((Object)this), Optional.of((CookingRecipe)recipe), Collections.singletonList(transaction));
        SpongeCommon.postEvent(event);
        if (event.isCancelled()) {
            this.burnTime = 0;
            return;
        }
        if (!transaction.isValid()) {
            return;
        }
        if (transaction.getCustom().isPresent()) {
            this.items.set(1, (Object)ItemStackUtil.fromSnapshotToNative(transaction.getFinal()));
        } else {
            itemStack.shrink(quantity);
        }
    }

    private AbstractCookingRecipe impl$getCurrentRecipe() {
        return this.world.getRecipeManager().getRecipe(this.recipeType, (IInventory)((AbstractFurnaceTileEntity)this), this.world).orElse(null);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/AbstractFurnaceTileEntity;canSmelt(Lnet/minecraft/item/crafting/IRecipe;)Z", ordinal=1))
    private boolean impl$checkIfCanSmelt(AbstractFurnaceTileEntity furnace, IRecipe<?> recipe) {
        if (!this.shadow$canSmelt(recipe)) {
            return false;
        }
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((ItemStack)this.items.get(1));
        Cause cause = PhaseTracker.getCauseStackManager().getCurrentCause();
        if (this.cookTime == 0) {
            SmeltEvent.Start event = SpongeEventFactory.createSmeltEventStart(cause, fuel, (FurnaceBlockEntity)((Object)this), Optional.of((CookingRecipe)recipe), Collections.emptyList());
            SpongeCommon.postEvent(event);
            return !event.isCancelled();
        }
        SmeltEvent.Tick event = SpongeEventFactory.createSmeltEventTick(cause, fuel, (FurnaceBlockEntity)((Object)this), Optional.of((CookingRecipe)recipe), Collections.emptyList());
        SpongeCommon.postEvent(event);
        return !event.isCancelled();
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;clamp(III)I"))
    private int impl$resetCookTimeIfCancelled(int newCookTime, int zero, int totalCookTime) {
        int clampedCookTime = MathHelper.clamp((int)newCookTime, (int)zero, (int)totalCookTime);
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((ItemStack)this.items.get(1));
        Cause cause = PhaseTracker.getCauseStackManager().getCurrentCause();
        AbstractCookingRecipe recipe = this.impl$getCurrentRecipe();
        SmeltEvent.Tick event = SpongeEventFactory.createSmeltEventTick(cause, fuel, (FurnaceBlockEntity)((Object)this), Optional.of((CookingRecipe)recipe), Collections.emptyList());
        SpongeCommon.postEvent(event);
        if (event.isCancelled()) {
            return this.cookTime;
        }
        return clampedCookTime;
    }

    @Inject(method={"setInventorySlotContents"}, at={@At(value="INVOKE", target="Lnet/minecraft/tileentity/AbstractFurnaceTileEntity;getCookTime()I")})
    private void impl$interruptSmelt(CallbackInfo ci) {
        this.impl$callInteruptSmeltEvent();
    }

    @Inject(method={"tick"}, at={@At(shift=At.Shift.BEFORE, value="FIELD", opcode=181, target="Lnet/minecraft/tileentity/AbstractFurnaceTileEntity;cookTime:I")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/tileentity/AbstractFurnaceTileEntity;smelt(Lnet/minecraft/item/crafting/IRecipe;)V"), to=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;clamp(III)I"))})
    private void impl$onResetCookTimePassive(CallbackInfo ci) {
        this.impl$callInteruptSmeltEvent();
    }

    private void impl$callInteruptSmeltEvent() {
        if (this.cookTime > 0) {
            ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((ItemStack)this.items.get(1));
            Cause cause = PhaseTracker.getCauseStackManager().getCurrentCause();
            AbstractCookingRecipe recipe = this.impl$getCurrentRecipe();
            SmeltEvent.Interrupt event = SpongeEventFactory.createSmeltEventInterrupt(cause, fuel, (FurnaceBlockEntity)((Object)this), Optional.ofNullable((CookingRecipe)recipe));
            SpongeCommon.postEvent(event);
        }
    }

    @Inject(method={"smelt"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;shrink(I)V")})
    private void impl$afterSmeltItem(IRecipe<?> recipe, CallbackInfo ci) {
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((ItemStack)this.items.get(1));
        Cause cause = PhaseTracker.getCauseStackManager().getCurrentCause();
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(recipe.getRecipeOutput());
        SmeltEvent.Finish event = SpongeEventFactory.createSmeltEventFinish(cause, fuel, (FurnaceBlockEntity)((Object)this), Optional.ofNullable((CookingRecipe)recipe), Collections.singletonList(snapshot));
        SpongeCommon.postEvent(event);
    }
}

