/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.tileentity;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.tileentity.SkullTileEntityBridge;
import org.spongepowered.common.profile.SpongeGameProfile;

@Mixin(value={SkullTileEntity.class})
public abstract class SkullTileEntityMixin
extends TileEntity
implements ITickableTileEntity,
SkullTileEntityBridge {
    @Shadow
    private com.mojang.authlib.GameProfile playerProfile;
    private @Nullable CompletableFuture<?> impl$currentProfileFuture;

    public SkullTileEntityMixin(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    private void cancelResolveFuture() {
        if (this.impl$currentProfileFuture != null) {
            this.impl$currentProfileFuture.cancel(true);
            this.impl$currentProfileFuture = null;
        }
    }

    @Override
    public void bridge$setUnresolvedPlayerProfile(@Nullable com.mojang.authlib.GameProfile mcProfile) {
        this.cancelResolveFuture();
        this.playerProfile = mcProfile;
        this.markDirty();
    }

    @Redirect(method={"updatePlayerProfile()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/SkullTileEntity;updateGameProfile(Lcom/mojang/authlib/GameProfile;)Lcom/mojang/authlib/GameProfile;"))
    private com.mojang.authlib.GameProfile onUpdateProfile(com.mojang.authlib.GameProfile input) {
        this.cancelResolveFuture();
        if (input == null) {
            return null;
        }
        if (input.isComplete() && input.getProperties().containsKey((Object)"textures")) {
            return input;
        }
        GameProfileManager manager = Sponge.getServer().getGameProfileManager();
        CompletableFuture<GameProfile> future = null;
        if (input.getId() != null) {
            future = manager.getProfile(input.getId());
        } else if (!StringUtils.isNullOrEmpty((String)input.getName())) {
            future = manager.getProfile(input.getName());
        }
        if (future == null) {
            return input;
        }
        future.thenAcceptAsync(profile -> {
            this.playerProfile = SpongeGameProfile.toMcProfile(profile);
            this.markDirty();
        }, (Executor)SpongeCommon.getServer());
        this.impl$currentProfileFuture = future;
        return input;
    }

    public void remove() {
        super.remove();
        this.cancelResolveFuture();
    }
}

