/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.util.text;

import java.util.ArrayList;
import net.kyori.adventure.text.BlockNBTComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.EntityNBTComponent;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.NBTTextComponent;
import net.minecraft.util.text.ScoreTextComponent;
import net.minecraft.util.text.SelectorTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.util.text.StyleBridge;
import org.spongepowered.common.bridge.util.text.TextComponentBridge;

@Mixin(value={TextComponent.class})
public class TextComponentMixin
implements TextComponentBridge {
    private Component bridge$adventureComponent;

    @Override
    public Component bridge$asAdventureComponent() {
        if (this.bridge$adventureComponent == null) {
            TranslationTextComponent $this;
            TextComponent.Builder builder = null;
            if (this instanceof StringTextComponent) {
                builder = Component.text().content(((StringTextComponent)this).getText());
            } else if (this instanceof TranslationTextComponent) {
                $this = (TranslationTextComponent)this;
                ArrayList<Object> with = new ArrayList<Object>($this.getFormatArgs().length);
                for (Object arg : $this.getFormatArgs()) {
                    if (arg instanceof ITextComponent) {
                        with.add(SpongeAdventure.asAdventure((ITextComponent)arg));
                        continue;
                    }
                    with.add(Component.text((String)arg.toString()));
                }
                builder = Component.translatable().key($this.getKey()).args((ComponentLike[])with.toArray(new Component[0]));
            } else if (this instanceof KeybindTextComponent) {
                builder = Component.keybind().keybind(((KeybindTextComponent)this).getKeybind());
            } else if (this instanceof ScoreTextComponent) {
                $this = (ScoreTextComponent)this;
                builder = Component.score().name($this.getName()).objective($this.getObjective()).value($this.getUnformattedComponentText());
            } else if (this instanceof SelectorTextComponent) {
                builder = Component.selector().pattern(((SelectorTextComponent)this).getSelector());
            } else if (this instanceof NBTTextComponent) {
                if (this instanceof NBTTextComponent.Block) {
                    $this = (NBTTextComponent.Block)this;
                    builder = ((BlockNBTComponent.Builder)Component.blockNBT().pos(BlockNBTComponent.Pos.fromString((String)$this.func_218683_k())).nbtPath($this.func_218676_i())).interpret($this.func_218677_j());
                } else if (this instanceof NBTTextComponent.Entity) {
                    $this = (NBTTextComponent.Entity)this;
                    builder = ((EntityNBTComponent.Builder)((EntityNBTComponent.Builder)Component.entityNBT().nbtPath($this.func_218676_i())).interpret($this.func_218677_j())).selector($this.func_218687_k());
                }
            } else {
                throw new UnsupportedOperationException();
            }
            for (ITextComponent child : ((ITextComponent)this).getSiblings()) {
                builder.append(SpongeAdventure.asAdventure(child));
            }
            builder.style(((StyleBridge)((ITextComponent)this).getStyle()).bridge$asAdventure());
            this.bridge$adventureComponent = builder.build();
        }
        return this.bridge$adventureComponent;
    }

    @Override
    public @Nullable Component bridge$adventureComponentIfPresent() {
        return this.bridge$adventureComponent;
    }
}

