/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.BossInfoBridge;

@Mixin(value={BossInfo.class})
public abstract class BossInfoMixin
implements BossInfoBridge {
    @Shadow
    protected ITextComponent name;
    @Shadow
    protected float percent;
    @Shadow
    protected BossInfo.Color color;
    @Shadow
    protected BossInfo.Overlay overlay;
    @Shadow
    protected boolean createFog;
    @Shadow
    protected boolean darkenSky;
    @Shadow
    protected boolean playEndBossMusic;
    protected BossBar impl$adventure;

    @Override
    public void bridge$copyAndAssign(BossBar adventure) {
        this.impl$adventure = adventure;
        this.percent = adventure.percent();
        this.darkenSky = adventure.hasFlag(BossBar.Flag.DARKEN_SCREEN);
        this.playEndBossMusic = adventure.hasFlag(BossBar.Flag.PLAY_BOSS_MUSIC);
        this.createFog = adventure.hasFlag(BossBar.Flag.CREATE_WORLD_FOG);
    }

    @Override
    public BossBar bridge$asAdventure() {
        if (this.impl$adventure == null) {
            this.bridge$setAdventure(BossBar.bossBar((Component)SpongeAdventure.asAdventure(this.name), (float)this.percent, (BossBar.Color)SpongeAdventure.asAdventure(this.color), (BossBar.Overlay)SpongeAdventure.asAdventure(this.overlay), SpongeAdventure.asAdventureFlags(this.darkenSky, this.playEndBossMusic, this.createFog)));
        }
        return this.impl$adventure;
    }

    @Override
    public void bridge$setAdventure(BossBar adventure) {
        this.impl$adventure = adventure;
    }

    @Override
    public void bridge$replacePlayer(ServerPlayerEntity oldPlayer, ServerPlayerEntity newPlayer) {
    }

    @Redirect(method={"setName"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;name:Lnet/minecraft/util/text/ITextComponent;"))
    private void adventureName(BossInfo $this, ITextComponent name) {
        this.bridge$asAdventure().name(SpongeAdventure.asAdventure(name));
    }

    @Redirect(method={"setPercent"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;percent:F"))
    private void adventurePercent(BossInfo $this, float percent) {
        this.bridge$asAdventure().percent(percent);
    }

    @Redirect(method={"setColor"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;color:Lnet/minecraft/world/BossInfo$Color;"))
    private void adventureColor(BossInfo $this, BossInfo.Color color) {
        this.bridge$asAdventure().color(SpongeAdventure.asAdventure(color));
    }

    @Redirect(method={"setOverlay"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;overlay:Lnet/minecraft/world/BossInfo$Overlay;"))
    private void adventureOverlay(BossInfo $this, BossInfo.Overlay overlay) {
        this.bridge$asAdventure().overlay(SpongeAdventure.asAdventure(overlay));
    }

    @Redirect(method={"setDarkenSky"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;darkenSky:Z"))
    private void adventureDarkenSky(BossInfo $this, boolean playEndBossMusic) {
        if (playEndBossMusic) {
            this.bridge$asAdventure().addFlag(BossBar.Flag.DARKEN_SCREEN);
        } else {
            this.bridge$asAdventure().removeFlag(BossBar.Flag.DARKEN_SCREEN);
        }
    }

    @Redirect(method={"setPlayEndBossMusic"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;playEndBossMusic:Z"))
    private void adventurePlayEndBossMusic(BossInfo $this, boolean playEndBossMusic) {
        if (playEndBossMusic) {
            this.bridge$asAdventure().addFlag(BossBar.Flag.PLAY_BOSS_MUSIC);
        } else {
            this.bridge$asAdventure().removeFlag(BossBar.Flag.PLAY_BOSS_MUSIC);
        }
    }

    @Redirect(method={"setCreateFog"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;createFog:Z"))
    private void adventureCreateFog(BossInfo $this, boolean createFog) {
        if (createFog) {
            this.bridge$asAdventure().addFlag(BossBar.Flag.CREATE_WORLD_FOG);
        } else {
            this.bridge$asAdventure().removeFlag(BossBar.Flag.CREATE_WORLD_FOG);
        }
    }

    @Redirect(method={"getName"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;name:Lnet/minecraft/util/text/ITextComponent;"))
    private ITextComponent nameRead(BossInfo $this) {
        return SpongeAdventure.asVanilla(this.bridge$asAdventure().name());
    }

    @Redirect(method={"getPercent"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;percent:F"))
    private float percentRead(BossInfo $this) {
        return this.bridge$asAdventure().percent();
    }

    @Redirect(method={"getColor"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;color:Lnet/minecraft/world/BossInfo$Color;"))
    private BossInfo.Color colorRead(BossInfo $this) {
        return SpongeAdventure.asVanilla(this.bridge$asAdventure().color());
    }

    @Redirect(method={"getOverlay"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;overlay:Lnet/minecraft/world/BossInfo$Overlay;"))
    private BossInfo.Overlay overlayRead(BossInfo $this) {
        return SpongeAdventure.asVanilla(this.bridge$asAdventure().overlay());
    }

    @Redirect(method={"shouldDarkenSky"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;darkenSky:Z"))
    private boolean darkenSkyRead(BossInfo $this) {
        return this.bridge$asAdventure().hasFlag(BossBar.Flag.DARKEN_SCREEN);
    }

    @Redirect(method={"shouldPlayEndBossMusic"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;playEndBossMusic:Z"))
    private boolean playEndBossMusicRead(BossInfo $this) {
        return this.bridge$asAdventure().hasFlag(BossBar.Flag.PLAY_BOSS_MUSIC);
    }

    @Redirect(method={"shouldCreateFog"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;createFog:Z"))
    private boolean createFogRead(BossInfo $this) {
        return this.bridge$asAdventure().hasFlag(BossBar.Flag.CREATE_WORLD_FOG);
    }
}

