/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import net.minecraft.world.Difficulty;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.world.WorldSettingsBridge;
import org.spongepowered.common.bridge.world.storage.WorldInfoBridge;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.world.dimension.SpongeDimensionType;

@Mixin(value={WorldSettings.class})
public abstract class WorldSettingsMixin
implements ResourceKeyBridge,
WorldSettingsBridge {
    @Shadow
    private boolean commandsAllowed;
    @Shadow
    private boolean bonusChestEnabled;
    private ResourceKey impl$key;
    private SpongeDimensionType impl$logicType;
    private Difficulty impl$difficulty;
    private SerializationBehavior impl$serializationBehavior = SerializationBehavior.AUTOMATIC;
    private DataContainer impl$generatorSettings = DataContainer.createNew();
    private boolean impl$isEnabled = true;
    private boolean impl$loadOnStartup = true;
    private boolean impl$keepSpawnLoaded = true;
    private boolean impl$generateSpawnOnLoad = true;
    private boolean impl$pvpEnabled = true;
    private boolean impl$seedRandomized = false;
    private InheritableConfigHandle<WorldConfig> impl$configAdapter;
    private boolean impl$configExists = false;

    @Override
    public ResourceKey bridge$getKey() {
        return this.impl$key;
    }

    @Override
    public void bridge$setKey(ResourceKey key) {
        this.impl$key = key;
    }

    @Override
    public boolean bridge$isSeedRandomized() {
        return this.impl$seedRandomized;
    }

    @Override
    public void bridge$setRandomSeed(boolean state) {
        this.impl$seedRandomized = state;
    }

    @Override
    public SpongeDimensionType bridge$getLogicType() {
        return this.impl$logicType;
    }

    @Override
    public Difficulty bridge$getDifficulty() {
        return this.impl$difficulty;
    }

    @Override
    public DataContainer bridge$getGeneratorSettings() {
        return this.impl$generatorSettings;
    }

    @Override
    public SerializationBehavior bridge$getSerializationBehavior() {
        return this.impl$serializationBehavior;
    }

    @Override
    public boolean bridge$isEnabled() {
        return this.impl$isEnabled;
    }

    @Override
    public boolean bridge$loadOnStartup() {
        return this.impl$loadOnStartup;
    }

    @Override
    public boolean bridge$doesKeepSpawnLoaded() {
        return this.impl$keepSpawnLoaded;
    }

    @Override
    public boolean bridge$generateSpawnOnLoad() {
        return this.impl$generateSpawnOnLoad;
    }

    @Override
    public boolean bridge$isPVPEnabled() {
        return this.impl$pvpEnabled;
    }

    @Override
    public void bridge$setLogicType(SpongeDimensionType dimensionType) {
        this.impl$logicType = dimensionType;
    }

    @Override
    public void bridge$setDifficulty(Difficulty difficulty) {
        this.impl$difficulty = difficulty;
    }

    @Override
    public void bridge$setSerializationBehavior(SerializationBehavior behavior) {
        this.impl$serializationBehavior = behavior;
    }

    @Override
    public void bridge$setGeneratorSettings(DataContainer generatorSettings) {
    }

    @Override
    public void bridge$setEnabled(boolean state) {
        this.impl$isEnabled = state;
    }

    @Override
    public void bridge$setLoadOnStartup(boolean state) {
        this.impl$loadOnStartup = state;
    }

    @Override
    public void bridge$setKeepSpawnLoaded(@Nullable Boolean state) {
        this.impl$keepSpawnLoaded = state;
    }

    @Override
    public void bridge$setGenerateSpawnOnLoad(boolean state) {
        this.impl$generateSpawnOnLoad = state;
    }

    @Override
    public void bridge$setPVPEnabled(boolean state) {
        this.impl$pvpEnabled = state;
    }

    @Override
    public void bridge$setCommandsEnabled(boolean state) {
        this.commandsAllowed = state;
    }

    @Override
    public void bridge$setGenerateBonusChest(boolean state) {
        this.bonusChestEnabled = state;
    }

    @Override
    public void bridge$setInfoConfigAdapter(InheritableConfigHandle<WorldConfig> configAdapter) {
        this.impl$configAdapter = configAdapter;
    }

    @Override
    public void bridge$setConfigExists(boolean configExists) {
        this.impl$configExists = configExists;
    }

    @Override
    public void bridge$populateInfo(WorldInfo info) {
        WorldInfoBridge infoBridge = (WorldInfoBridge)info;
        if (infoBridge.bridge$isSinglePlayerProperties()) {
            return;
        }
        if (this.impl$configAdapter != null) {
            infoBridge.bridge$setConfigAdapter(this.impl$configAdapter);
            this.impl$configAdapter = null;
        }
        if (this.impl$configExists) {
            this.impl$configExists = false;
            return;
        }
        infoBridge.bridge$setEnabled(this.impl$isEnabled);
        infoBridge.bridge$setLogicType(this.impl$logicType, false);
        infoBridge.bridge$setLoadOnStartup(this.impl$loadOnStartup);
        infoBridge.bridge$setGenerateSpawnOnLoad(this.impl$generateSpawnOnLoad);
        infoBridge.bridge$setKeepSpawnLoaded(this.impl$keepSpawnLoaded);
        infoBridge.bridge$setGenerateBonusChest(this.bonusChestEnabled);
        infoBridge.bridge$setSerializationBehavior(this.impl$serializationBehavior);
        infoBridge.bridge$forceSetDifficulty(this.impl$difficulty);
        infoBridge.bridge$setPVPEnabled(this.impl$pvpEnabled);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/storage/WorldInfo;)V"}, at={@At(value="RETURN")})
    private void impl$populateSettings(WorldInfo info, CallbackInfo ci) {
        if (!((WorldInfoBridge)info).bridge$isValid()) {
            return;
        }
        WorldProperties properties = (WorldProperties)info;
        this.impl$isEnabled = properties.isEnabled();
        this.impl$logicType = (SpongeDimensionType)properties.getDimensionType();
        this.impl$loadOnStartup = properties.doesLoadOnStartup();
        this.impl$generateSpawnOnLoad = properties.doesGenerateSpawnOnLoad();
        this.impl$keepSpawnLoaded = properties.doesKeepSpawnLoaded();
        this.bonusChestEnabled = properties.doesGenerateBonusChest();
        this.impl$serializationBehavior = properties.getSerializationBehavior();
        this.impl$difficulty = (Difficulty)properties.getDifficulty();
        this.impl$pvpEnabled = properties.isPVPEnabled();
        this.impl$generatorSettings = properties.getGeneratorSettings().copy();
    }

    @Inject(method={"setGeneratorOptions"}, at={@At(value="RETURN")})
    private void impl$onSetGeneratorOptions(JsonElement element, CallbackInfoReturnable<WorldSettings> cir) {
    }
}

