/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.CustomServerBossInfoManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.storage.SessionLockException;
import org.spongepowered.api.Server;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.Weathers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.server.ChunkManagerAccessor;
import org.spongepowered.common.accessor.world.server.ServerChunkProviderAccessor;
import org.spongepowered.common.bridge.entity.player.ServerPlayerEntityBridge;
import org.spongepowered.common.bridge.world.PlatformServerWorldBridge;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.bridge.world.storage.WorldInfoBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.mixin.core.world.WorldMixin;
import org.spongepowered.common.world.dimension.SpongeDimensionType;
import org.spongepowered.common.world.server.SpongeWorldManager;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={net.minecraft.world.server.ServerWorld.class})
public abstract class ServerWorldMixin
extends WorldMixin
implements ServerWorldBridge,
PlatformServerWorldBridge {
    private CustomServerBossInfoManager impl$bossBarManager;
    private boolean impl$isManualSave = false;
    private final Map<Entity, Vector3d> impl$rotationUpdates = new HashMap<Entity, Vector3d>();

    @Shadow
    @Nonnull
    public abstract MinecraftServer shadow$getServer();

    @Shadow
    public abstract List<ServerPlayerEntity> shadow$getPlayers();

    @Shadow
    protected abstract void shadow$saveLevel() throws SessionLockException;

    @Override
    public boolean bridge$isLoaded() {
        if (this.bridge$isFake()) {
            return false;
        }
        net.minecraft.world.server.ServerWorld world = ((SpongeWorldManager)((Server)this.shadow$getServer()).getWorldManager()).getWorld(this.shadow$getDimension().getType());
        if (world == null) {
            return false;
        }
        return world == this;
    }

    @Override
    public void bridge$adjustDimensionLogic(SpongeDimensionType dimensionType) {
        if (this.bridge$isFake()) {
            return;
        }
        super.bridge$adjustDimensionLogic(dimensionType);
        ChunkGenerator chunkGenerator = this.dimension.createChunkGenerator();
        ((ServerChunkProviderAccessor)this.chunkProvider).accessor$setChunkGenerator(chunkGenerator);
        ((ChunkManagerAccessor)((ServerChunkProvider)this.chunkProvider).chunkManager).accessor$setChunkGenerator(chunkGenerator);
        for (ServerPlayerEntity player : this.shadow$getPlayers()) {
            ((ServerPlayerEntityBridge)player).bridge$sendViewerEnvironment(dimensionType);
        }
    }

    @Override
    public CustomServerBossInfoManager bridge$getBossBarManager() {
        if (this.impl$bossBarManager == null) {
            this.impl$bossBarManager = this.dimension.getType() == DimensionType.OVERWORLD || this.bridge$isFake() ? this.shadow$getServer().getCustomBossEvents() : new CustomServerBossInfoManager(this.shadow$getServer());
        }
        return this.impl$bossBarManager;
    }

    @Override
    public void bridge$addEntityRotationUpdate(Entity entity, Vector3d rotation) {
        this.impl$rotationUpdates.put(entity, rotation);
    }

    @Override
    public void bridge$updateRotation(Entity entityIn) {
        Vector3d rotationUpdate = this.impl$rotationUpdates.get(entityIn);
        if (rotationUpdate != null) {
            entityIn.rotationPitch = (float)rotationUpdate.getX();
            entityIn.rotationYaw = (float)rotationUpdate.getY();
        }
        this.impl$rotationUpdates.remove(entityIn);
    }

    @Override
    public void bridge$setWeather(Weather weather, long ticks) {
        if (weather == Weathers.CLEAR.get()) {
            this.worldInfo.setClearWeatherTime((int)Math.max(Integer.MAX_VALUE, ticks));
            this.worldInfo.setRainTime(0);
            this.worldInfo.setThunderTime(0);
            this.worldInfo.setRaining(false);
            this.worldInfo.setThundering(false);
        } else if (weather == Weathers.RAIN.get()) {
            this.worldInfo.setClearWeatherTime(0);
            this.worldInfo.setRainTime((int)Math.max(Integer.MAX_VALUE, ticks));
            this.worldInfo.setThunderTime((int)Math.max(Integer.MAX_VALUE, ticks));
            this.worldInfo.setRaining(true);
            this.worldInfo.setThundering(false);
        } else if (weather == Weathers.THUNDER.get()) {
            this.worldInfo.setClearWeatherTime(0);
            this.worldInfo.setRainTime((int)Math.max(Integer.MAX_VALUE, ticks));
            this.worldInfo.setThunderTime((int)Math.max(Integer.MAX_VALUE, ticks));
            this.worldInfo.setRaining(true);
            this.worldInfo.setThundering(true);
        }
    }

    @Override
    public long bridge$getDurationInTicks() {
        if (this.shadow$isThundering()) {
            return this.worldInfo.getThunderTime();
        }
        if (this.shadow$isRaining()) {
            return this.worldInfo.getRainTime();
        }
        if (this.worldInfo.getClearWeatherTime() > 0) {
            return this.worldInfo.getClearWeatherTime();
        }
        return Math.min(this.worldInfo.getThunderTime(), this.worldInfo.getRainTime());
    }

    @Override
    public void bridge$triggerExplosion(org.spongepowered.api.world.explosion.Explosion explosion) {
        Explosion mcExplosion;
        ExplosionEvent.Pre event = SpongeEventFactory.createExplosionEventPre(PhaseTracker.getCauseStackManager().getCurrentCause(), explosion, (ServerWorld)((Object)this));
        if (SpongeCommon.postEvent(event)) {
            return;
        }
        explosion = event.getExplosion();
        try {
            mcExplosion = (Explosion)explosion;
        }
        catch (Exception e) {
            new PrettyPrinter(60).add("Explosion not compatible with this implementation").centre().hr().add("An explosion that was expected to be used for this implementation does not").add("originate from this implementation.").add((Throwable)e).trace();
            return;
        }
        try (Object ignored = GeneralPhase.State.EXPLOSION.createPhaseContext(PhaseTracker.SERVER).explosion((Explosion)explosion).source(explosion.getSourceExplosive().isPresent() ? explosion.getSourceExplosive() : this);){
            ((PhaseContext)ignored).buildAndSwitch();
            boolean shouldBreakBlocks = explosion.shouldBreakBlocks();
            mcExplosion.doExplosionA();
            mcExplosion.doExplosionB(true);
            if (!shouldBreakBlocks) {
                mcExplosion.clearAffectedBlockPositions();
            }
        }
    }

    @Override
    public void bridge$setManualSave(boolean state) {
        this.impl$isManualSave = state;
    }

    @Overwrite
    public void save(@Nullable IProgressUpdate progress, boolean flush, boolean skipSave) throws SessionLockException {
        net.minecraft.world.server.ServerWorld this$ = (net.minecraft.world.server.ServerWorld)this;
        ServerChunkProvider serverchunkprovider = this$.getChunkProvider();
        if (!skipSave) {
            boolean canManuallySave;
            SerializationBehavior behavior = ((WorldInfoBridge)this$.getWorldInfo()).bridge$getSerializationBehavior();
            if (progress != null) {
                progress.displaySavingString((ITextComponent)new TranslationTextComponent("menu.savingLevel", new Object[0]));
            }
            if (behavior != SerializationBehavior.NONE) {
                this.shadow$saveLevel();
                this.getWorldBorder().copyTo(this$.getWorldInfo());
                this$.getWorldInfo().setCustomBossEvents(((ServerWorldBridge)this$).bridge$getBossBarManager().write());
                this$.getSaveHandler().saveWorldInfoWithPlayer(this$.getWorldInfo(), this.shadow$getDimension().getType() == DimensionType.OVERWORLD ? this.shadow$getServer().getPlayerList().getHostPlayerData() : null);
            }
            if (progress != null) {
                progress.displayLoadingString((ITextComponent)new TranslationTextComponent("menu.savingChunks", new Object[0]));
            }
            boolean canAutomaticallySave = !this.impl$isManualSave && behavior == SerializationBehavior.AUTOMATIC;
            boolean bl = canManuallySave = this.impl$isManualSave && behavior == SerializationBehavior.MANUAL;
            if (canAutomaticallySave || canManuallySave) {
                serverchunkprovider.save(flush);
            }
        }
        this.impl$isManualSave = false;
    }

    public String toString() {
        return new StringJoiner(",", net.minecraft.world.server.ServerWorld.class.getSimpleName() + "[", "]").add("key=" + ((ServerWorld)((Object)this)).getKey()).add("dimensionType=" + Registry.DIMENSION_TYPE.getKey((Object)this.shadow$getDimension().getType())).toString();
    }
}

