/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.spawner;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.entity.player.PlayerEntityBridge;
import org.spongepowered.common.bridge.world.spawner.AbstractSpawnerBridge;

@Mixin(value={AbstractSpawner.class})
public abstract class AbstractSpawnerMixin
implements AbstractSpawnerBridge {
    @Shadow
    private int spawnDelay;
    @Shadow
    private int minSpawnDelay;
    @Shadow
    private int maxSpawnDelay;
    @Shadow
    private int spawnCount;
    @Shadow
    private int maxNearbyEntities;
    @Shadow
    private int activatingRangeFromPlayer;
    @Shadow
    private int spawnRange;

    @Override
    public int bridge$getSpawnDelay() {
        return this.spawnDelay;
    }

    @Override
    public void bridge$setSpawnDelay(int spawnDelay) {
        this.spawnDelay = spawnDelay;
    }

    @Override
    public int bridge$getMinSpawnDelay() {
        return this.minSpawnDelay;
    }

    @Override
    public int bridge$getMaxSpawnDelay() {
        return this.maxSpawnDelay;
    }

    @Override
    public int bridge$getSpawnCount() {
        return this.spawnCount;
    }

    @Override
    public int bridge$getMaxNearbyEntities() {
        return this.maxNearbyEntities;
    }

    @Override
    public void bridge$setMaxNearbyEntities(int maxNearbyEntities) {
        this.maxNearbyEntities = maxNearbyEntities;
    }

    @Override
    public int bridge$getActivatingRangeFromPlayer() {
        return this.activatingRangeFromPlayer;
    }

    @Override
    public int bridge$getSpawnRange() {
        return this.spawnRange;
    }

    @Redirect(method={"isActivated()Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;isPlayerWithin(DDDD)Z"))
    public boolean onIsPlayerWithin(World world, double x, double y, double z, double distance) {
        for (PlayerEntity playerentity : world.getPlayers()) {
            if (!EntityPredicates.NOT_SPECTATING.test(playerentity) || !EntityPredicates.IS_LIVING_ALIVE.test(playerentity) || !((PlayerEntityBridge)playerentity).bridge$affectsSpawning()) continue;
            double d0 = playerentity.getDistanceSq(x, y, z);
            if (!(distance < 0.0) && !(d0 < distance * distance)) continue;
            return true;
        }
        return false;
    }
}

