/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.entitycollision.block;

import net.minecraft.block.Block;
import net.minecraft.world.World;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.applaunch.config.common.CommonConfig;
import org.spongepowered.common.applaunch.config.core.ConfigHandle;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.entitycollision.CollisionCapabilityBridge;
import org.spongepowered.common.bridge.world.storage.WorldInfoBridge;
import org.spongepowered.common.config.inheritable.CollisionModCategory;
import org.spongepowered.common.config.inheritable.EntityCollisionCategory;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;

@Mixin(value={Block.class})
public abstract class BlockMixin_EntityCollision
implements CollisionCapabilityBridge {
    private int entityCollision$maxCollisions = 8;
    private boolean entityCollision$refreshCache = true;

    @Override
    public ResourceKey collision$getKey() {
        return ((BlockType)((Object)this)).getKey();
    }

    @Override
    public int collision$getMaxCollisions() {
        return this.entityCollision$maxCollisions;
    }

    @Override
    public void collision$setMaxCollisions(int max) {
        this.entityCollision$maxCollisions = max;
    }

    @Override
    public void collision$requiresCollisionsCacheRefresh(boolean flag) {
        this.entityCollision$refreshCache = flag;
    }

    @Override
    public boolean collision$requiresCollisionsCacheRefresh() {
        return this.entityCollision$refreshCache;
    }

    @Override
    public void collision$initializeCollisionState(World world) {
        InheritableConfigHandle<WorldConfig> worldConfigAdapter = ((WorldInfoBridge)world.getWorldInfo()).bridge$getConfigAdapter();
        ConfigHandle<CommonConfig> globalConfigAdapter = SpongeConfigs.getCommon();
        EntityCollisionCategory worldCollCat = ((WorldConfig)worldConfigAdapter.get()).getEntityCollisionCategory();
        this.collision$setMaxCollisions(worldCollCat.getMaxEntitiesWithinAABB());
        boolean requiresSave = false;
        String[] ids = ((BlockType)((Object)this)).getKey().toString().split(":");
        String modId = ids[0];
        String name = ids[1];
        CollisionModCategory worldCollMod = worldConfigAdapter.getOrCreateValue(s2 -> s2.getEntityCollisionCategory().getModList().get(modId), c -> {
            CollisionModCategory globalCollision = new CollisionModCategory(modId);
            c.getEntityCollisionCategory().getModList().put(modId, globalCollision);
            globalCollision.getBlockList().put(name, this.collision$getMaxCollisions());
        }, worldCollCat.autoPopulateData());
        if (worldCollMod != null) {
            Integer blockMaxCollision;
            if (!worldCollMod.isEnabled()) {
                this.collision$setMaxCollisions(-1);
                return;
            }
            Integer modCollisionMax = worldCollMod.getDefaultMaxCollisions().get("blocks");
            if (modCollisionMax != null) {
                this.collision$setMaxCollisions(modCollisionMax);
            }
            if ((blockMaxCollision = worldCollMod.getBlockList().get(name)) == null && worldCollCat.autoPopulateData()) {
                worldCollMod.getBlockList().put(name, this.collision$getMaxCollisions());
                requiresSave = true;
            } else if (blockMaxCollision != null) {
                this.collision$setMaxCollisions(blockMaxCollision);
            }
        }
        if (this.collision$getMaxCollisions() <= 0) {
            return;
        }
        if (requiresSave) {
            globalConfigAdapter.save();
        }
    }
}

