/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.entity;

import java.util.EnumMap;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.entity.ChangeEntityEquipmentEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.bridge.entity.player.PlayerInventoryBridge;
import org.spongepowered.common.event.inventory.InventoryEventFactory;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.comp.HotbarLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.PlayerInventoryLens;
import org.spongepowered.common.inventory.lens.impl.slot.BasicSlotLens;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin_Inventory {
    private final EnumMap<EquipmentSlotType, SlotLens> slotLens = new EnumMap(EquipmentSlotType.class);

    @Shadow
    public abstract ItemStack getItemStackFromSlot(EquipmentSlotType var1);

    @Shadow
    public abstract void setItemStackToSlot(EquipmentSlotType var1, ItemStack var2);

    @Inject(method={"tick"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getItemStackFromSlot(Lnet/minecraft/inventory/EquipmentSlotType;)Lnet/minecraft/item/ItemStack;")})
    private void inventory$throwInventoryEvent(CallbackInfo ci, int i, int j, EquipmentSlotType[] var3, int var4, int var5, EquipmentSlotType equipmentslottype, ItemStack itemstack) {
        this.inventory$throwInventoryEvent(ci, var3, var4, var5, equipmentslottype, itemstack);
    }

    /*
     * WARNING - void declaration
     */
    @Surrogate
    private void inventory$throwInventoryEvent(CallbackInfo ci, EquipmentSlotType[] var3, int var4, int var5, EquipmentSlotType equipmentslottype, ItemStack itemstack) {
        if (((Entity)this).ticksExisted == 1 && (LivingEntity)this instanceof PlayerEntity) {
            return;
        }
        ItemStack after = this.getItemStackFromSlot(equipmentslottype);
        LivingEntity entity = (LivingEntity)this;
        if (!ItemStack.areItemStacksEqual((ItemStack)after, (ItemStack)itemstack)) {
            Slot slotAdapter;
            if (entity instanceof ServerPlayerEntity) {
                void var10_18;
                PlayerInventoryBridge inventory = (PlayerInventoryBridge)((ServerPlayerEntity)entity).inventory;
                Lens inventoryLens = ((InventoryAdapter)((Object)inventory)).inventoryAdapter$getRootLens();
                Fabric fabric = ((InventoryAdapter)((Object)inventory)).inventoryAdapter$getFabric();
                if (inventoryLens instanceof PlayerInventoryLens) {
                    switch (equipmentslottype) {
                        case OFFHAND: {
                            SlotLens slotLens = ((PlayerInventoryLens)inventoryLens).getOffhandLens();
                            break;
                        }
                        case MAINHAND: {
                            HotbarLens hotbarLens = ((PlayerInventoryLens)inventoryLens).getPrimaryInventoryLens().getHotbar();
                            SlotLens slotLens = hotbarLens.getSlotLens(fabric, hotbarLens.getSelectedSlotIndex(fabric));
                            break;
                        }
                        default: {
                            SlotLens slotLens = ((PlayerInventoryLens)inventoryLens).getEquipmentLens().getSlotLens(fabric, equipmentslottype.getIndex());
                            break;
                        }
                    }
                } else {
                    SlotLens slotLens = inventoryLens.getSlotLens(fabric, equipmentslottype.getIndex());
                }
                slotAdapter = var10_18.getAdapter(fabric, (Inventory)((Object)inventory));
            } else {
                if (this.slotLens.isEmpty()) {
                    for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                        this.slotLens.put(slot, new BasicSlotLens(slot.getSlotIndex()));
                    }
                }
                slotAdapter = this.slotLens.get(equipmentslottype).getAdapter((Fabric)((Object)this), null);
            }
            ChangeEntityEquipmentEvent changeEntityEquipmentEvent = InventoryEventFactory.callChangeEntityEquipmentEvent(entity, ItemStackUtil.snapshotOf(itemstack), ItemStackUtil.snapshotOf(after), (SlotAdapter)slotAdapter);
            if (changeEntityEquipmentEvent.isCancelled()) {
                this.setItemStackToSlot(equipmentslottype, itemstack);
                return;
            }
            Transaction<ItemStackSnapshot> transaction = changeEntityEquipmentEvent.getTransaction();
            if (!transaction.isValid()) {
                this.setItemStackToSlot(equipmentslottype, itemstack);
                return;
            }
            Optional<ItemStackSnapshot> optional = transaction.getCustom();
            if (optional.isPresent()) {
                ItemStack custom = ItemStackUtil.fromSnapshotToNative(optional.get());
                this.setItemStackToSlot(equipmentslottype, custom);
            }
        }
    }
}

