/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.network.play;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.client.CClickWindowPacket;
import net.minecraft.network.play.client.CCreativeInventoryActionPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.inventory.container.TrackedContainerBridge;
import org.spongepowered.common.event.inventory.InventoryEventFactory;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;

@Mixin(value={ServerPlayNetHandler.class})
public class ServerPlayNetHandlerMixin_Inventory {
    @Shadow
    public ServerPlayerEntity player;

    @Inject(method={"processCreativeInventoryAction"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/network/play/client/CCreativeInventoryActionPacket;getSlotId()I", ordinal=1)})
    private void onProcessCreativeInventoryAction(CCreativeInventoryActionPacket packetIn, CallbackInfo ci) {
        boolean flag2;
        ItemStack itemstack = packetIn.getStack();
        boolean bl = flag2 = itemstack.isEmpty() || itemstack.getDamage() >= 0 && itemstack.getCount() <= 64 && !itemstack.isEmpty();
        if (flag2) {
            ClickContainerEvent.Creative clickEvent = InventoryEventFactory.callCreativeClickContainerEvent(this.player, packetIn);
            if (clickEvent.isCancelled()) {
                if (packetIn.getSlotId() >= 0 && packetIn.getSlotId() < this.player.container.inventorySlots.size()) {
                    this.player.connection.sendPacket((IPacket)new SSetSlotPacket(this.player.container.windowId, packetIn.getSlotId(), this.player.container.getSlot(packetIn.getSlotId()).getStack()));
                    this.player.connection.sendPacket((IPacket)new SSetSlotPacket(-1, -1, ItemStack.EMPTY));
                }
                ci.cancel();
            } else {
                Transaction<ItemStackSnapshot> cursorTransaction;
                if (PacketPhaseUtil.handleSlotRestore((PlayerEntity)this.player, (Container)this.player.container, clickEvent.getTransactions(), false)) {
                    ci.cancel();
                }
                if (!(cursorTransaction = clickEvent.getCursorTransaction()).isValid()) {
                    PacketPhaseUtil.handleCustomCursor((PlayerEntity)this.player, cursorTransaction.getOriginal());
                } else if (cursorTransaction.getCustom().isPresent()) {
                    PacketPhaseUtil.handleCustomCursor((PlayerEntity)this.player, cursorTransaction.getFinal());
                }
            }
        }
    }

    @Inject(method={"processClickWindow"}, at={@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/ints/Int2ShortMap;put(IS)S", remap=false)})
    private void impl$updateOpenContainer(CClickWindowPacket packet, CallbackInfo ci) {
        ((TrackedContainerBridge)this.player.openContainer).bridge$detectAndSendChanges(true);
    }
}

