/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.movementcheck.network.play;

import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.ServerPlayNetHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.WorldConfig;

@Mixin(value={ServerPlayNetHandler.class})
public abstract class ServerPlayNetHandlerMixin_MovementCheck {
    @Shadow
    public ServerPlayerEntity player;

    @Redirect(method={"processPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;isInvulnerableDimensionChange()Z", ordinal=0))
    private boolean movementCheck$onPlayerMovedTooQuicklyCheck(ServerPlayerEntity player) {
        if (((WorldConfig)SpongeGameConfigs.getForWorld(this.player.world).get()).getMovementChecks().playerMovedTooQuickly()) {
            return player.isInvulnerableDimensionChange();
        }
        return true;
    }

    @Redirect(method={"processPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;isInvulnerableDimensionChange()Z", ordinal=1))
    private boolean movementCheck$onMovedWronglyCheck(ServerPlayerEntity player) {
        if (((WorldConfig)SpongeGameConfigs.getForWorld(this.player.world).get()).getMovementChecks().movedWrongly()) {
            return player.isInvulnerableDimensionChange();
        }
        return true;
    }

    @ModifyConstant(method={"processVehicleMove"}, constant={@Constant(doubleValue=100.0, ordinal=0)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/util/math/Vec3d;lengthSquared()D", ordinal=1), to=@At(value="INVOKE", target="Lnet/minecraft/network/play/ServerPlayNetHandler;isServerOwner()Z", ordinal=0))})
    private double movementCheck$onVehicleMovedTooQuicklyCheck(double val) {
        if (((WorldConfig)SpongeGameConfigs.getForWorld(this.player.world).get()).getMovementChecks().playerVehicleMovedTooQuickly()) {
            return val;
        }
        return Double.NaN;
    }

    @ModifyConstant(method={"processVehicleMove"}, constant={@Constant(doubleValue=0.0625, ordinal=0)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;move(Lnet/minecraft/entity/MoverType;Lnet/minecraft/util/math/Vec3d;)V", ordinal=0), to=@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;)V", ordinal=0, remap=false))})
    private double movementCheck$onMovedWronglySecond(double val) {
        if (((WorldConfig)SpongeGameConfigs.getForWorld(this.player.world).get()).getMovementChecks().movedWrongly()) {
            return val;
        }
        return Double.NaN;
    }
}

