/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.optimization.mcp.block;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LeavesBlock.class})
public abstract class LeavesBlockMixin_DisablePersistentScheduledUpdate {
    @Shadow
    @Final
    public static IntegerProperty DISTANCE;
    @Shadow
    @Final
    public static BooleanProperty PERSISTENT;

    @Shadow
    protected abstract int shadow$getDistance(BlockState var1);

    @Overwrite
    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        int i = this.shadow$getDistance(facingState) + 1;
        if (i != 1 || (Integer)stateIn.get((IProperty)DISTANCE) != i) {
            if (((Boolean)facingState.get((IProperty)PERSISTENT)).booleanValue()) {
                return (BlockState)facingState.with((IProperty)DISTANCE, (Comparable)Integer.valueOf(i));
            }
            worldIn.getPendingBlockTicks().scheduleTick(currentPos, (Object)((LeavesBlock)this), 1);
        }
        return stateIn;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void optimization$disableTickForPersistentLeaves(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand, CallbackInfo ci) {
        if (((Boolean)state.get((IProperty)PERSISTENT)).booleanValue()) {
            ci.cancel();
        }
    }
}

