/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.optimization.mcp.world.server;

import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.optimization.mcp.world.WorldMixin_Optimization_Collision;

@Mixin(value={ServerWorld.class}, priority=1500)
public abstract class ServerWorldMixin_Optimization_Collision
extends WorldMixin_Optimization_Collision {
    @Override
    public boolean isFlammableWithin(AxisAlignedBB bb) {
        if (((WorldBridge)((Object)this)).bridge$isFake()) {
            return super.isFlammableWithin(bb);
        }
        Optional<ActiveChunkReferantBridge> source = PhaseTracker.getInstance().getPhaseContext().getSource(Entity.class).map(entity -> (ActiveChunkReferantBridge)entity);
        if (source.isPresent()) {
            ChunkBridge activeChunk = source.get().bridge$getActiveChunk();
            if (activeChunk == null || activeChunk.bridge$isQueuedForUnload() || !activeChunk.bridge$areNeighborsLoaded()) {
                return false;
            }
        } else {
            int zEnd;
            int xStart = MathHelper.floor((double)bb.minX);
            int xEnd = MathHelper.ceil((double)bb.maxX);
            int yStart = MathHelper.floor((double)bb.minY);
            int yEnd = MathHelper.ceil((double)bb.maxY);
            int zStart = MathHelper.floor((double)bb.minZ);
            if (!((ServerWorld)this).isAreaLoaded(xStart, yStart, zStart, xEnd, yEnd, zEnd = MathHelper.ceil((double)bb.maxZ))) {
                return false;
            }
        }
        return super.isFlammableWithin(bb);
    }
}

