/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.plugin;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.applaunch.config.common.CommonConfig;
import org.spongepowered.common.applaunch.config.common.OptimizationCategory;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;

public class OptimizationPlugin
implements IMixinConfigPlugin {
    private static final Map<String, Function<OptimizationCategory, Boolean>> mixinEnabledMappings = ImmutableMap.builder().put((Object)"org.spongepowered.common.mixin.optimization.SpongeImplHooksMixin_Item_Pre_Merge", OptimizationCategory::doDropsPreMergeItemDrops).put((Object)"org.spongepowered.common.mixin.optimization.mcp.block.BlockRedstoneWireMixin_Eigen", OptimizationCategory::useEigenRedstone).put((Object)"org.spongepowered.common.accessor.block.BlockRedstoneWireAccessor_Eigen", OptimizationCategory::useEigenRedstone).put((Object)"org.spongepowered.common.mixin.optimization.mcp.entity.EntityMixinTameable_Cached_Owner", OptimizationCategory::useCacheTameableOwners).put((Object)"org.spongepowered.common.mixin.invalid.optimization.world.gen.structure.MapGenStructureMixin_Structure_Saving", OptimizationCategory::useStructureSave).put((Object)"org.spongepowered.common.mixin.optimization.mcp.entity.item.EntityItemFrameMixin_MapOptimization", OptimizationCategory::useMapOptimization).put((Object)"org.spongepowered.common.mixin.invalid.optimization.entity.EntityTrackerEntryMixin_MapOptimization", OptimizationCategory::useMapOptimization).put((Object)"org.spongepowered.common.mixin.optimization.mcp.item.ItemMapMixin_MapOptimization", OptimizationCategory::useMapOptimization).put((Object)"org.spongepowered.common.mixin.optimization.mcp.world.storage.MapDataMixin_MapOptimization", OptimizationCategory::useMapOptimization).put((Object)"org.spongepowered.common.mixin.optimization.mcp.world.storage.MapInfoMixin_MapOptimization", OptimizationCategory::useMapOptimization).put((Object)"org.spongepowered.common.mixin.optimization.mcp.server.MinecraftServerMixin_MapOptimization", OptimizationCategory::useMapOptimization).put((Object)"org.spongepowered.common.mixin.optimization.mcp.tileentity.TileEntityMixin_HopperOptimization", OptimizationCategory::isOptimizeHoppers).put((Object)"org.spongepowered.common.mixin.optimization.mcp.tileentity.TileEntityHopperMixin_HopperOptimization", OptimizationCategory::isOptimizeHoppers).put((Object)"org.spongepowered.common.mixin.optimization.mcp.entity.EntityMixin_UseActiveChunkForCollisions", OptimizationCategory::isUseActiveChunkForCollisions).put((Object)"org.spongepowered.common.mixin.optimization.mcp.world.WorldMixin_UseActiveChunkForCollisions", OptimizationCategory::isUseActiveChunkForCollisions).put((Object)"org.spongepowered.common.mixin.optimization.mcp.world.WorldServerMixin_UseActiveChunkForCollisions", OptimizationCategory::isUseActiveChunkForCollisions).put((Object)"org.spongepowered.common.mixin.optimization.mcp.tileentity.ChestTileEntityMixin_Optimization_TileEntity", OptimizationCategory::isOptimizedTileEntityTicking).put((Object)"org.spongepowered.common.mixin.optimization.mcp.tileentity.EnderChestTileEntityMixin_Optimization_TileEntity", OptimizationCategory::isOptimizedTileEntityTicking).put((Object)"org.spongepowered.common.mixin.optimization.mcp.block.LeavesBlockMixin_DisablePersistentScheduledUpdate", OptimizationCategory::isDisableLeafBlockScheduledUpdatesForPersistedLeaves).build();

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        CommonConfig globalConfig = SpongeConfigs.getCommon().get();
        if (globalConfig.getModules().useOptimizations()) {
            Function<OptimizationCategory, Boolean> optimizationCategoryBooleanFunction = mixinEnabledMappings.get(mixinClassName);
            if (optimizationCategoryBooleanFunction == null) {
                new PrettyPrinter(50).add("Could not find function for optimization patch").centre().hr().add("Missing function for class: " + mixinClassName).trace();
                return false;
            }
            return optimizationCategoryBooleanFunction.apply(globalConfig.getOptimizations());
        }
        return false;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

