/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.realtime.tileentity;

import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.util.math.MathHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.common.bridge.RealTimeTrackingBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.mixin.core.tileentity.TileEntityMixin;

@Mixin(value={AbstractFurnaceTileEntity.class}, priority=1001)
public abstract class AbstractFurnaceTileEntityMixin_RealTime
extends TileEntityMixin {
    @Shadow
    private int burnTime;
    @Shadow
    private int cookTime;
    @Shadow
    private int cookTimeTotal;

    @Redirect(method={"tick"}, at=@At(value="FIELD", target="Lnet/minecraft/tileentity/AbstractFurnaceTileEntity;burnTime:I", opcode=181), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/tileentity/AbstractFurnaceTileEntity;isBurning()Z", opcode=1), to=@At(value="FIELD", target="Lnet/minecraft/tileentity/AbstractFurnaceTileEntity;world:Lnet/minecraft/world/World;", opcode=180, ordinal=0)))
    private void realTimeImpl$adjustForRealTimeBurnTime(AbstractFurnaceTileEntity self, int modifier) {
        if (((WorldBridge)this.world).bridge$isFake()) {
            this.burnTime = modifier;
            return;
        }
        int ticks = (int)((RealTimeTrackingBridge)this.world).realTimeBridge$getRealTimeTicks();
        this.burnTime = Math.max(0, this.burnTime - Math.max(1, ticks - 1));
    }

    @Redirect(method={"tick"}, at=@At(value="FIELD", target="Lnet/minecraft/tileentity/AbstractFurnaceTileEntity;cookTime:I", opcode=181), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/tileentity/AbstractFurnaceTileEntity;canSmelt(Lnet/minecraft/item/crafting/IRecipe;)Z", ordinal=1), to=@At(value="FIELD", target="Lnet/minecraft/tileentity/AbstractFurnaceTileEntity;cookTimeTotal:I", opcode=180, ordinal=0)))
    private void realTimeImpl$adjustForRealTimeCookTime(AbstractFurnaceTileEntity self, int modifier) {
        if (((WorldBridge)this.world).bridge$isFake()) {
            this.cookTime = modifier;
            return;
        }
        int ticks = (int)((RealTimeTrackingBridge)this.world).realTimeBridge$getRealTimeTicks();
        this.cookTime = Math.min(this.cookTimeTotal, this.cookTime + ticks);
    }

    @Redirect(method={"tick"}, at=@At(value="FIELD", target="Lnet/minecraft/tileentity/AbstractFurnaceTileEntity;cookTime:I", opcode=181), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;clamp(III)I"), to=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;I)Z")))
    private void realTimeImpl$adjustForRealTimeCookTimeCooldown(AbstractFurnaceTileEntity self, int modifier) {
        if (((WorldBridge)this.world).bridge$isFake()) {
            this.cookTime = modifier;
            return;
        }
        int ticks = (int)((RealTimeTrackingBridge)this.world).realTimeBridge$getRealTimeTicks();
        this.cookTime = MathHelper.clamp((int)(this.cookTime - 2 * ticks), (int)0, (int)this.cookTimeTotal);
    }
}

