/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.block;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.ProxyBlockSource;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={DispenserBlock.class})
public class DispenserBlockMixin_Tracker {
    private ItemStack tracker$originalItem = ItemStack.EMPTY;
    private PhaseContext<?> tracker$context = PhaseContext.empty();

    @Inject(method={"dispense"}, at={@At(value="HEAD")})
    private void tracker$createContextOnDispensing(World worldIn, BlockPos pos, CallbackInfo ci) {
        BlockState state = worldIn.getBlockState(pos);
        SpongeBlockSnapshot spongeBlockSnapshot = ((TrackedWorldBridge)worldIn).bridge$createSnapshot(state, pos, BlockChangeFlags.ALL);
        ChunkBridge mixinChunk = (ChunkBridge)worldIn.getChunkAt(pos);
        this.tracker$context = ((PhaseContext)((PhaseContext)((PhaseContext)((PhaseContext)BlockPhase.State.DISPENSE.createPhaseContext(PhaseTracker.SERVER)).source(spongeBlockSnapshot)).creator(() -> mixinChunk.bridge$getBlockCreator(pos))).notifier(() -> mixinChunk.bridge$getBlockNotifier(pos))).buildAndSwitch();
    }

    @Inject(method={"dispense"}, at={@At(value="RETURN")})
    private void tracker$closeContextOnDispensing(World worldIn, BlockPos pos, CallbackInfo ci) {
        this.tracker$context.close();
        this.tracker$context = PhaseContext.empty();
    }

    @Inject(method={"dispense"}, at={@At(value="INVOKE", target="Lnet/minecraft/dispenser/IDispenseItemBehavior;dispense(Lnet/minecraft/dispenser/IBlockSource;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;")}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/dispenser/IDispenseItemBehavior;NOOP:Lnet/minecraft/dispenser/IDispenseItemBehavior;"), to=@At(value="TAIL"))}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void tracker$storeOriginalItem(World worldIn, BlockPos pos, CallbackInfo ci, ProxyBlockSource source, DispenserTileEntity dispenser, int slotIndex, ItemStack dispensedItem, IDispenseItemBehavior behavior) {
        this.tracker$originalItem = ItemStackUtil.cloneDefensiveNative(dispensedItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"dispense"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/DispenserTileEntity;setInventorySlotContents(ILnet/minecraft/item/ItemStack;)V"))
    private void tracker$setInventoryContentsCallEvent(DispenserTileEntity dispenserTileEntity, int index, ItemStack stack) {
        PhaseContext<?> context = PhaseTracker.getInstance().getPhaseContext();
        ItemStack dispensedItem = ItemStack.EMPTY;
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(dispensedItem);
        ArrayList<ItemStackSnapshot> original = new ArrayList<ItemStackSnapshot>();
        original.add(snapshot);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(dispenserTileEntity);
            DropItemEvent.Pre dropEvent = SpongeEventFactory.createDropItemEventPre(frame.getCurrentCause(), (List<ItemStackSnapshot>)ImmutableList.of((Object)snapshot), original);
            SpongeCommon.postEvent(dropEvent);
            if (dropEvent.isCancelled()) {
                dispenserTileEntity.setInventorySlotContents(index, this.tracker$originalItem);
                return;
            }
            dispenserTileEntity.setInventorySlotContents(index, stack);
        }
        finally {
            this.tracker$originalItem = ItemStack.EMPTY;
        }
    }
}

