/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.Server;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.entity.player.ServerPlayerEntityBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.bridge.world.storage.WorldInfoBridge;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.SpongeHooks;
import org.spongepowered.common.hooks.SpongeImplHooks;
import org.spongepowered.common.profile.SpongeGameProfileManager;
import org.spongepowered.common.user.SpongeUserManager;
import org.spongepowered.common.util.Constants;

@Mixin(value={Chunk.class})
public abstract class ChunkMixin_Tracker
implements ChunkBridge {
    @Shadow
    @Final
    private Map<BlockPos, TileEntity> tileEntities;
    private Map<Integer, PlayerTracker> trackertracker$trackedIntBlockPositions = new HashMap<Integer, PlayerTracker>();
    private Map<Short, PlayerTracker> trackertracker$trackedShortBlockPositions = new HashMap<Short, PlayerTracker>();

    @Shadow
    public abstract World shadow$getWorld();

    @Override
    public void bridge$addTrackedBlockPosition(Block block, BlockPos pos, User user, PlayerTracker.Type trackerType) {
        InheritableConfigHandle<WorldConfig> configAdapter;
        if (((WorldBridge)this.shadow$getWorld()).bridge$isFake()) {
            return;
        }
        if (!PhaseTracker.getInstance().getCurrentState().tracksCreatorsAndNotifiers()) {
            return;
        }
        if (user instanceof ServerPlayerEntity && SpongeImplHooks.isFakePlayer((Entity)((ServerPlayerEntity)user.getPlayer().orElse(null)))) {
            return;
        }
        TileEntity tileEntity = this.tileEntities.get(pos);
        if (tileEntity != null && tileEntity instanceof CreatorTrackedBridge) {
            CreatorTrackedBridge creatorBridge = (CreatorTrackedBridge)tileEntity;
            if (trackerType == PlayerTracker.Type.NOTIFIER) {
                if (creatorBridge.tracked$getNotifierReference().orElse(null) == user) {
                    return;
                }
                creatorBridge.tracked$setNotifier(user);
            } else {
                if (creatorBridge.tracked$getCreatorReference().orElse(null) == user) {
                    return;
                }
                creatorBridge.tracked$setCreatorReference(user);
            }
        }
        if (((WorldConfig)(configAdapter = ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getConfigAdapter()).get()).getLogging().blockTrackLogging()) {
            SpongeHooks.logBlockTrack(this.shadow$getWorld(), block, pos, user, !((WorldConfig)configAdapter.get()).getBlockTracking().getBlockBlacklist().contains(((BlockType)block).getKey().toString()));
        }
        WorldInfoBridge infoBridge = (WorldInfoBridge)this.shadow$getWorld().getWorldInfo();
        int indexForUniqueId = infoBridge.bridge$getIndexForUniqueId(user.getUniqueId());
        if (pos.getY() <= 255) {
            short blockPos = Constants.Sponge.blockPosToShort(pos);
            PlayerTracker playerTracker = this.trackertracker$trackedShortBlockPositions.get(blockPos);
            if (playerTracker != null) {
                if (trackerType == PlayerTracker.Type.CREATOR) {
                    playerTracker.creatorindex = indexForUniqueId;
                    playerTracker.notifierIndex = indexForUniqueId;
                } else {
                    playerTracker.notifierIndex = indexForUniqueId;
                }
            } else {
                this.trackertracker$trackedShortBlockPositions.put(blockPos, new PlayerTracker(indexForUniqueId, trackerType));
            }
        } else {
            int blockPos = Constants.Sponge.blockPosToInt(pos);
            PlayerTracker playerTracker = this.trackertracker$trackedIntBlockPositions.get(blockPos);
            if (playerTracker != null) {
                if (trackerType == PlayerTracker.Type.CREATOR) {
                    playerTracker.creatorindex = indexForUniqueId;
                    playerTracker.notifierIndex = indexForUniqueId;
                } else {
                    playerTracker.notifierIndex = indexForUniqueId;
                }
            } else {
                this.trackertracker$trackedIntBlockPositions.put(blockPos, new PlayerTracker(indexForUniqueId, trackerType));
            }
        }
    }

    @Override
    public Map<Integer, PlayerTracker> bridge$getTrackedIntPlayerPositions() {
        return this.trackertracker$trackedIntBlockPositions;
    }

    @Override
    public Map<Short, PlayerTracker> bridge$getTrackedShortPlayerPositions() {
        return this.trackertracker$trackedShortBlockPositions;
    }

    @Override
    public Optional<User> bridge$getBlockCreator(BlockPos pos) {
        if (((WorldBridge)this.shadow$getWorld()).bridge$isFake()) {
            return Optional.empty();
        }
        int intKey = Constants.Sponge.blockPosToInt(pos);
        PlayerTracker intTracker = this.trackertracker$trackedIntBlockPositions.get(intKey);
        if (intTracker != null) {
            int notifierIndex = intTracker.creatorindex;
            return this.tracker$getValidatedUser(intKey, notifierIndex);
        }
        short shortKey = Constants.Sponge.blockPosToShort(pos);
        PlayerTracker shortTracker = this.trackertracker$trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            int notifierIndex = shortTracker.creatorindex;
            return this.tracker$getValidatedUser(shortKey, notifierIndex);
        }
        return Optional.empty();
    }

    @Override
    public Optional<UUID> bridge$getBlockCreatorUUID(BlockPos pos) {
        if (((WorldBridge)this.shadow$getWorld()).bridge$isFake()) {
            return Optional.empty();
        }
        int key = Constants.Sponge.blockPosToInt(pos);
        PlayerTracker intTracker = this.trackertracker$trackedIntBlockPositions.get(key);
        if (intTracker != null) {
            int creatorIndex = intTracker.creatorindex;
            return this.tracker$getValidatedUUID(key, creatorIndex);
        }
        short shortKey = Constants.Sponge.blockPosToShort(pos);
        PlayerTracker shortTracker = this.trackertracker$trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            int creatorIndex = shortTracker.creatorindex;
            return this.tracker$getValidatedUUID(shortKey, creatorIndex);
        }
        return Optional.empty();
    }

    @Override
    public Optional<User> bridge$getBlockNotifier(BlockPos pos) {
        if (((WorldBridge)this.shadow$getWorld()).bridge$isFake()) {
            return Optional.empty();
        }
        int intKey = Constants.Sponge.blockPosToInt(pos);
        PlayerTracker intTracker = this.trackertracker$trackedIntBlockPositions.get(intKey);
        if (intTracker != null) {
            return this.tracker$getValidatedUser(intKey, intTracker.notifierIndex);
        }
        short shortKey = Constants.Sponge.blockPosToShort(pos);
        PlayerTracker shortTracker = this.trackertracker$trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            return this.tracker$getValidatedUser(shortKey, shortTracker.notifierIndex);
        }
        return Optional.empty();
    }

    @Override
    public Optional<UUID> bridge$getBlockNotifierUUID(BlockPos pos) {
        if (((WorldBridge)this.shadow$getWorld()).bridge$isFake()) {
            return Optional.empty();
        }
        int key = Constants.Sponge.blockPosToInt(pos);
        PlayerTracker intTracker = this.trackertracker$trackedIntBlockPositions.get(key);
        if (intTracker != null) {
            return this.tracker$getValidatedUUID(key, intTracker.notifierIndex);
        }
        short shortKey = Constants.Sponge.blockPosToShort(pos);
        PlayerTracker shortTracker = this.trackertracker$trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            return this.tracker$getValidatedUUID(shortKey, shortTracker.notifierIndex);
        }
        return Optional.empty();
    }

    private Optional<User> tracker$getValidatedUser(int key, int creatorIndex) {
        Optional<UUID> uuid = this.tracker$getValidatedUUID(key, creatorIndex);
        if (uuid.isPresent()) {
            UUID userUniqueId = uuid.get();
            PlayerEntity player = this.shadow$getWorld().getPlayerByUuid(userUniqueId);
            if (player != null) {
                return Optional.ofNullable(((ServerPlayerEntityBridge)player).bridge$getUser());
            }
            return this.tracker$getUserFromId(userUniqueId);
        }
        return Optional.empty();
    }

    private Optional<UUID> tracker$getValidatedUUID(int key, int creatorIndex) {
        UUID uuid = ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getUniqueIdForIndex(creatorIndex).orElse(null);
        if (uuid != null) {
            if (SpongeConfigs.getCommon().get().getWorld().getInvalidLookupUuids().contains(uuid)) {
                this.trackertracker$trackedIntBlockPositions.remove(key);
                return Optional.empty();
            }
            return Optional.of(uuid);
        }
        return Optional.empty();
    }

    private Optional<User> tracker$getUserFromId(UUID uuid) {
        SpongeUserManager userManager = this.getUserManager();
        Server server = (Server)this.shadow$getWorld().getServer();
        String username = ((SpongeServer)server).getUsernameCache().getLastKnownUsername(uuid);
        if (username != null && userManager != null) {
            return userManager.get(GameProfile.of(uuid, username));
        }
        GameProfile profile = server.getGameProfileManager().getCache().getById(uuid).orElse(null);
        if (profile != null && userManager != null) {
            return userManager.get(profile);
        }
        ((SpongeGameProfileManager)server.getGameProfileManager()).lookupUserAsync(uuid);
        return Optional.empty();
    }

    @Override
    public void bridge$setBlockNotifier(BlockPos pos, @Nullable UUID uuid) {
        if (((WorldBridge)this.shadow$getWorld()).bridge$isFake()) {
            return;
        }
        if (pos.getY() <= 255) {
            short blockPos = Constants.Sponge.blockPosToShort(pos);
            PlayerTracker shortTracker = this.trackertracker$trackedShortBlockPositions.get(blockPos);
            if (shortTracker != null) {
                shortTracker.notifierIndex = uuid == null ? -1 : ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getIndexForUniqueId(uuid);
            } else {
                this.trackertracker$trackedShortBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getIndexForUniqueId(uuid), PlayerTracker.Type.NOTIFIER));
            }
        } else {
            int blockPos = Constants.Sponge.blockPosToInt(pos);
            PlayerTracker intTracker = this.trackertracker$trackedIntBlockPositions.get(blockPos);
            if (intTracker != null) {
                intTracker.notifierIndex = uuid == null ? -1 : ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getIndexForUniqueId(uuid);
            } else {
                this.trackertracker$trackedIntBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getIndexForUniqueId(uuid), PlayerTracker.Type.NOTIFIER));
            }
        }
    }

    @Override
    public void bridge$setBlockCreator(BlockPos pos, @Nullable UUID uuid) {
        if (((WorldBridge)this.shadow$getWorld()).bridge$isFake()) {
            return;
        }
        if (pos.getY() <= 255) {
            short blockPos = Constants.Sponge.blockPosToShort(pos);
            PlayerTracker shortTracker = this.trackertracker$trackedShortBlockPositions.get(blockPos);
            if (shortTracker != null) {
                shortTracker.creatorindex = uuid == null ? -1 : ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getIndexForUniqueId(uuid);
            } else {
                this.trackertracker$trackedShortBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getIndexForUniqueId(uuid), PlayerTracker.Type.CREATOR));
            }
        } else {
            int blockPos = Constants.Sponge.blockPosToInt(pos);
            PlayerTracker intTracker = this.trackertracker$trackedIntBlockPositions.get(blockPos);
            if (intTracker != null) {
                intTracker.creatorindex = uuid == null ? -1 : ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getIndexForUniqueId(uuid);
            } else {
                this.trackertracker$trackedIntBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getIndexForUniqueId(uuid), PlayerTracker.Type.CREATOR));
            }
        }
    }

    @Override
    public void bridge$setTrackedIntPlayerPositions(Map<Integer, PlayerTracker> trackedPositions) {
        this.trackertracker$trackedIntBlockPositions = trackedPositions;
    }

    @Override
    public void bridge$setTrackedShortPlayerPositions(Map<Short, PlayerTracker> trackedPositions) {
        this.trackertracker$trackedShortBlockPositions = trackedPositions;
    }

    private SpongeUserManager getUserManager() {
        World world = this.shadow$getWorld();
        if (world == null || ((WorldBridge)world).bridge$isFake()) {
            return null;
        }
        return (SpongeUserManager)((Server)world.getServer()).getUserManager();
    }
}

