/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.chunk;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.entity.CollideEntityEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.block.BlockStateBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.chunk.TrackedChunkBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhasePrinter;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.ChunkPipeline;
import org.spongepowered.common.event.tracking.phase.generation.ChunkLoadContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

@Mixin(value={Chunk.class})
public abstract class ChunkMixin_Tracker
implements TrackedChunkBridge {
    @Shadow
    @Final
    public static ChunkSection EMPTY_SECTION;
    @Shadow
    @Final
    private Map<BlockPos, TileEntity> tileEntities;
    @Shadow
    @Final
    private ChunkSection[] sections;
    @Shadow
    @Final
    private Map<Heightmap.Type, Heightmap> heightMap;
    @Shadow
    @Final
    private World world;
    @Shadow
    private volatile boolean dirty;
    private @MonotonicNonNull PhaseContext<@NonNull ?> tracker$postProcessContext = null;

    @Shadow
    public abstract @Nullable TileEntity shadow$getTileEntity(BlockPos var1, Chunk.CreateEntityType var2);

    @Shadow
    public abstract BlockState getBlockState(BlockPos var1);

    @Inject(method={"setBlockState"}, at={@At(value="HEAD")}, cancellable=true)
    private void tracker$sanityCheckServerWorldSetBlockState(BlockPos pos, BlockState state, boolean isMoving, CallbackInfoReturnable<BlockState> cir) {
        if (!((WorldBridge)this.world).bridge$isFake()) {
            new PrettyPrinter(80).add("Illegal Direct Chunk Access").hr().add(new IllegalAccessException("No one should be accessing Chunk.setBlockState in a ServerWorld's environment")).log(PhaseTracker.LOGGER, Level.WARN);
            cir.setReturnValue(null);
        }
    }

    @Override
    public @NonNull ChunkPipeline bridge$createChunkPipeline(BlockPos pos, BlockState newState, BlockState currentState, SpongeBlockChangeFlag flag) {
        boolean isFake = ((WorldBridge)this.world).bridge$isFake();
        if (isFake) {
            throw new IllegalStateException("Cannot call ChunkBridge.bridge$buildChunkPipeline in non-Server managed worlds");
        }
        int xPos = pos.getX() & 0xF;
        int yPos = pos.getY();
        int zPos = pos.getZ() & 0xF;
        ChunkSection chunksection = this.sections[yPos >> 4];
        if (chunksection == EMPTY_SECTION) {
            if (newState.isAir()) {
                return ChunkPipeline.nullReturn((Chunk)this, (ServerWorld)this.world);
            }
            this.sections[yPos >> 4] = chunksection = new ChunkSection(yPos >> 4 << 4);
        }
        PhaseContext<@NonNull ?> context = PhaseTracker.getInstance().getPhaseContext();
        IPhaseState state = context.state;
        @Nullable TileEntity existing = this.shadow$getTileEntity(pos, Chunk.CreateEntityType.CHECK);
        WeakReference<ServerWorld> ref = new WeakReference<ServerWorld>((ServerWorld)this.world);
        SpongeBlockSnapshot snapshot = TrackingUtil.createPooledSnapshot(currentState, pos, flag, existing, () -> (ServerWorld)Objects.requireNonNull(ref.get(), "ServerWorld dereferenced"), Optional::empty, Optional::empty);
        Block newBlock = newState.getBlock();
        Block currentBlock = currentState.getBlock();
        ChangeBlock transaction = state.createTransaction(context, snapshot, newState, flag);
        snapshot.blockChange = state.associateBlockChangeWithSnapshot(context, newState, newBlock, currentState, snapshot, currentBlock);
        if (((BlockStateBridge)((Object)snapshot.getState())).bridge$hasTileEntity() && (snapshot.blockChange == BlockChange.BREAK || snapshot.blockChange == BlockChange.MODIFY)) {
            transaction.queuedRemoval = existing;
        }
        ChunkPipeline.Builder builder = ChunkPipeline.builder().kickOff(transaction).chunk((Chunk)this).chunkSection(chunksection).world((ServerWorld)this.world);
        transaction.populateChunkEffects(builder);
        return builder.build();
    }

    @Inject(method={"addEntity"}, at={@At(value="RETURN")})
    private void tracker$SetActiveChunkOnEntityAdd(Entity entityIn, CallbackInfo ci) {
        ((ActiveChunkReferantBridge)entityIn).bridge$setActiveChunk(this);
    }

    @Inject(method={"removeEntityAtIndex"}, at={@At(value="RETURN")})
    private void tracker$ResetEntityActiveChunk(Entity entityIn, int index, CallbackInfo ci) {
        ((ActiveChunkReferantBridge)entityIn).bridge$setActiveChunk(null);
    }

    @Inject(method={"postProcess"}, at={@At(value="HEAD")})
    private void tracker$startChunkPostProcess(CallbackInfo ci) {
        if (this.tracker$postProcessContext != null) {
            PhasePrinter.printMessageWithCaughtException(PhaseTracker.SERVER, "Expected to not have a chunk post process", "Chunk Post Process has not completed!", GenerationPhase.State.CHUNK_LOADING, this.tracker$postProcessContext, (Throwable)new NullPointerException("spongecommon.ChunkMixin_Tracker:tracker$postProcessContext is Null"));
            this.tracker$postProcessContext.close();
        }
        this.tracker$postProcessContext = ((ChunkLoadContext)GenerationPhase.State.CHUNK_LOADING.createPhaseContext(PhaseTracker.SERVER).chunk((Chunk)this).world(this.world)).buildAndSwitch();
    }

    @Inject(method={"postProcess"}, at={@At(value="RETURN")})
    private void tracker$endChunkPostProcess(CallbackInfo ci) {
        if (this.tracker$postProcessContext == null) {
            PhasePrinter.printMessageWithCaughtException(PhaseTracker.getInstance(), "Expected to complete Chunk Post Process", "Chunk Post Process has a null PhaseContext", new NullPointerException("spongecommon.ChunkMixin_Tracker:tracker$postProcessContext is Null"));
        }
        this.tracker$postProcessContext.close();
        this.tracker$postProcessContext = null;
    }

    @Inject(method={"addTileEntity(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntity;validate()V")})
    private void tracker$SetActiveChunkOnTileEntityAdd(BlockPos pos, TileEntity tileEntityIn, CallbackInfo ci) {
        ((ActiveChunkReferantBridge)tileEntityIn).bridge$setActiveChunk(this);
    }

    @Inject(method={"getEntitiesWithinAABBForEntity"}, at={@At(value="RETURN")})
    private void tracker$ThrowCollisionEvent(Entity entityIn, AxisAlignedBB aabb, List<Entity> listToFill, Predicate<? super Entity> filter, CallbackInfo ci) {
        if (((WorldBridge)this.world).bridge$isFake() || PhaseTracker.getInstance().getCurrentState().isCollision()) {
            return;
        }
        if (listToFill.isEmpty()) {
            return;
        }
        if (!ShouldFire.COLLIDE_ENTITY_EVENT) {
            return;
        }
        CollideEntityEvent event = SpongeCommonEventFactory.callCollideEntityEvent(this.world, entityIn, listToFill);
        if (event == null || event.isCancelled()) {
            if (event == null && !PhaseTracker.getInstance().getCurrentState().isTicking()) {
                return;
            }
            listToFill.clear();
        }
    }
}

