/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.network.IPacket;
import net.minecraft.network.login.ServerLoginNetHandler;
import net.minecraft.network.login.client.CCustomPayloadLoginPacket;
import net.minecraft.network.login.server.SCustomPayloadLoginPacket;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.network.play.server.SCustomPayloadPlayPacket;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Game;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.lifecycle.RegisterChannelEvent;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.channel.Channel;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.ChannelRegistry;
import org.spongepowered.api.network.channel.NoResponseException;
import org.spongepowered.api.network.channel.packet.PacketChannel;
import org.spongepowered.api.network.channel.packet.basic.BasicPacketChannel;
import org.spongepowered.api.network.channel.raw.RawDataChannel;
import org.spongepowered.api.registry.DuplicateRegistrationException;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.network.login.client.CCustomPayloadLoginPacketAccessor;
import org.spongepowered.common.accessor.network.login.server.SCustomPayloadLoginPacketAccessor;
import org.spongepowered.common.accessor.network.play.client.CCustomPayloadPacketAccessor;
import org.spongepowered.common.accessor.network.play.server.SCustomPayloadPlayPacketAccessor;
import org.spongepowered.common.bridge.client.MinecraftBridge;
import org.spongepowered.common.bridge.network.NetworkManagerBridge;
import org.spongepowered.common.entity.player.ClientType;
import org.spongepowered.common.network.channel.ChannelBufferAllocator;
import org.spongepowered.common.network.channel.ChannelBuffers;
import org.spongepowered.common.network.channel.ConnectionUtil;
import org.spongepowered.common.network.channel.PacketSender;
import org.spongepowered.common.network.channel.PacketUtil;
import org.spongepowered.common.network.channel.RegisterChannelUtil;
import org.spongepowered.common.network.channel.SpongeChannel;
import org.spongepowered.common.network.channel.TransactionResult;
import org.spongepowered.common.network.channel.TransactionStore;
import org.spongepowered.common.network.channel.packet.SpongeBasicPacketChannel;
import org.spongepowered.common.network.channel.packet.SpongePacketChannel;
import org.spongepowered.common.network.channel.raw.SpongeRawDataChannel;
import org.spongepowered.common.util.Constants;

public class SpongeChannelRegistry
implements ChannelRegistry {
    private final Map<ResourceKey, SpongeChannel> channels = new HashMap<ResourceKey, SpongeChannel>();
    private final Map<Class<?>, Tuple<Integer, CreateFunction<SpongeChannel>>> channelBuilders = new HashMap();
    private final ChannelBufferAllocator bufferAllocator;

    public SpongeChannelRegistry(ChannelBufferAllocator bufferAllocator) {
        this.bufferAllocator = bufferAllocator;
        this.registerChannelType(0, RawDataChannel.class, SpongeRawDataChannel::new);
        this.registerChannelType(1, PacketChannel.class, SpongePacketChannel::new);
        this.registerChannelType(2, BasicPacketChannel.class, SpongeBasicPacketChannel::new);
    }

    public ChannelBufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    private <T extends Channel> void registerChannelType(int id, Class<T> channelType, CreateFunction<? extends T> builder) {
        this.channelBuilders.put(channelType, Tuple.of(id, builder));
    }

    public <C extends Channel> C createChannel(ResourceKey channelKey, Class<C> channelType) throws DuplicateRegistrationException {
        Objects.requireNonNull(channelKey, "channelKey");
        Objects.requireNonNull(channelType, "channelType");
        if (this.channels.containsKey(channelKey)) {
            throw new DuplicateRegistrationException("The channel key \"" + channelKey + "\" is already in use.");
        }
        Tuple<Integer, CreateFunction<SpongeChannel>> tuple = this.channelBuilders.get(channelType);
        if (tuple == null) {
            throw new IllegalArgumentException("Unsupported channel type: " + channelType);
        }
        SpongeChannel channel = tuple.getSecond().create(tuple.getFirst(), channelKey, this);
        this.channels.put(channelKey, channel);
        return (C)channel;
    }

    @Override
    public Optional<Channel> get(ResourceKey channelKey) {
        Objects.requireNonNull(channelKey, "channelKey");
        return Optional.ofNullable(this.channels.get(channelKey));
    }

    @Override
    public <C extends Channel> C getOfType(ResourceKey channelKey, Class<C> channelType) {
        Objects.requireNonNull(channelKey, "channelKey");
        Objects.requireNonNull(channelType, "channelType");
        Channel binding = this.channels.get(channelKey);
        if (binding != null) {
            if (!channelType.isInstance(binding)) {
                throw new IllegalStateException("There's already a channel registered for " + channelKey + ", but it is not of the requested type " + channelType);
            }
            return (C)binding;
        }
        return this.createChannel(channelKey, channelType);
    }

    @Override
    public Collection<Channel> getChannels() {
        return ImmutableList.copyOf(this.channels.values());
    }

    public void postRegistryEvent() {
        final Cause cause = Cause.of(EventContext.empty(), this);
        RegisterChannelEvent event = new RegisterChannelEvent(){

            @Override
            public <C extends Channel> C register(ResourceKey channelKey, Class<C> channelType) throws DuplicateRegistrationException {
                return SpongeChannelRegistry.this.createChannel(channelKey, channelType);
            }

            @Override
            public Game getGame() {
                return SpongeCommon.getGame();
            }

            @Override
            public Cause getCause() {
                return cause;
            }
        };
        Sponge.getEventManager().post(event);
    }

    public CompletableFuture<Void> requestClientType(EngineConnection connection) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        TransactionStore store = ConnectionUtil.getTransactionStore(connection);
        int transactionId = store.nextId();
        store.put(transactionId, null, new ClientTypeSyncFuture(future));
        ChannelBuf payload = this.bufferAllocator.buffer();
        IPacket<?> mcPacket = PacketUtil.createLoginPayloadRequest(Constants.Channels.SPONGE_CLIENT_TYPE, payload, transactionId);
        PacketSender.sendTo(connection, mcPacket, sendFuture -> {
            if (!sendFuture.isSuccess()) {
                future.completeExceptionally(sendFuture.cause());
            }
        });
        return future;
    }

    private void handleClientType(EngineConnection connection, ChannelBuf payload) {
        ClientType clientType = ClientType.from(payload.readString());
        if (clientType == null) {
            return;
        }
        ((NetworkManagerBridge)((ServerLoginNetHandler)connection).networkManager).bridge$setClientType(clientType);
    }

    public CompletableFuture<Void> sendLoginChannelRegistry(EngineConnection connection) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        TransactionStore store = ConnectionUtil.getTransactionStore(connection);
        int transactionId = store.nextId();
        store.put(transactionId, null, new ChannelRegistrySyncFuture(future));
        ChannelBuf payload = this.encodeChannelRegistry();
        IPacket<?> mcPacket = PacketUtil.createLoginPayloadRequest(Constants.Channels.SPONGE_CHANNEL_REGISTRY, payload, transactionId);
        PacketSender.sendTo(connection, mcPacket, sendFuture -> {
            if (!sendFuture.isSuccess()) {
                future.completeExceptionally(sendFuture.cause());
            }
        });
        return future;
    }

    public void sendChannelRegistrations(EngineConnection connection) {
        ChannelBuf payload = RegisterChannelUtil.encodePayload(this.channels.keySet());
        IPacket<?> mcPacket = PacketUtil.createPlayPayload(Constants.Channels.REGISTER_KEY, payload, connection.getSide());
        PacketSender.sendTo(connection, mcPacket);
    }

    private ChannelBuf encodeChannelRegistry() {
        ImmutableList channels = ImmutableList.copyOf(this.channels.values());
        ChannelBuf buf = this.bufferAllocator.buffer();
        buf.writeVarInt(channels.size());
        for (SpongeChannel channel : channels) {
            buf.writeString(channel.getKey().getFormatted());
            buf.writeByte((byte)channel.getType());
        }
        return buf;
    }

    private void handleChannelRegistry(EngineConnection connection, ChannelBuf payload) {
        Set<ResourceKey> registered = ConnectionUtil.getRegisteredChannels(connection);
        registered.clear();
        int count = payload.readVarInt();
        for (int i = 0; i < count; ++i) {
            ResourceKey key = ResourceKey.resolve(payload.readString());
            payload.readByte();
            registered.add(key);
        }
    }

    public boolean handlePlayPayload(EngineConnection connection, CCustomPayloadPacket packet) {
        CCustomPayloadPacketAccessor accessor = (CCustomPayloadPacketAccessor)packet;
        ResourceKey channel = (ResourceKey)accessor.accessor$getChannel();
        ChannelBuf payload = (ChannelBuf)accessor.accessor$getPayload();
        return this.handlePlayPayload(connection, channel, payload);
    }

    public boolean handlePlayPayload(EngineConnection connection, SCustomPayloadPlayPacket packet) {
        SCustomPayloadPlayPacketAccessor accessor = (SCustomPayloadPlayPacketAccessor)packet;
        ResourceKey channel = (ResourceKey)accessor.accessor$getChannel();
        ChannelBuf payload = (ChannelBuf)accessor.accessor$getPayload();
        return this.handlePlayPayload(connection, channel, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRegisterChannel(EngineConnection connection, ChannelBuf payload, BiConsumer<Set<ResourceKey>, List<ResourceKey>> consumer) {
        Set<ResourceKey> registered = ConnectionUtil.getRegisteredChannels(connection);
        int readerIndex = payload.readerIndex();
        try {
            List<ResourceKey> modified = RegisterChannelUtil.decodePayload(payload);
            consumer.accept(registered, modified);
        }
        finally {
            payload.readerIndex(readerIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handlePlayPayload(EngineConnection connection, ResourceKey channelKey, ChannelBuf payload) {
        if (channelKey.equals(Constants.Channels.SPONGE_CLIENT_TYPE)) {
            this.handleClientType(connection, payload);
            return true;
        }
        if (channelKey.equals(Constants.Channels.SPONGE_CHANNEL_REGISTRY)) {
            this.handleChannelRegistry(connection, payload);
            return true;
        }
        if (channelKey.equals(Constants.Channels.REGISTER_KEY)) {
            this.handleRegisterChannel(connection, payload, Set::addAll);
            return true;
        }
        if (channelKey.equals(Constants.Channels.UNREGISTER_KEY)) {
            this.handleRegisterChannel(connection, payload, Set::removeAll);
            return true;
        }
        SpongeChannel channel = this.channels.get(channelKey);
        if (channel != null) {
            try {
                channel.handlePlayPayload(connection, payload);
            }
            finally {
                ChannelBuffers.release(payload);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleLoginRequestPayload(EngineConnection connection, SCustomPayloadLoginPacket packet) {
        SCustomPayloadLoginPacketAccessor accessor = (SCustomPayloadLoginPacketAccessor)packet;
        ResourceKey channel = (ResourceKey)accessor.accessor$getChannel();
        int transactionId = accessor.accessor$getTransactionId();
        ChannelBuf payload = (ChannelBuf)accessor.accessor$getPayload();
        try {
            boolean bl = this.handleLoginRequestPayload(connection, channel, transactionId, payload);
            return bl;
        }
        finally {
            ChannelBuffers.release(payload);
        }
    }

    private boolean handleLoginRequestPayload(EngineConnection connection, ResourceKey channelKey, int transactionId, ChannelBuf payload) {
        SpongeChannel channel;
        if (channelKey.equals(Constants.Channels.SPONGE_CLIENT_TYPE)) {
            ClientType clientType = ((MinecraftBridge)((Object)Sponge.getClient())).bridge$getClientType();
            ChannelBuf responsePayload = this.bufferAllocator.buffer();
            responsePayload.writeString(clientType.getName());
            IPacket<?> mcPacket = PacketUtil.createLoginPayloadResponse(responsePayload, transactionId);
            PacketSender.sendTo(connection, mcPacket);
            return true;
        }
        if (channelKey.equals(Constants.Channels.SPONGE_CHANNEL_REGISTRY)) {
            this.handleChannelRegistry(connection, payload);
            ChannelBuf responsePayload = this.encodeChannelRegistry();
            IPacket<?> mcPacket = PacketUtil.createLoginPayloadResponse(responsePayload, transactionId);
            PacketSender.sendTo(connection, mcPacket);
            return true;
        }
        ResourceKey actualChannelKey = channelKey;
        ChannelBuf actualPayload = payload;
        if (channelKey.equals(Constants.Channels.FML_LOGIN_WRAPPER_CHANNEL)) {
            actualChannelKey = ResourceKey.resolve(payload.readString());
            int length = payload.readVarInt();
            actualPayload = payload.readSlice(length);
        }
        if ((channel = this.channels.get(actualChannelKey)) != null) {
            channel.handleLoginRequestPayload(connection, transactionId, actualPayload);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleLoginResponsePayload(EngineConnection connection, CCustomPayloadLoginPacket packet) {
        CCustomPayloadLoginPacketAccessor accessor = (CCustomPayloadLoginPacketAccessor)packet;
        int transactionId = accessor.accessor$getTransactionId();
        ChannelBuf payload = (ChannelBuf)accessor.accessor$getPayload();
        try {
            this.handleLoginResponsePayload(connection, transactionId, payload);
        }
        finally {
            if (payload != null) {
                ChannelBuffers.release(payload);
            }
        }
    }

    private void handleLoginResponsePayload(EngineConnection connection, int transactionId, @Nullable ChannelBuf payload) {
        if (transactionId == 0x7FFFFFFE) {
            return;
        }
        if (transactionId == Integer.MAX_VALUE) {
            if (payload != null) {
                ResourceKey channelKey = ResourceKey.resolve(payload.readString());
                this.handlePlayPayload(connection, channelKey, payload);
            }
            return;
        }
        TransactionStore transactionStore = ConnectionUtil.getTransactionStore(connection);
        TransactionStore.Entry entry = transactionStore.remove(transactionId);
        if (entry == null) {
            return;
        }
        if (entry.getData() instanceof ClientTypeSyncFuture) {
            if (payload != null) {
                this.handleClientType(connection, payload);
            }
            ((ClientTypeSyncFuture)entry.getData()).future.complete(null);
            return;
        }
        if (entry.getData() instanceof ChannelRegistrySyncFuture) {
            if (payload != null) {
                this.handleChannelRegistry(connection, payload);
            }
            ((ChannelRegistrySyncFuture)entry.getData()).future.complete(null);
            return;
        }
        TransactionResult result = payload == null ? TransactionResult.failure(new NoResponseException()) : TransactionResult.success(payload);
        entry.getChannel().handleTransactionResponse(connection, entry.getData(), result);
    }

    private static final class ClientTypeSyncFuture {
        private final CompletableFuture<Void> future;

        private ClientTypeSyncFuture(CompletableFuture<Void> future) {
            this.future = future;
        }
    }

    private static final class ChannelRegistrySyncFuture {
        private final CompletableFuture<Void> future;

        private ChannelRegistrySyncFuture(CompletableFuture<Void> future) {
            this.future = future;
        }
    }

    static interface CreateFunction<C extends Channel> {
        public C create(int var1, ResourceKey var2, SpongeChannelRegistry var3);
    }
}

